package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class MotoristProviderEvent_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_MotoristProviderEvent = null;
	private ProviderConfiguration confEndpointFor_MotoristProviderEvent = null;
	private AbstractImplementationManager<?> im = null;
	
	public MotoristProviderEvent_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_MotoristProviderEvent() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9108/motoristProviderEventPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_MotoristProviderEvent() {
		if(this.confEndpointFor_MotoristProviderEvent == null) {
			this.confEndpointFor_MotoristProviderEvent = createDefaultProviderConfigurationFor_MotoristProviderEvent();
		}
		return this.confEndpointFor_MotoristProviderEvent;
	}


	public void start() throws WSOUIException {
		confEndpointFor_MotoristProviderEvent = getProviderConfigurationFor_MotoristProviderEvent();
		im = new MotoristProviderEventImplementationManager(new MotoristProviderEventTestImplementation(new MotoristProviderEvent_ExchangeProcessor()), MotoristProviderEvent_WSOUIService.getWSDL_LOCATION(), confEndpointFor_MotoristProviderEvent);
		endpointFor_MotoristProviderEvent = Endpoint.publish(confEndpointFor_MotoristProviderEvent.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_MotoristProviderEvent.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_MotoristProviderEvent);
	}


	public void stop() {
		if(endpointFor_MotoristProviderEvent != null) {
			endpointFor_MotoristProviderEvent.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		MotoristProviderEvent_WSOUIServer provider = new MotoristProviderEvent_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_MotoristProviderEvent().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
