package fr.mines_albi.nuclearcrisisevent.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;

import javax.xml.ws.Endpoint;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration.PositionType;

import com.ebmwebsourcing.easiergov.Main;

public class DriverProviderEvent_WSOUIServer {
	private static String endpointHost = System.getProperty("endpointHost", "localhost");

	private final static String LOGGER_FILE = "/logger.properties";

	static {
		try {
			InputStream inputStream = null;
			File logger = new File("." + LOGGER_FILE);
			if (logger.exists()) {
				inputStream = new FileInputStream(logger);
			} else {
				// ty to get from classpath
				inputStream = Main.class.getClass()
						.getResourceAsStream(LOGGER_FILE);
			}
			if (inputStream != null) {
				LogManager.getLogManager().readConfiguration(inputStream);
				inputStream.close();
			}
		} catch (final Exception e) {
			throw new RuntimeException("couldn't initialize logging properly",
					e);
		}
	}

	
	private Endpoint endpointFor_DriverProviderEvent = null;
	private ProviderConfiguration confEndpointFor_DriverProviderEvent = null;
	private AbstractImplementationManager<?> im = null;
	
	public DriverProviderEvent_WSOUIServer() {
	}


	public ProviderConfiguration createDefaultProviderConfigurationFor_DriverProviderEvent() {
		ProviderConfiguration conf = new ProviderConfiguration();
		conf.setEndpointAddress("http://" + endpointHost + ":9106/driverProviderEventPort");
		conf.setPosition(PositionType.NORTH_EAST);
		conf.setActiveGui(false);
		return conf;
	}


	public ProviderConfiguration getProviderConfigurationFor_DriverProviderEvent() {
		if(this.confEndpointFor_DriverProviderEvent == null) {
			this.confEndpointFor_DriverProviderEvent = createDefaultProviderConfigurationFor_DriverProviderEvent();
		}
		return this.confEndpointFor_DriverProviderEvent;
	}


	public void start() throws WSOUIException {
		confEndpointFor_DriverProviderEvent = getProviderConfigurationFor_DriverProviderEvent();
		im = new DriverProviderEventImplementationManager(new DriverProviderEventTestImplementation(new DriverProviderEvent_ExchangeProcessor()), DriverProviderEvent_WSOUIService.getWSDL_LOCATION(), confEndpointFor_DriverProviderEvent);
		endpointFor_DriverProviderEvent = Endpoint.publish(confEndpointFor_DriverProviderEvent.getEndpointAddress(), im);
		System.out.println("Service deploy at: " + confEndpointFor_DriverProviderEvent.getEndpointAddress() + "?wsdl");
		System.out.println("Service Configuration: " + confEndpointFor_DriverProviderEvent);
	}


	public void stop() {
		if(endpointFor_DriverProviderEvent != null) {
			endpointFor_DriverProviderEvent.stop();
		}
	}


	public Description getDescription() {
		return im.getDescription();
	}


	public static void main(String args[]) throws Exception {
		DriverProviderEvent_WSOUIServer provider = new DriverProviderEvent_WSOUIServer();
		provider.start();
		boolean gui = false;
		if(args.length > 0) {
			System.out.print("Commands args: " + args);
			for(int i=0; i < args.length; i++) {
				System.out.print(args[i]);
			}
			System.out.println();
			gui = Boolean.parseBoolean(args[0]);
			System.out.println("gui = " + gui);
		}
		provider.getProviderConfigurationFor_DriverProviderEvent().setActiveGui(gui);
		System.out.println("Server ready...");
	}

}
