// SOCEDA integration
// ------------------
// -- SeaCloud CLI --
// ------------------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var sccliComponentKey = "sccli";

// !! RUNTIME VARIABLE !!
var sccliBinDir;

function installSCCLI() {
	println("Checking SeaCloud CLI installation ... ");

	// Check if already installed
	var sccliDir = new File(instDir, sccliComponentKey);
	if (!sccliDir.exists() || sccliDir.listFiles().length == 0) {
		println("SeaCloud CLI not found, trying to install ...");
		sccliDir.mkdir();

		// Check if the installer is in origin
		var sccliInstallerFile = new File(originDir, findInstallerNameOfComponent(sccliComponentKey));
		if (!sccliInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(sccliComponentKey);
			println("Trying to download the SeaCloud CLI installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, sccliInstallerFile);
			} catch (e) {
				println("Unable to download the SeaCloud CLI installer " + e.javaStackTrace);
			}
			
			if (!sccliInstallerFile.exists()) {
				throw "Unable to find " + sccliInstallerFile + " please download "
				+ sccliInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();
			}
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(sccliInstallerFile, sccliDir);
		} catch (e) {
			println("Unable to extract SeaCloud CLI binaries " + e.javaStackTrace);
		}
		
		if (sccliDir.listFiles().length == 0) {
			throw "Unable to extract SeaCloud CLI please extract " + sccliInstallerFile + " manually into " + sccliDir;
		}
		
		println("Installation successfull ...");
	}
	
	sccliBinDir = new File(sccliDir, "bin");
	

}

function runDescriptor(descriptorFile) {
	if (sccliBinDir == undefined) {
		throw "Unable to run " + descriptorFile + ", the SeaCloud CLI must be installed first";
	}
	
	if (!sccliBinDir.exists()) {
		throw "Unable to run " + descriptorFile + ", the SeaCloud CLI is not installed correctly, missing " + sccliBinDir;
	}

	// Running sc from bin dir
	// java -jar server.jar -s ..Script.xml
	var cmd = [ javaExe ];
	cmd.push('-jar', 'server.jar', '-s', descriptorFile.getAbsolutePath());
	return execCmdAsync(cmd, sccliBinDir);
}
