// SOCEDA integration
// ---------
// -- DSB --
// ---------

importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);

var recomComponentKey = "recom";
var recomConfigFilename = "recom.config.properties";

function runRECOM() {
	// Perform several checks and run the installation if required

	println("Checking Recommandation WS installation ... ");

	// Check if already installed
	var recomDir = new File(instDir, recomComponentKey);
	if (!recomDir.exists() || recomDir.listFiles().length == 0) {
		println("Recommandation WS not found, trying to install ...");
		recomDir.mkdir();

		// Check if the installer is in origin
		var recomInstallerFile = new File(originDir, findInstallerNameOfComponent(recomComponentKey));
		if (!recomInstallerFile.exists()) {
			
			// Try do download it from the web
			var componentUrl = findDownloadComponentURL(recomComponentKey);
			println("Trying to download the Recommandation WS installer from " + componentUrl);
			println("Please wait ...");
			try {
				downloadFromHttp(componentUrl, recomInstallerFile);
			} catch (e) {
				println("Unable to download the Recommandation WS installer due to " + e.javaException);
			}
			if (!recomInstallerFile.exists()) {
				throw "Unable to find " + recomInstallerFile + " please download "
				+ recomInstallerFile.getName() + " and put it in "
				+ originDir.getAbsolutePath();	
			}						
		}

		// Extract WS binaries from the installer package
		try {
			extractFolder(recomInstallerFile, recomDir);
		} catch (e) {
			println("Unable to extract Recommandation WS binaries " + e.javaStackTrace);
		}
		
		if (recomDir.listFiles().length == 0) {
			throw "Unable to extract Recommandation WS please extract " + sccliInstallerFile + " manually into " + recomDir;
		}
		
		println("Installation successfull ...");
	}

	var binDir = new File(recomDir, "bin");
	
	// Copy config file
	var srcFile = new File(configDir, recomConfigFilename);
	var dstFile = new File(binDir, "config.properties");
	try {
		println("Copying " + srcFile + " into " + dstFile.getParent());		
		copyFile(srcFile, dstFile);
	} catch (e) {
		println("!! Unable to copy " + srcFile + " config file due to " + e);
		if (e.javaStackTrace != undefined) {
			println("!! javaStackTrace: " +  e.javaStackTrace);
		}
	}
	
	deleteLockedFile(binDir);
	
	// Running recom from bin dir
	// java %JAVA_OPTS% %DEBUG_OPTS% -jar xxxx.jar start
	var cmd = [ javaExe ];
	var javaOpts = System.getenv("JAVA_OPTS");
	if (javaOpts != null) {
		cmd.push(javaOpts);
	}
	var debugOpts = System.getenv("DEBUG_OPTS");
	if (debugOpts != null) {
		cmd.push(debugOpts);
	}
	cmd.push('-jar', 'server.jar', 'start');
	return execCmdNewTermAsync("Recommandation WS", cmd, binDir);
}