package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;

public class BatteryEvent extends inEvent {
	protected String level;
	protected String temperature;
	
	public BatteryEvent() {
	}
	public BatteryEvent(String timeStamp, String uniqueId, String sequenceNumber
	) {
		super(timeStamp, uniqueId, sequenceNumber);

		// TODO Auto-generated constructor stub
	}


	public BatteryEvent(String timeStamp, String uniqueId, String sequenceNumber,
			 String level, String temperature) {
		super(timeStamp, uniqueId, sequenceNumber);
		
	
		this.level = level;
		this.temperature = temperature;
		
	}
	
	public String toRDF(String AppID) {
		String pattern05 = AppID;
		String pattern07 = "TaxiUCBattery";
		String pattern09 = "http://streams.event-processing.org/ids/TaxiUCBattery#stream" ;
		String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
		String Footer= "</mt:nativeMessage>\n";
		String str1 = 
			"@prefix :        <http://events.event-processing.org/types/> .\n"+
			"@prefix e:       <http://events.event-processing.org/ids/> .\n"+
			"@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n"+
			"@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n"+
			"@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n"+
			"@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\n"+
			"e:#3# {\n"+
			"e:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\n"+
			"uctelco:uniqueId \"#6#\" ;\n"+
			"uctelco:level \"#10#\" ;\n"+
			"uctelco:temperature \"#11#\" ;\n"+
			"# but also some other data according to event format\n"+
			"a :#7# ;\n"+
			":endTime \"#8#\"^^xsd:dateTime ;\n"+
			":source <http://sources.event-processing.org/ids/#5##source> ;\n"+
			":stream <#9#> ; \n"+
			
			"}\n";
		String avaTemplate=  str1;
		int indexSep = this.uniqueId.indexOf(':');
	
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
		avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
		avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
		avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
		avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ','T'));
		avaTemplate = avaTemplate.replaceFirst("#9#", pattern09 );
		// local part of the event

		avaTemplate = avaTemplate.replaceFirst("#11#", this.level);
		avaTemplate = avaTemplate.replaceFirst("#11#", this.temperature);
	
		String result = Header + avaTemplate + Footer;
		return result;
		}
	
	
	public String getMessage() {
		return temperature;
	}

	public void setMessage(String message) {
		this.temperature = message;
	}

	@Override
	public String toString() {
		return "TwitterEvent [sequenceNumber=" + sequenceNumber
		+ ", timeStamp=" + timeStamp + ", uniqueId=" + uniqueId
		+ ", deviceId="  + ", data=" + level + ", message="
		+ temperature +"]";
	}
	
	
}
