package com.orange.eventData.events.inEvents;

import javax.xml.namespace.QName;

import org.apache.commons.lang3.StringEscapeUtils;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;

/*************************************************************************/
/**
 * <p>
 * This class defines TyreFlatEvent event.
 * </p>
 * <p>
 * for input and output event
 * <p>
 * <p>
 * event defines several properties, that defines an event type :
 * <ul>
 * <li>A payloadJamEvent</li>
 * </ul>
 * </p>
 * 
 * PLAY project - This UnexpectedEvent message is sent by the taxi Driver
 * 
 * @author Philippe Gibert BIZZ/DIAM/EMB
 */

public class TwitterEvent extends inEvent implements MultipleCEPSupport {
	private static final long serialVersionUID = 1939426977290338783L;

	protected String phoneNumber = "";
	protected String userType = ""; 
	
	protected String twId = "";
	protected String message = "";
	protected String status = "";
	
	protected double latitude = -1;
	protected double longitude = -1;
	
	public TwitterEvent() {
	}

	public TwitterEvent(String timeStamp, String uniqueId, String sequenceNumber) {
		super(timeStamp, uniqueId, sequenceNumber);
	}

	public TwitterEvent(String timeStamp, String uniqueId, String sequenceNumber,
			String twId, String message, String status,
			double latitude, double longitude) {
		super(timeStamp, uniqueId, sequenceNumber);

		this.twId = twId;
		this.message = message;
		this.status = status;

		this.latitude = latitude;
		this.longitude = longitude;
	}

	public TwitterEvent(String message) {
		super();
		this.message = message;
	}

	public TwitterEvent(
			String timeStamp, 
			String uniqueId, 
			String sequenceNumber,
			
			String phoneNumber,
			String userType,
			
			String twId, 
			String message, 
			String status,
			
			double latitude, 
			double longitude) {
		super(timeStamp, uniqueId, sequenceNumber);
		
		this.phoneNumber = phoneNumber;
		this.userType = userType;
		
		this.twId = twId;
		this.message = message;
		this.status = status;
		
		this.latitude = latitude;
		this.longitude = longitude;
	}
	
	public String getPhoneNumber() {
		return phoneNumber;
	}
	
	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}
	
	public String getUserType() {
		return userType;
	}
	
	public void setUserType(String userType) {
		this.userType = userType;
	}
	
	public String getTwId() {
		return twId;
	}
	
	public void setTwId(String twId) {
		this.twId = twId;
	}
	
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	public String getStatus() {
		return status;
	}
	
	public void setStatus(String status) {
		this.status = status;
	}
	
	public double getLatitude() {
		return latitude;
	}
	
	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}
	
	public double getLongitude() {
		return longitude;
	}
	
	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}

	public String toString() {
		return "TwitterEvent [sequenceNumber=" + sequenceNumber
		+ ", timeStamp=" + timeStamp + ", uniqueId=" + uniqueId
		+ ", phoneNumber=" + phoneNumber + ", userType=" + userType 
		+ ", twId=" + twId + ", message=" + message + ", status="
		+ status + ", latitude=" + latitude + ", longitude="
		+ longitude + "]";
	}

	public String toXML() {
		return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <TwitterEvent xmlns=\"http://www.orange.org/TaxiEventType\" "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"<userType>"+userType+"</userType>"+
		"<twId>"+twId+"</twId>"+
		"<message>"+message+"</message>"+
		"<status>"+status+"</status>"+
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"</TwitterEvent>";
	}

	public String toWSN() {
		return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "TwitterEvent" + "Topic", "evt"), "<OrangeLabsTaxiUC:TwitterEvent "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xmlns=\"http://www.orangelabs.org/taxiEventTypes\" " +
		"xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"<userType>"+userType+"</userType>"+
		"<twId>"+twId+"</twId>"+
		"<message>"+message+"</message>"+
		"<status>"+status+"</status>"+
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"</OrangeLabsTaxiUC:TwitterEvent>", null, null);
	}

	public String toCEP() {
		return "stream=TwitterEvent,sequenceNumber=" + sequenceNumber
		+ ",timeStamp=" + timeStamp + ",uniqueId=" + uniqueId
		+ ",phoneNumber=" + phoneNumber + ",userType=" + userType 
		+ ",twId=" + twId + ",message=" + message + ",status="
		+ status + ",latitude=" + latitude + ",longitude="
		+ longitude;
	}

	public String getRDFName() {
		return "TaxiUCTwitter";
	}

	public String toRDF(String AppID) {
		String pattern05 = AppID;
		String pattern07 = "TaxiUCTwitter";
		String pattern09 = "http://streams.event-processing.org/ids/TaxiUCTwitter#stream" ;
		String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
		String Footer= "</mt:nativeMessage>\n";
		String str1 = 
			"@prefix :        <http://events.event-processing.org/types/> .\n"+
			"@prefix e:       <http://events.event-processing.org/ids/> .\n"+
			"@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n"+
			"@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n"+
			"@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n"+
			"@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\n"+
			"e:#3# {\n"+
			"e:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\n"+
			"uctelco:phoneNumber \"#15#\" ;\n"+
			"uctelco:userType \"#16#\" ;\n"+
			"uctelco:uniqueId \"#6#\" ;\n"+
			"uctelco:twId \"#10#\" ;\n"+
			"uctelco:message \"#13#\" ;\n"+
			"uctelco:status \"#14#\" ;\n"+
			"# but also some other data according to event format\n"+
			"a :#7# ;\n"+
			":endTime \"#8#\"^^xsd:dateTime ;\n"+
			":source <http://sources.event-processing.org/ids/#5##source> ;\n"+
			":stream <#9#> ; \n"+
			":location [ geo:lat \"#11#\"^^xsd:double ; geo:long \"#12#\"^^xsd:double ] .\n" +
			"}\n";
		String avaTemplate=  str1;
		int indexSep = this.uniqueId.indexOf(':');
	
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
		avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
		avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
		avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
		avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ','T'));
		avaTemplate = avaTemplate.replaceFirst("#9#", pattern09 );
		// local part of the event
		avaTemplate = avaTemplate.replaceFirst("#10#", this.twId);
		avaTemplate = avaTemplate.replaceFirst("#11#", Double.toString(this.latitude));
		avaTemplate = avaTemplate.replaceFirst("#12#", Double.toString(this.longitude));
		avaTemplate = avaTemplate.replaceFirst("#13#", this.message);
		avaTemplate = avaTemplate.replaceFirst("#14#", this.status);
		avaTemplate = avaTemplate.replaceFirst("#15#", this.phoneNumber);
		avaTemplate = avaTemplate.replaceFirst("#16#", this.userType);

		if (AppID == "Android")
			return    StringEscapeUtils.escapeXml(avaTemplate) ;
		else 
			return Header + StringEscapeUtils.escapeXml(avaTemplate)  + Footer;
	}
}
