/*
 * Decompiled with CFR 0.152.
 */
package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.inEvent;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;

public class POIEvent
extends inEvent {
    protected String verb;
    protected double longitude;
    protected double latitude;
    protected String userType;
    protected String phoneNumber;
    protected String URLAcknoledged;

    public POIEvent() {
    }

    public POIEvent(String timeStamp, String uniqueId, String sequenceNumber) {
        super(timeStamp, uniqueId, sequenceNumber);
    }

    public POIEvent(String timeStamp, String uniqueId, String sequenceNumber, String verb, double longitude, double latitude, String userType, String phoneNumber, String uRLAcknoledged) {
        super(timeStamp, uniqueId, sequenceNumber);
        this.verb = verb;
        this.longitude = longitude;
        this.latitude = latitude;
        this.userType = userType;
        this.phoneNumber = phoneNumber;
        this.URLAcknoledged = uRLAcknoledged;
    }

    public String toRDF(String AppID) {
        String str1;
        String pattern05 = AppID;
        String pattern1 = "UCIM";
        String pattern2 = "http://SERVICE.ws.play.orange.com/";
        String pattern10 = "http://ws.play.orange.com/Taxi.xsd";
        String pattern12 = "http://ws.play.orange.com/Stream";
        String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
        String Footer = "</mt:nativeMessage>\n";
        String avaTemplate = str1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype\" mt:syntax=\"application/x-trig\">@prefix :        <http://events.event-processing.org/types/> .\n@prefix e:       <http://events.event-processing.org/ids/> .\n@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n@prefix #1#:    <#2#> .\ne:#3# {\ne:#3##event ucim:sequenceNumber \"#4#\"^^xsd:integer ;\nucim:timestamp \"#5#\"^^xsd:datetime ;\nucim:uniqueId \"#6#\" ;\nucim:phoneNumber \"#7#\" ;\nucim:status \"#8#\" ;\nucim:userType \"#9#\" ;\n# but also some other data according to event format\na <#10#> ;\n:endTime \"#11#\"^^xsd:dateTime ;\n:source <jbi://Endpoint#source> ;\n:stream <#12#> .\n}\n</mt:nativeMessage>";
        int indexSep = this.uniqueId.indexOf(58);
        avaTemplate = avaTemplate.replaceFirst("#1#", pattern1);
        avaTemplate = avaTemplate.replaceFirst("#2#", pattern2);
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep + 1));
        avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
        avaTemplate = avaTemplate.replaceFirst("#5#", this.timeStamp);
        avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
        avaTemplate = avaTemplate.replaceFirst("#10#", pattern10);
        avaTemplate = avaTemplate.replaceFirst("#11#", this.timeStamp.replace(' ', 'T'));
        avaTemplate = avaTemplate.replaceFirst("#12#", pattern12);
        if (AppID == "Android") {
            return StringEscapeUtils.escapeXml((String)avaTemplate);
        }
        return Header + StringEscapeUtils.escapeXml((String)avaTemplate) + Footer;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getURLAcknoledged() {
        return this.URLAcknoledged;
    }

    public void setURLAcknoledged(String uRLAcknoledged) {
        this.URLAcknoledged = uRLAcknoledged;
    }

    public String toStringCEP() {
        return "stream=POIEvent,verb=" + this.verb + ",longitude=" + this.longitude + ",latitude=" + this.latitude + ",userType=" + this.userType + ",phoneNumber=" + this.phoneNumber + ",URLAcknoledged=" + this.URLAcknoledged;
    }

    public String toString() {
        return "POIEvent [uniqueId=" + this.uniqueId + ", sequenceNumber=" + this.sequenceNumber + ", timeStamp=" + this.timeStamp + ", verb=" + this.verb + ", longitude=" + this.longitude + ", latitude=" + this.latitude + ", userType=" + this.userType + ", phoneNumber=" + this.phoneNumber + ", URLAcknoledged=" + this.URLAcknoledged + "]";
    }

    public String toXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <POIEvent xmlns=\"http://www.orange.org/TaxiEventType\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<verb>" + this.timeStamp + "</verb>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "<URLAcknoledged>" + this.phoneNumber + "</URLAcknoledged>" + "</POIEvent>";
    }

    public String toWSN() {
        return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "POIEventTopic", "evt"), "<OrangeLabsTaxiUC:POIEvent xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.orangelabs.org/taxiEventTypes\" xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\"><uniqueId>" + this.uniqueId + "</uniqueId>" + "<sequenceNumber>" + this.sequenceNumber + "</sequenceNumber>" + "<timeStamp>" + this.timeStamp + "</timeStamp>" + "<verb>" + this.timeStamp + "</verb>" + "<latitude>" + this.latitude + "</latitude>" + "<longitude>" + this.longitude + "</longitude>" + "<userType>" + this.userType + "</userType>" + "<phoneNumber>" + this.phoneNumber + "</phoneNumber>" + "<URLAcknoledged>" + this.phoneNumber + "</URLAcknoledged>" + "</OrangeLabsTaxiUC:POIEvent>", null, null);
    }
}

