package com.orange.eventData.events.inEvents;

import javax.xml.namespace.QName;

import org.apache.commons.lang3.StringEscapeUtils;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;

public class FaceBookEvent extends inEvent implements MultipleCEPSupport {	
	private static final long serialVersionUID = -3557712291381815818L;

	protected String phoneNumber = "";
	protected String userType = ""; 
	
	protected String postId = "";
	protected String fromId = "";
	protected String fromName = "";
	protected String toId = "";
	protected String toName = "";
	protected String message = "";
	protected String link = "";
	protected String createdTime = "";
	protected String updatedTime = "";
	
	protected double latitude = -1;
	protected double longitude = -1;
	
	public FaceBookEvent() {
	}
	
	public FaceBookEvent(String timeStamp, String uniqueId, String sequenceNumber) {
		super(timeStamp, uniqueId, sequenceNumber);
	}

	public FaceBookEvent(String message) {
		super();
		this.message = message;
	}
	
	public FaceBookEvent(
			String timeStamp, 
			String uniqueId, 
			String sequenceNumber,
			
			String phoneNumber,
			String userType,
			
			String postId,
			String fromId,
			String fromName,
			String toId,
			String toName,
			String message,
			String link,
			String createdTime,
			String updatedTime,
			
			double latitude, 
			double longitude ) {
		super(timeStamp, uniqueId, sequenceNumber);
		
		this.phoneNumber = phoneNumber;
		this.userType = userType;		
		
		this.postId = postId;
		this.fromId = fromId;
		this.fromName = fromName;
		this.toId = toId;
		this.toName = toName;
		this.message = message;
		this.link = link;
		this.createdTime = createdTime;
		this.updatedTime = updatedTime;
		
		this.latitude = latitude;
		this.longitude = longitude;
	}

	public String getPhoneNumber() {
		return phoneNumber;
	}
	
	public void setPhoneNumber(String phoneNumber) {
		this.phoneNumber = phoneNumber;
	}
	
	public String getUserType() {
		return userType;
	}
	
	public void setUserType(String userType) {
		this.userType = userType;
	}
	
	public String getPostId() {
		return postId;
	}

	public void setPostId(String postId) {
		this.postId = postId;
	}

	public String getFromId() {
		return fromId;
	}

	public void setFromId(String fromId) {
		this.fromId = fromId;
	}

	public String getFromName() {
		return fromName;
	}

	public void setFromName(String fromName) {
		this.fromName = fromName;
	}

	public String getToId() {
		return toId;
	}

	public void setToId(String toId) {
		this.toId = toId;
	}

	public String getToName() {
		return toName;
	}

	public void setToName(String toName) {
		this.toName = toName;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getLink() {
		return link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public String getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(String createdTime) {
		this.createdTime = createdTime;
	}

	public String getUpdatedTime() {
		return updatedTime;
	}

	public void setUpdatedTime(String updatedTime) {
		this.updatedTime = updatedTime;
	}

	public double getLatitude() {
		return latitude;
	}
	
	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}
	
	public double getLongitude() {
		return longitude;
	}
	
	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}
	
	@Override
	public String toString() {
		return "FaceBookEvent [timeStamp=" + timeStamp 
				+ ", uniqueId=" + uniqueId 
				+ ", sequenceNumber=" + sequenceNumber 
				
				+ ", phoneNumber=" + phoneNumber 
				+ ", userType=" + userType 
				
				+ ", postId=" + postId 
				+ ", fromId=" + fromId 
				+ ", fromName=" + fromName
				+ ", toId=" + toId 
				+ ", toName=" + toName 
				+ ", message=" + message 
				+ ", link=" + link
				+ ", createdTime=" + createdTime
				+ ", updatedTime=" + updatedTime 
				
				+ ", latitude=" + latitude 
				+ ", longitude=" + longitude + "]";
	}

	public String toXML() {
		return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <FaceBookEvent xmlns=\"http://www.orange.org/TaxiEventType\" "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xsi:schemaLocation=\"http://www.orange.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"<userType>"+userType+"</userType>"+
		
		"<postId>"+postId+"</postId>"+
		"<fromId>"+fromId+"</fromId>"+
		"<fromName>"+fromName+"</fromName>"+
		"<toId>"+toId+"</toId>"+
		"<toName>"+toName+"</toName>"+
		"<message>"+message+"</message>"+
		"<link>"+link+"</link>"+
		"<createdTime>"+createdTime+"</createdTime>"+
		"<updatedTime>"+updatedTime+"</updatedTime>"+
		
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"</FaceBookEvent>";
	}

	public String toWSN() {
		return this.formatToWsn(new QName("http://www.orange.org/TaxiEventType", "FaceBookEvent" + "Topic", "evt"),"<OrangeLabsTaxiUC:FaceBookEvent "+
		"xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " +
		"xmlns=\"http://www.orangelabs.org/taxiEventTypes\" " +
		"xsi:schemaLocation=\"http://www.orangelabs.org/TaxiEventType TaxiEventType.xsd\">"+
		"<uniqueId>"+uniqueId+"</uniqueId>"+
		"<sequenceNumber>"+sequenceNumber+"</sequenceNumber>"+
		"<timeStamp>"+timeStamp+"</timeStamp>"+
		
		"<phoneNumber>"+phoneNumber+"</phoneNumber>"+
		"<userType>"+userType+"</userType>"+

		"<postId>"+postId+"</postId>"+
		"<fromId>"+fromId+"</fromId>"+
		"<fromName>"+fromName+"</fromName>"+
		"<toId>"+toId+"</toId>"+
		"<toName>"+toName+"</toName>"+
		"<message>"+message+"</message>"+
		"<link>"+link+"</link>"+
		"<createdTime>"+createdTime+"</createdTime>"+
		"<updatedTime>"+updatedTime+"</updatedTime>"+		
		
		"<latitude>"+latitude+"</latitude>"+
		"<longitude>"+longitude+"</longitude>"+
		"</OrangeLabsTaxiUC:FaceBookEvent>", null, null);
	}

	public String toCEP() {
		return "stream=FaceBookEvent,timeStamp=" + timeStamp + ",uniqueId=" + uniqueId + ",sequenceNumber=" + sequenceNumber + ",phoneNumber="
				+ phoneNumber + ",userType=" + userType + ",postId=" + postId + ",fromId=" + fromId + ",fromName=" + fromName
				+ ",toId=" + toId + ",toName=" + toName + ",message=" + message + ",link=" + link + ",createdTime=" + createdTime
				+ ",updatedTime=" + updatedTime + ",latitude=" + latitude + ",longitude=" + longitude;
	}

	public String getRDFName() {
		return "TaxiUCFacebook";
	}

	public String toRDF(String AppID) {
		String pattern05 = AppID;
		String pattern07 = "TaxiUCFaceBook";
		String pattern09 = "http://streams.event-processing.org/ids/TaxiUCFaceBook#stream" ;
		String Header = "<mt:nativeMessage xmlns:mt=\"http://www.event-processing.org/wsn/msgtype/\" mt:syntax=\"application/x-trig\">\n";
		String Footer= "</mt:nativeMessage>\n";
		String str1 = 
			"@prefix :        <http://events.event-processing.org/types/> .\n"+
			"@prefix e:       <http://events.event-processing.org/ids/> .\n"+
			"@prefix dsb:     <http://www.petalslink.org/dsb/topicsns/> .\n"+
			"@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> .\n"+
			"@prefix uctelco: <http://events.event-processing.org/uc/telco/> .\n"+
			"@prefix geo:     <http://www.w3.org/2003/01/geo/wgs84_pos#> .\n"+
			"e:#3# {\n"+
			"e:#3##event uctelco:sequenceNumber \"#4#\"^^xsd:integer ;\n"+
			"uctelco:uniqueId \"#6#\" ;\n"+

			"uctelco:phoneNumber \"#15#\" ;\n"+
			"uctelco:userType \"#16#\" ;\n"+

			"uctelco:postId \"#17#\" ;\n"+
			"uctelco:fromId \"#18#\" ;\n"+
			"uctelco:fromName \"#19#\" ;\n"+
			"uctelco:toId \"#20#\" ;\n"+
			"uctelco:toName \"#21#\" ;\n"+
			"uctelco:message \"#22#\" ;\n"+
			"uctelco:link \"#24#\" ;\n"+
			"uctelco:createdTime \"#29#\" ;\n"+
			"uctelco:updatedTime \"#30#\" ;\n"+
			
			"# but also some other data according to event format\n"+
			"a :#7# ;\n"+
			":endTime \"#8#\"^^xsd:dateTime ;\n"+
			":source <http://sources.event-processing.org/ids/#5##source> ;\n"+
			":stream <#9#> ; \n"+
			":location [ geo:lat \"#11#\"^^xsd:double ; geo:long \"#12#\"^^xsd:double ] .\n" +
			"}\n";
		String avaTemplate=  str1;
		int indexSep = this.uniqueId.indexOf(':');
	
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#3#", this.uniqueId.substring(indexSep+1));
		avaTemplate = avaTemplate.replaceFirst("#4#", this.sequenceNumber);
		avaTemplate = avaTemplate.replaceFirst("#5#", pattern05);
		avaTemplate = avaTemplate.replaceFirst("#6#", this.uniqueId);
		avaTemplate = avaTemplate.replaceFirst("#7#", pattern07);
		avaTemplate = avaTemplate.replaceFirst("#8#", this.timeStamp.replace(' ','T'));
		avaTemplate = avaTemplate.replaceFirst("#9#", pattern09 );
		avaTemplate = avaTemplate.replaceFirst("#11#", Double.toString(this.latitude));
		avaTemplate = avaTemplate.replaceFirst("#12#", Double.toString(this.longitude));
		
		avaTemplate = avaTemplate.replaceFirst("#15#", this.phoneNumber);
		avaTemplate = avaTemplate.replaceFirst("#16#", this.userType);
		
		avaTemplate = avaTemplate.replaceFirst("#17#", this.postId);
		avaTemplate = avaTemplate.replaceFirst("#18#", this.fromId);
		avaTemplate = avaTemplate.replaceFirst("#19#", this.fromName);
		avaTemplate = avaTemplate.replaceFirst("#20#", this.toId);
		avaTemplate = avaTemplate.replaceFirst("#21#", this.toName);
		avaTemplate = avaTemplate.replaceFirst("#22#", this.message);
		avaTemplate = avaTemplate.replaceFirst("#24#", this.link);
		avaTemplate = avaTemplate.replaceFirst("#29#", this.createdTime);
		avaTemplate = avaTemplate.replaceFirst("#30#", this.updatedTime);		
		
		if (AppID == "Android")
			return    StringEscapeUtils.escapeXml(avaTemplate) ;
		else 
			return Header + StringEscapeUtils.escapeXml(avaTemplate)  + Footer;	
	}
}
