package com.orange.eventData.events.inEvents;

import com.orange.eventData.events.MultipleCEPSupport;
import com.orange.eventData.events.inEvent;

public class ProfileEvent extends inEvent implements MultipleCEPSupport {
	private static final long serialVersionUID = 4937497745518265990L;

	protected String userNumber;
	protected String direction;
	protected int missedCallsNumber;
	protected int missedCallsTime;
	protected boolean sendCallEnabled;
	protected boolean sendSmsEnabled;
	protected String sendSmsText;
	protected boolean facebookEnabled;
	protected int facebookLastPostTime;
	protected boolean twitterEnabled;
	protected int twitterLastPostTime;
	protected boolean latitudeEnabled;
	
	protected String message;
	
	public ProfileEvent() {		
	}

	public String getUserNumber() {
		return userNumber;
	}
	
	public void setUserNumber(String userNumber) {
		this.userNumber = userNumber;
	}
	
	public String getDirection() {
		return direction;
	}
	
	public void setDirection(String direction) {
		this.direction = direction;
	}
	
	public int getMissedCallsNumber() {
		return missedCallsNumber;
	}
	
	public void setMissedCallsNumber(int missedCallsNumber) {
		this.missedCallsNumber = missedCallsNumber;
	}
	
	public int getMissedCallsTime() {
		return missedCallsTime;
	}
	
	public void setMissedCallsTime(int missedCallsTime) {
		this.missedCallsTime = missedCallsTime;
	}
	
	public boolean isSendCallEnabled() {
		return sendCallEnabled;
	}
	
	public void setSendCallEnabled(boolean sendCallEnabled) {
		this.sendCallEnabled = sendCallEnabled;
	}

	public boolean isSendSmsEnabled() {
		return sendSmsEnabled;
	}
	
	public void setSendSmsEnabled(boolean sendSmsEnabled) {
		this.sendSmsEnabled = sendSmsEnabled;
	}
	
	public String getSendSmsText() {
		return sendSmsText;
	}
	
	public void setSendSmsText(String sendSmsText) {
		this.sendSmsText = sendSmsText;
	}
	
	public boolean isFacebookEnabled() {
		return facebookEnabled;
	}
	
	public void setFacebookEnabled(boolean facebookEnabled) {
		this.facebookEnabled = facebookEnabled;
	}
	
	public int getFacebookLastPostTime() {
		return facebookLastPostTime;
	}
	
	public void setFacebookLastPostTime(int facebookLastPostTime) {
		this.facebookLastPostTime = facebookLastPostTime;
	}
	
	public boolean isTwitterEnabled() {
		return twitterEnabled;
	}
	
	public void setTwitterEnabled(boolean twitterEnabled) {
		this.twitterEnabled = twitterEnabled;
	}
	
	public int getTwitterLastPostTime() {
		return twitterLastPostTime;
	}
	
	public void setTwitterLastPostTime(int twitterLastPostTime) {
		this.twitterLastPostTime = twitterLastPostTime;
	}
	
	public boolean isLatitudeEnabled() {
		return latitudeEnabled;
	}
	
	public void setLatitudeEnabled(boolean latitudeEnabled) {
		this.latitudeEnabled = latitudeEnabled;
	}
	
	public String getMessage() {
		return message;
	}
	
	public void setMessage(String message) {
		this.message = message;
	}

	
	@Override
	public String toString() {
		return String.format("ProfileEvent [timeStamp=%s, uniqueId=%s, sequenceNumber=%s, userNumber=%s, direction=%s, missedCallsNumber=%s, " + 
			"missedCallsTime=%s, sendCallEnabled=%s, sendSmsEnabled=%s, sendSmsText=%s, facebookEnabled=%s, facebookLastPostTime=%s, " + 
			"twitterEnabled=%s, twitterLastPostTime=%s, latitudeEnabled=%s, message=%s]",
			timeStamp, uniqueId, sequenceNumber, userNumber, direction, missedCallsNumber, missedCallsTime, sendCallEnabled,
			sendSmsEnabled, sendSmsText, facebookEnabled, facebookLastPostTime, twitterEnabled, twitterLastPostTime,
			latitudeEnabled, message);
	}

	public String toXML() {
		// FIXME Antonio: ProfileEvent: to implement
		return null;
	}

	public String toCEP() {
		return "stream=ProfileEvent,uniqueId=" + uniqueId + ",sequenceNumber=" + sequenceNumber + ",timeStamp=" + timeStamp
				+ ",userNumber=" + userNumber + ",direction=" + direction + ",missedCallsNumber=" + missedCallsNumber 
				+ ",missedCallsTime=" + missedCallsTime + ",sendCallEnabled=" + sendCallEnabled + ",sendSmsEnabled=" 
				+ sendSmsEnabled + ",sendSmsText=" + sendSmsText + ",facebookEnabled=" + facebookEnabled
				+ ",facebookLastPostTime=" + facebookLastPostTime + ",twitterEnabled=" + twitterEnabled 
				+ ",twitterLastPostTime=" + twitterLastPostTime + ",latitudeEnabled=" + latitudeEnabled 
				+ ",message=" + message;
	}

	public String getRDFName() {
		// FIXME Antonio: ProfileEvent: to implement
		return null;
	}

	public String toRDF(String AppId) {
		// FIXME Antonio: ProfileEvent: to implement
		return null;
	}

	public String toWSN() {
		// FIXME Antonio: ProfileEvent: to implement
		return null;		
	}
}
