/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X942DHParams
extends DomainParameters {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute subprime_;
    protected LongAttribute primeBits_;
    protected LongAttribute subprimeBits_;

    public X942DHParams() {
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    protected X942DHParams(Session session, long objectHandle) throws TokenException {
        super(session, objectHandle);
        this.keyType_.setLongValue(Key.KeyType.DH);
    }

    public static Object getInstance(Session session, long objectHandle) throws TokenException {
        return new X942DHParams(session, objectHandle);
    }

    protected static void putAttributesInTable(X942DHParams object) {
        if (object == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        object.attributeTable_.put(Attribute.PRIME, object.prime_);
        object.attributeTable_.put(Attribute.BASE, object.base_);
        object.attributeTable_.put(Attribute.SUBPRIME, object.subprime_);
        object.attributeTable_.put(Attribute.PRIME_BITS, object.primeBits_);
        object.attributeTable_.put(Attribute.SUB_PRIME_BITS, object.subprimeBits_);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.primeBits_ = new LongAttribute(Attribute.PRIME_BITS);
        this.subprimeBits_ = new LongAttribute(Attribute.SUB_PRIME_BITS);
        X942DHParams.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X942DHParams clone = (X942DHParams)super.clone();
        clone.prime_ = (ByteArrayAttribute)this.prime_.clone();
        clone.base_ = (ByteArrayAttribute)this.base_.clone();
        clone.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        clone.primeBits_ = (LongAttribute)this.primeBits_.clone();
        clone.subprimeBits_ = (LongAttribute)this.subprimeBits_.clone();
        X942DHParams.putAttributesInTable(clone);
        return clone;
    }

    public boolean equals(java.lang.Object otherObject) {
        boolean equal = false;
        if (otherObject instanceof X942DHParams) {
            X942DHParams other = (X942DHParams)otherObject;
            equal = this == other || super.equals(other) && this.prime_.equals(other.prime_) && this.base_.equals(other.base_) && this.subprime_.equals(other.subprime_) && this.primeBits_.equals(other.primeBits_) && this.subprimeBits_.equals(other.subprimeBits_);
        }
        return equal;
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits_;
    }

    public LongAttribute getSubprimeBits() {
        return this.subprimeBits_;
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.base_, this.subprime_, this.primeBits_, this.subprimeBits_});
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(super.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Prime (hex): ");
        buffer.append(this.prime_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Base (hex): ");
        buffer.append(this.base_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Subprime (hex): ");
        buffer.append(this.subprime_.toString());
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Prime Bits (dec): ");
        buffer.append(this.primeBits_.toString(10));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Subprime Bits (dec): ");
        buffer.append(this.subprimeBits_.toString(10));
        return buffer.toString();
    }
}

