/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentStore;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.interfaces.incoming.IncomingFileAttachment;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.types.InternetMediaType;

public class AttachmentStub
implements IncomingFileAttachment {
    private final String contentId;
    private IncomingAttachment delegate;
    private ContextID attachmentScope;

    public AttachmentStub(String string) {
        this.contentId = string;
    }

    public ContextID getAttachmentScope() {
        return this.attachmentScope;
    }

    public void setAttachmentScope(ContextID contextID) {
        this.attachmentScope = contextID;
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public byte[] getBytes() throws AttachmentException, IOException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.getBytes();
    }

    public String getContentId() {
        return this.contentId;
    }

    public InternetMediaType getContentType() throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.getContentType();
    }

    public InputStream getInputStream() throws AttachmentException, IOException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.getInputStream();
    }

    public String getTransferEncoding() throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.getTransferEncoding();
    }

    public int getType() throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.getType();
    }

    public boolean isAvailable() {
        try {
            return AttachmentStore.getInstance().isAvailable(this.attachmentScope, this.contentId);
        }
        catch (AttachmentException attachmentException) {
            return false;
        }
    }

    public long size() throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return this.delegate.size();
    }

    public boolean isLocal() {
        return false;
    }

    public String getFilePath() throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return ((IncomingFileAttachment)this.delegate).getFilePath();
    }

    public void save(String string) throws AttachmentException, IOException {
        if (this.delegate == null) {
            this.resolve();
        }
        ((IncomingFileAttachment)this.delegate).save(string);
    }

    public boolean move(String string) throws AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        return ((IncomingFileAttachment)this.delegate).move(string);
    }

    private synchronized void resolve() throws AttachmentException {
        this.delegate = AttachmentStore.getInstance().resolve(this.attachmentScope, this.contentId);
    }

    public void serialize(OutputStream outputStream) throws IOException, AttachmentException {
        if (this.delegate == null) {
            this.resolve();
        }
        this.delegate.serialize(outputStream);
    }
}

