/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.client;

import org.ws4d.java.structures.AppSequenceTracker;
import org.ws4d.java.structures.LinkedMap;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.EndpointReference;

public class AppSequenceBuffer {
    protected static int MAX_BUFFER_SIZE = 50;
    private LinkedMap buffer;

    public AppSequenceBuffer() {
        this.buffer = new LinkedMap(true);
    }

    public AppSequenceBuffer(int n) {
        this.buffer = new LinkedMap(n, true);
    }

    public synchronized boolean contains(EndpointReference endpointReference) {
        return this.buffer.containsKey(endpointReference);
    }

    public synchronized boolean checkAndUpdate(EndpointReference endpointReference, AppSequence appSequence) {
        String string = endpointReference.getAddress().toString();
        AppSequenceTracker appSequenceTracker = (AppSequenceTracker)this.buffer.get(string);
        if (appSequenceTracker != null) {
            return appSequenceTracker.checkAndUpdate(appSequence);
        }
        if (this.buffer.size() >= MAX_BUFFER_SIZE) {
            this.buffer.removeFirst();
        }
        this.buffer.put(string, new AppSequenceTracker(appSequence));
        return true;
    }
}

