/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.VersionMismatchException;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.WS4DIllegalStateException;

public interface CommunicationManager {
    public static final String ID_NULL = null;

    public void init();

    public String getCommunicationManagerId();

    public void start() throws IOException;

    public void stop();

    public void kill();

    public DataStructure getAvailableDomains();

    public void registerDevice(int[] var1, CommunicationBinding var2, IncomingMessageListener var3, HTTPGroup var4) throws IOException, WS4DIllegalStateException;

    public void registerService(int[] var1, CommunicationBinding var2, IncomingMessageListener var3, HTTPGroup var4) throws IOException, WS4DIllegalStateException;

    public void registerDiscovery(int[] var1, DiscoveryBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void registerDeviceReference(int[] var1, DiscoveryBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void unregisterDevice(int[] var1, CommunicationBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void unregisterService(int[] var1, CommunicationBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void unregisterDiscovery(int[] var1, DiscoveryBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void unregisterDeviceReference(int[] var1, DiscoveryBinding var2, IncomingMessageListener var3) throws IOException, WS4DIllegalStateException;

    public void send(Message var1, XAddressInfo var2, ProtocolDomain var3, ResponseCallback var4) throws WS4DIllegalStateException;

    public URI registerResource(Resource var1, CommunicationBinding var2, String var3, HTTPGroup var4) throws IOException, WS4DIllegalStateException;

    public void unregisterResource(URI var1, CommunicationBinding var2) throws IOException, WS4DIllegalStateException;

    public ResourceLoader getResourceAsStream(URI var1) throws IOException;

    public boolean addressMatches(URI var1, boolean var2, ProtocolData var3);

    public void getAutobindings(String var1, DataStructure var2) throws IOException;

    public void getProtocolDomains(Iterator var1, DataStructure var2) throws IOException;

    public DataStructure getDiscoveryBindings() throws IOException;

    public DiscoveryBinding getDiscoveryBindingForDomain(ProtocolDomain var1) throws IOException;

    public DataStructure getDiscoveryDomainForBinding(DiscoveryBinding var1) throws IOException;

    public DiscoveryBinding getDiscoveryBindingForProtocolData(ProtocolData var1);

    public void serializeMessageWithAttachments(Message var1, String var2, List var3, OutputStream var4, ProtocolData var5) throws IOException;

    public ProtocolInfo getProtocolInfo();

    public ProtocolInfo createProtocolInfo(int var1);

    public HashSet getSupportedVersions();

    public CommunicationUtil getCommunicationUtil();

    public long getRandomApplicationDelay(int var1);

    public boolean supportsAddressingNamespace(SOAPHeader var1, String var2, ProtocolData var3) throws VersionMismatchException;

    public QNameSet getDeviceTypes();
}

