/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.attachment.Attachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.communication.AttachmentStoreHandler;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DPWS2006.DefaultDPWSCommunicatonUtil;
import org.ws4d.java.communication.DPWSDiscoveryBinding;
import org.ws4d.java.communication.DPWSDomain;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.DPWSProtocolInfo;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.FaultAwareResponseCallback;
import org.ws4d.java.communication.GenericReceiver;
import org.ws4d.java.communication.HTTPBinding;
import org.ws4d.java.communication.IncomingMIMEReceiver;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.IncomingSOAPReceiver;
import org.ws4d.java.communication.IncomingUDPReceiver;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.ProtocolInfo;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.SOAPResponseReceiver;
import org.ws4d.java.communication.UDPResponseReceiver;
import org.ws4d.java.communication.VersionMismatchException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.communication.connection.ip.NetworkInterface;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.communication.protocol.http.HTTPClient;
import org.ws4d.java.communication.protocol.http.HTTPClientDestination;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.communication.protocol.http.HTTPRequestUtil;
import org.ws4d.java.communication.protocol.http.server.DefaultHTTPResourceHandler;
import org.ws4d.java.communication.protocol.http.server.HTTPServer;
import org.ws4d.java.communication.protocol.mime.DefaultMIMEHandler;
import org.ws4d.java.communication.protocol.mime.MIMEBodyHeader;
import org.ws4d.java.communication.protocol.mime.MIMEHandler;
import org.ws4d.java.communication.protocol.soap.SOAPRequest;
import org.ws4d.java.communication.protocol.soap.SOAPoverUDPClient;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.communication.protocol.soap.server.SOAPServer;
import org.ws4d.java.communication.protocol.soap.server.SOAPoverUDPServer;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.configuration.DispatchingProperties;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.constants.DPWSConstants;
import org.ws4d.java.constants.DPWSConstants2006;
import org.ws4d.java.constants.PrefixRegistry;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.dispatch.RequestResponseCoordinator;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedSet;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.MessageIdBuffer;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.MIMEUtil;
import org.ws4d.java.util.WS4DIllegalStateException;

public class DPWSCommunicationManager
implements CommunicationManager {
    public static final String COMMUNICATION_MANAGER_ID = "DPWS";
    private static final Random RND = new Random();
    private static final MessageReceiver GENERIC_RECEIVER = new GenericReceiver();
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private static final CommunicationUtil DPWS_UTIL = DefaultDPWSCommunicatonUtil.getInstance();
    protected static final MessageIdBuffer SENT_MULTICAST_MESSAGE_IDS = new MessageIdBuffer();
    private volatile boolean stopped = true;
    private final HashMap udpClientsPerDomain = new HashMap();
    private final HashMap udpServers = new HashMap();
    private final HashMap soapServers = new HashMap();
    private final HashMap httpServers = new HashMap();
    private final RequestResponseCoordinator rrc = RequestResponseCoordinator.getInstance();
    private final SOAPoverUDPClient.SOAPoverUDPHandler udpResponseHandler = new SOAPoverUDPClient.SOAPoverUDPHandler(new UDPResponseReceiver(this.rrc));
    private static Set registerForGetMetadata = new HashSet();
    private static Set MessageIDsForGetMetadataMapping = new HashSet();
    private final Object udpTransmissionsLock = new Object();
    private volatile int pendingUDPTransmissions = 0;
    private DataStructure domains = this.getAvailableDomains();
    private DataStructure discoveryBindings = null;

    public static Set getRegisterForGetMetadata() {
        return registerForGetMetadata;
    }

    public static Set getMessageIDsForGetMetadataMapping() {
        return MessageIDsForGetMetadataMapping;
    }

    public static boolean hasSentMessage(URI uRI) {
        return SENT_MULTICAST_MESSAGE_IDS.contains(uRI);
    }

    public void init() {
        Properties.getInstance().register(Properties.HEADER_SECTION_DPWS, "org.ws4d.java.configuration.DPWSProperties");
        Properties.getInstance().register(Properties.HEADER_SECTION_HTTP, "org.ws4d.java.configuration.HTTPProperties");
        Properties.getInstance().register(Properties.HEADER_SECTION_IP, "org.ws4d.java.configuration.IPProperties");
        PrefixRegistry.addPrefix("http://schemas.xmlsoap.org/ws/2006/02/devprof", "wsdp");
        PrefixRegistry.addPrefix("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01", "dpws");
    }

    public String getCommunicationManagerId() {
        return COMMUNICATION_MANAGER_ID;
    }

    public DataStructure getAvailableDomains() {
        if (this.domains == null) {
            this.domains = new ArrayList();
            Iterator iterator = IPNetworkDetection.getInstance().getNetworkInterfaces();
            while (iterator.hasNext()) {
                NetworkInterface networkInterface = (NetworkInterface)iterator.next();
                if (!networkInterface.isUp()) {
                    if (!Log.isDebug()) continue;
                    Log.debug("The interface " + networkInterface.getName() + " is not up and running...", 1);
                    continue;
                }
                if (!networkInterface.supportsMulticast()) {
                    if (!Log.isDebug()) continue;
                    Log.debug("The interface " + networkInterface.getName() + " does not support multicast. No listener will be bound.", 1);
                    continue;
                }
                Iterator iterator2 = networkInterface.getAddresses();
                while (iterator2.hasNext()) {
                    IPAddress iPAddress = (IPAddress)iterator2.next();
                    this.domains.add(new DPWSDomain(networkInterface, iPAddress, true, true));
                }
            }
        }
        return this.domains;
    }

    public DataStructure refreshAvailableDomains() {
        this.domains = null;
        return this.getAvailableDomains();
    }

    public boolean addressMatches(URI uRI, boolean bl, ProtocolData protocolData) {
        if (!(protocolData instanceof DPWSProtocolData)) {
            return false;
        }
        DPWSProtocolData dPWSProtocolData = (DPWSProtocolData)protocolData;
        String string = this.getCanonicalAddress(bl ? dPWSProtocolData.getSourceHost() : dPWSProtocolData.getDestinationHost());
        String string2 = this.getCanonicalAddress(uRI.getHost());
        return string != null && string.equals(string2);
    }

    public long getRandomApplicationDelay(int n) {
        CommunicationUtil communicationUtil = this.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(n);
        int n2 = constantsHelper.getRandomApplicationDelay();
        if (n2 <= 0) {
            return 0L;
        }
        int n3 = RND.nextInt();
        if (n3 < 0) {
            n3 = -n3;
        }
        return n3 % (n2 + 1);
    }

    public void start() throws IOException {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        if (Log.isInfo()) {
            Log.info(DPWSProperties.getInstance().printSupportedDPWSVersions());
        }
    }

    public DataStructure getDiscoveryBindings() throws IOException {
        if (this.discoveryBindings != null) {
            return this.discoveryBindings;
        }
        DataStructure dataStructure = this.getAvailableDomains();
        this.discoveryBindings = new LinkedSet();
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            ProtocolDomain protocolDomain = (ProtocolDomain)iterator.next();
            this.discoveryBindings.add(this.getDiscoveryBindingForDomain(protocolDomain));
        }
        return this.discoveryBindings;
    }

    public DiscoveryBinding getDiscoveryBindingForDomain(ProtocolDomain protocolDomain) throws IOException {
        if (!(protocolDomain instanceof DPWSDomain)) {
            throw new IOException("Unsupported Domain: " + protocolDomain);
        }
        DPWSDomain dPWSDomain = (DPWSDomain)protocolDomain;
        int n = dPWSDomain.getIPAddress().isIPv6() ? 6 : 4;
        DPWSDiscoveryBinding dPWSDiscoveryBinding = new DPWSDiscoveryBinding(n, dPWSDomain.getInterfaceName());
        Log.info("Add discovery binding: " + dPWSDiscoveryBinding);
        return dPWSDiscoveryBinding;
    }

    public DiscoveryBinding getDiscoveryBindingForProtocolData(ProtocolData protocolData) {
        String string = protocolData.getDestinationAddress();
        String string2 = protocolData.getIFace();
        DPWSDiscoveryBinding dPWSDiscoveryBinding = null;
        dPWSDiscoveryBinding = string.indexOf(58) == -1 ? new DPWSDiscoveryBinding(4, string2) : new DPWSDiscoveryBinding(6, string2);
        return dPWSDiscoveryBinding;
    }

    public DataStructure getDiscoveryDomainForBinding(DiscoveryBinding discoveryBinding) throws IOException {
        if (discoveryBinding == null) {
            throw new IOException("No spezcified binding");
        }
        if (!(discoveryBinding instanceof DPWSDiscoveryBinding)) {
            throw new IOException("Wrong Binding: " + discoveryBinding);
        }
        ArrayList arrayList = new ArrayList();
        DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)discoveryBinding;
        Iterator iterator = ((ArrayList)this.getAvailableDomains()).iterator();
        while (iterator.hasNext()) {
            int n;
            DPWSDomain dPWSDomain = (DPWSDomain)iterator.next();
            int n2 = n = dPWSDomain.getIPAddress().isIPv6() ? 6 : 4;
            if (!dPWSDomain.getInterfaceName().equals(dPWSDiscoveryBinding.getIface()) || n != dPWSDiscoveryBinding.ipVersion) continue;
            arrayList.add(dPWSDomain);
        }
        if (arrayList.size() == 0) {
            throw new IOException("No Domain found for Binding: " + discoveryBinding);
        }
        return arrayList;
    }

    public void kill() {
        this.stopInternal(true);
    }

    public void stop() {
        this.stopInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal(boolean bl) {
        if (this.stopped) {
            return;
        }
        Object object = this.udpTransmissionsLock;
        synchronized (object) {
            Object object2;
            Iterator iterator;
            while (this.pendingUDPTransmissions > 0) {
                try {
                    this.udpTransmissionsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            HashMap hashMap = this.udpServers;
            synchronized (hashMap) {
                iterator = this.udpServers.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (SOAPoverUDPServer)iterator.next();
                    try {
                        ((SOAPoverUDPServer)object2).stop();
                    }
                    catch (IOException iOException) {
                        Log.error("Unable to close SOAPoverUDPServer: " + iOException);
                        Log.printStackTrace(iOException);
                    }
                }
                this.udpServers.clear();
            }
            hashMap = this.soapServers;
            synchronized (hashMap) {
                iterator = this.soapServers.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (SOAPServer)iterator.next();
                    try {
                        SOAPServer.unregisterAndStop((SOAPServer)object2);
                    }
                    catch (IOException iOException) {
                        Log.error("Unable to close SOAPServer: " + iOException);
                        Log.printStackTrace(iOException);
                    }
                }
                this.soapServers.clear();
            }
            SOAPMessageGeneratorFactory.clear();
            hashMap = this.httpServers;
            synchronized (hashMap) {
                iterator = this.httpServers.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (HTTPServer)iterator.next();
                    try {
                        HTTPServer.unregisterAndStop((HTTPServer)object2);
                    }
                    catch (IOException iOException) {
                        Log.error("Unable to close HTTPServer: " + iOException);
                        Log.printStackTrace(iOException);
                    }
                }
                this.httpServers.clear();
            }
            hashMap = this.udpClientsPerDomain;
            synchronized (hashMap) {
                iterator = this.udpClientsPerDomain.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (SOAPoverUDPClient)iterator.next();
                    try {
                        ((SOAPoverUDPClient)object2).close();
                    }
                    catch (IOException iOException) {
                        Log.error("Unable to close SOAPoverUDPClient: " + iOException);
                        Log.printStackTrace(iOException);
                    }
                }
                this.udpClientsPerDomain.clear();
            }
            if (bl) {
                HTTPClient.killAllClients();
            } else {
                HTTPClient.closeAllClients();
            }
            SENT_MULTICAST_MESSAGE_IDS.clear();
            this.stopped = true;
        }
    }

    public void registerDevice(int[] nArray, CommunicationBinding communicationBinding, IncomingMessageListener incomingMessageListener, HTTPGroup hTTPGroup) throws IOException, WS4DIllegalStateException {
        this.checkStopped();
        try {
            HTTPBinding hTTPBinding = (HTTPBinding)communicationBinding;
            SOAPServer sOAPServer = DPWSFramework.hasModule(64) ? this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, DPWSFramework.getSecurityManager().getAliasFromBinding(hTTPBinding)) : this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, null);
            if (hTTPBinding.getPort() == 0) {
                hTTPBinding.setPort(sOAPServer.getHTTPServer().getPort());
            }
            String string = hTTPBinding.getPath();
            IncomingSOAPReceiver incomingSOAPReceiver = new IncomingSOAPReceiver(incomingMessageListener);
            sOAPServer.register(string, incomingSOAPReceiver, hTTPGroup);
            for (int i = 0; i < nArray.length; ++i) {
                if (201 == nArray[i]) {
                    this.addUriToRegister(hTTPBinding.getTransportAddress(), registerForGetMetadata);
                }
                if (400 != nArray[i]) continue;
                DefaultMIMEHandler defaultMIMEHandler = new DefaultMIMEHandler();
                defaultMIMEHandler.register(InternetMediaType.getApplicationXOPXML(), (MIMEHandler)new IncomingMIMEReceiver(incomingMessageListener));
                defaultMIMEHandler.register(2, -1, AttachmentStoreHandler.getInstance());
                sOAPServer.getHTTPServer().register(string, InternetMediaType.getMultipartRelated(), defaultMIMEHandler, hTTPGroup);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need HTTPBinding but was: " + communicationBinding);
        }
    }

    public void registerService(int[] nArray, CommunicationBinding communicationBinding, IncomingMessageListener incomingMessageListener, HTTPGroup hTTPGroup) throws IOException, WS4DIllegalStateException {
        this.checkStopped();
        try {
            HTTPBinding hTTPBinding = (HTTPBinding)communicationBinding;
            SOAPServer sOAPServer = DPWSFramework.hasModule(64) ? this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, DPWSFramework.getSecurityManager().getAliasFromBinding(hTTPBinding)) : this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, null);
            if (hTTPBinding.getPort() == 0) {
                hTTPBinding.setPort(sOAPServer.getHTTPServer().getPort());
            }
            String string = hTTPBinding.getPath();
            IncomingSOAPReceiver incomingSOAPReceiver = new IncomingSOAPReceiver(incomingMessageListener);
            sOAPServer.register(string, incomingSOAPReceiver, hTTPGroup);
            for (int i = 0; i < nArray.length; ++i) {
                if (201 == nArray[i]) {
                    this.addUriToRegister(hTTPBinding.getTransportAddress(), registerForGetMetadata);
                }
                if (400 != nArray[i]) continue;
                DefaultMIMEHandler defaultMIMEHandler = new DefaultMIMEHandler();
                defaultMIMEHandler.register(InternetMediaType.getApplicationXOPXML(), (MIMEHandler)new IncomingMIMEReceiver(incomingMessageListener));
                if (DPWSFramework.hasModule(32)) {
                    defaultMIMEHandler.register(2, -1, AttachmentStoreHandler.getInstance());
                }
                sOAPServer.getHTTPServer().register(string, InternetMediaType.getMultipartRelated(), defaultMIMEHandler, hTTPGroup);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need HTTPBinding but was: " + communicationBinding);
        }
    }

    public void registerDeviceReference(int[] nArray, DiscoveryBinding discoveryBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        if (discoveryBinding == null) {
            throw new IOException("Parameter \"binding\" must not be null.");
        }
        this.checkStopped();
        try {
            DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)discoveryBinding;
            SOAPoverUDPServer sOAPoverUDPServer = this.getSOAPoverUDPServer(dPWSDiscoveryBinding.getHostAddress(), dPWSDiscoveryBinding.getPort(), dPWSDiscoveryBinding.getIface());
            IncomingUDPReceiver incomingUDPReceiver = (IncomingUDPReceiver)sOAPoverUDPServer.getHandler();
            incomingUDPReceiver.register(nArray, incomingMessageListener);
            if (Log.isDebug()) {
                Log.debug("Lifecycle discovery over: " + dPWSDiscoveryBinding, 1);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need DPWSDiscoveryBinding but was: " + discoveryBinding);
        }
    }

    public void registerDiscovery(int[] nArray, DiscoveryBinding discoveryBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        this.checkStopped();
        try {
            DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)discoveryBinding;
            SOAPoverUDPServer sOAPoverUDPServer = this.getSOAPoverUDPServer(dPWSDiscoveryBinding.getHostAddress(), dPWSDiscoveryBinding.getPort(), dPWSDiscoveryBinding.getIface());
            if (sOAPoverUDPServer != null) {
                IncomingUDPReceiver incomingUDPReceiver = (IncomingUDPReceiver)sOAPoverUDPServer.getHandler();
                incomingUDPReceiver.register(nArray, incomingMessageListener);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need DiscoveryBinding but was: " + discoveryBinding.getClass().getName());
        }
    }

    public void unregisterDevice(int[] nArray, CommunicationBinding communicationBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        this.checkStopped();
        try {
            HTTPBinding hTTPBinding = (HTTPBinding)communicationBinding;
            if (hTTPBinding != null) {
                SOAPServer sOAPServer = null;
                sOAPServer = DPWSFramework.hasModule(64) ? this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, DPWSFramework.getSecurityManager().getAliasFromBinding(hTTPBinding)) : this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, null);
                String string = hTTPBinding.getPath();
                sOAPServer.unregister(string);
                sOAPServer.getHTTPServer().unregister(string, InternetMediaType.getMultipartRelated());
                hTTPBinding.resetAutoPort();
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (201 != nArray[i]) continue;
                this.removeUriFromRegister(hTTPBinding.getTransportAddress(), registerForGetMetadata);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need HTTPBinding but was: " + communicationBinding);
        }
    }

    public void unregisterService(int[] nArray, CommunicationBinding communicationBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        this.checkStopped();
        try {
            HTTPBinding hTTPBinding = (HTTPBinding)communicationBinding;
            if (hTTPBinding != null) {
                SOAPServer sOAPServer = null;
                sOAPServer = DPWSFramework.hasModule(64) ? this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, DPWSFramework.getSecurityManager().getAliasFromBinding(hTTPBinding)) : this.getSOAPServer(hTTPBinding.getHostAddress(), hTTPBinding.getPort(), hTTPBinding.getType() == 1, null);
                String string = hTTPBinding.getPath();
                sOAPServer.unregister(string);
                sOAPServer.getHTTPServer().unregister(string, InternetMediaType.getMultipartRelated());
                hTTPBinding.resetAutoPort();
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (201 != nArray[i]) continue;
                this.removeUriFromRegister(hTTPBinding.getTransportAddress(), registerForGetMetadata);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unsupported binding type. Need HTTPBinding but was: " + communicationBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDiscovery(int[] nArray, DiscoveryBinding discoveryBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        block8: {
            this.checkStopped();
            if (discoveryBinding != null) {
                try {
                    DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)discoveryBinding;
                    IPAddress iPAddress = dPWSDiscoveryBinding.getHostAddress();
                    int n = dPWSDiscoveryBinding.getPort();
                    String string = dPWSDiscoveryBinding.getIface();
                    SOAPoverUDPServer sOAPoverUDPServer = this.getSOAPoverUDPServer(iPAddress, n, string);
                    if (sOAPoverUDPServer == null) break block8;
                    IncomingUDPReceiver incomingUDPReceiver = (IncomingUDPReceiver)sOAPoverUDPServer.getHandler();
                    incomingUDPReceiver.unregister(nArray, incomingMessageListener);
                    if (!incomingUDPReceiver.isEmpty()) break block8;
                    String string2 = iPAddress.getAddress() + ":" + n + "%" + string;
                    HashMap hashMap = this.udpServers;
                    synchronized (hashMap) {
                        try {
                            sOAPoverUDPServer.stop();
                            this.udpServers.remove(string2);
                        }
                        catch (IOException iOException) {
                            Log.warn("unable to remove SOAP-over-UDP server for multicast address " + string2 + ". " + iOException.getMessage());
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new IOException("Unsupported binding type. Need DiscoveryBinding but was: " + discoveryBinding);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDeviceReference(int[] nArray, DiscoveryBinding discoveryBinding, IncomingMessageListener incomingMessageListener) throws IOException, WS4DIllegalStateException {
        block8: {
            this.checkStopped();
            if (discoveryBinding != null) {
                try {
                    DPWSDiscoveryBinding dPWSDiscoveryBinding = (DPWSDiscoveryBinding)discoveryBinding;
                    IPAddress iPAddress = dPWSDiscoveryBinding.getHostAddress();
                    int n = dPWSDiscoveryBinding.getPort();
                    String string = dPWSDiscoveryBinding.getIface();
                    SOAPoverUDPServer sOAPoverUDPServer = this.getSOAPoverUDPServer(iPAddress, n, string);
                    IncomingUDPReceiver incomingUDPReceiver = (IncomingUDPReceiver)sOAPoverUDPServer.getHandler();
                    incomingUDPReceiver.unregister(nArray, incomingMessageListener);
                    if (!incomingUDPReceiver.isEmpty()) break block8;
                    String string2 = iPAddress.getAddress() + ":" + n + "%" + string;
                    HashMap hashMap = this.udpServers;
                    synchronized (hashMap) {
                        try {
                            sOAPoverUDPServer.stop();
                            this.udpServers.remove(string2);
                        }
                        catch (IOException iOException) {
                            Log.warn("unable to remove SOAP-over-UDP server for multicast address " + string2 + ". " + iOException.getMessage());
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new IOException("Unsupported binding type. Need DiscoveryBinding but was: " + discoveryBinding);
                }
            }
        }
    }

    public URI registerResource(Resource resource, CommunicationBinding communicationBinding, String string, HTTPGroup hTTPGroup) throws IOException, WS4DIllegalStateException {
        HTTPServer hTTPServer;
        this.checkStopped();
        if (communicationBinding != null && !(communicationBinding instanceof HTTPBinding)) {
            throw new IOException("Unsupported binding type: " + communicationBinding);
        }
        HTTPBinding hTTPBinding = (HTTPBinding)communicationBinding;
        IPAddress iPAddress = hTTPBinding.getHostAddress();
        int n = hTTPBinding.getPort();
        HTTPServer hTTPServer2 = hTTPServer = hTTPBinding.getType() == 1 ? this.getHTTPServer(iPAddress, n, true, DPWSFramework.getSecurityManager().getAliasFromBinding(hTTPBinding)) : this.getHTTPServer(iPAddress, n);
        if (n == 0) {
            n = hTTPServer.getPort();
            hTTPBinding.setPort(n);
        }
        String string2 = hTTPBinding.getPath();
        if (string == null) {
            string = "";
        } else if (!string.startsWith("/") && !string2.endsWith("/")) {
            string = "/" + string;
        }
        String string3 = string2 + string;
        hTTPServer.register(string3, new DefaultHTTPResourceHandler(resource), hTTPGroup);
        return new URI((hTTPBinding.getType() == 1 ? "https://" : "http://") + iPAddress.getAddressWithoutNicId() + ":" + n + string3);
    }

    public void unregisterResource(URI uRI, CommunicationBinding communicationBinding) throws IOException, WS4DIllegalStateException {
        HTTPBinding hTTPBinding;
        try {
            hTTPBinding = (HTTPBinding)communicationBinding;
        }
        catch (ClassCastException classCastException) {
            if (Log.isError()) {
                Log.error("DPWSCommunicationManager.unregisterResource: unsupported CommunicationBinding class (" + communicationBinding.getClass() + ")");
            }
            return;
        }
        this.checkStopped();
        int n = uRI.getPort();
        HTTPServer hTTPServer = this.getHTTPServer(hTTPBinding.getHostAddress(), n);
        hTTPServer.unregister(uRI.getPath());
        hTTPBinding.resetAutoPort();
    }

    public void send(Message message, XAddressInfo xAddressInfo, ProtocolDomain protocolDomain, ResponseCallback responseCallback) throws WS4DIllegalStateException {
        this.checkStopped();
        if (message == null) {
            return;
        }
        switch (message.getRoutingScheme()) {
            case 1: {
                if (xAddressInfo == null) {
                    Log.warn("No target address found within request message " + message);
                    throw new IllegalArgumentException("No target address set for message " + message);
                }
                this.sendTCPAndCheckDPWSVersion(message, responseCallback, xAddressInfo);
                break;
            }
            case 2: {
                this.sendUDPMulticastAndCheckDPWSVersion(message, protocolDomain, responseCallback);
                break;
            }
            default: {
                Log.warn("Attempt to send a message of an unexpected type: " + message);
                throw new IllegalArgumentException("Unexpected message type: " + message);
            }
        }
    }

    public ResourceLoader getResourceAsStream(URI uRI) throws IOException {
        if (uRI.getSchema().startsWith("http")) {
            try {
                return HTTPRequestUtil.getResourceAsStream(uRI.toString());
            }
            catch (ProtocolException protocolException) {
                throw new IOException("HTTP protocol exception.");
            }
        }
        return null;
    }

    public void getAutobindings(String string, DataStructure dataStructure) throws IOException {
        Object object;
        Object object2;
        Object object3;
        this.checkStopped();
        ArrayList arrayList = new ArrayList(4);
        ArrayList arrayList2 = new ArrayList(4);
        ArrayList arrayList3 = new ArrayList(4);
        ArrayList arrayList4 = new ArrayList(4);
        Object object4 = this.getAvailableDomains().iterator();
        while (object4.hasNext()) {
            object3 = (DPWSDomain)object4.next();
            object2 = ((DPWSDomain)object3).getIPAddress();
            boolean bl = ((DPWSDomain)object3).getIface().isLoopback();
            if (((IPAddress)object2).isIPv6()) {
                if (bl || ((IPAddress)object2).isLoopback()) {
                    ((List)arrayList2).add(object3);
                    continue;
                }
                ((List)arrayList4).add(object3);
                continue;
            }
            if (bl || ((IPAddress)object2).isLoopback()) {
                ((List)arrayList).add(object3);
                continue;
            }
            ((List)arrayList3).add(object3);
        }
        object4 = arrayList3.isEmpty() ? arrayList : arrayList3;
        object3 = new HashMap();
        object2 = ((List)object4).iterator();
        while (object2.hasNext()) {
            DPWSDomain dPWSDomain = (DPWSDomain)object2.next();
            object = dPWSDomain.getInterfaceName();
            if (((HashMap)object3).containsKey(object)) continue;
            ((HashMap)object3).put(object, dPWSDomain);
        }
        object4 = arrayList4.isEmpty() ? arrayList2 : arrayList4;
        object2 = new HashMap();
        Iterator iterator = ((List)object4).iterator();
        while (iterator.hasNext()) {
            object = (DPWSDomain)iterator.next();
            String string2 = ((DPWSDomain)object).getInterfaceName();
            DPWSDomain dPWSDomain = (DPWSDomain)((HashMap)object2).get(string2);
            if (dPWSDomain != null && (dPWSDomain.getIface().isLoopback() ? dPWSDomain.getIPAddress().isLoopback() : dPWSDomain.getIPAddress().isIPv6LinkLocal())) continue;
            ((HashMap)object2).put(string2, object);
        }
        this.bindAddresses(string, dataStructure, ((HashMap)object3).values());
        this.bindAddresses(string, dataStructure, ((HashMap)object2).values());
    }

    private void bindAddresses(String string, DataStructure dataStructure, DataStructure dataStructure2) {
        Iterator iterator = dataStructure2.iterator();
        while (iterator.hasNext()) {
            DPWSDomain dPWSDomain = (DPWSDomain)iterator.next();
            HTTPBinding hTTPBinding = new HTTPBinding(dPWSDomain.getIPAddress(), 0, string);
            if (Log.isDebug()) {
                Log.debug("Adding HTTP auto-binding on " + dPWSDomain.getInterfaceName() + ": " + hTTPBinding, 1);
            }
            dataStructure.add(hTTPBinding);
        }
    }

    public void getProtocolDomains(Iterator iterator, DataStructure dataStructure) throws IOException {
        DataStructure dataStructure2 = this.getAvailableDomains();
        block0: while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof HTTPBinding)) continue;
            IPAddress iPAddress = ((HTTPBinding)object).getHostAddress();
            Iterator iterator2 = dataStructure2.iterator();
            while (iterator2.hasNext()) {
                DPWSDomain dPWSDomain = (DPWSDomain)iterator2.next();
                if (!dPWSDomain.getIPAddress().equals(iPAddress)) continue;
                dataStructure.add(dPWSDomain);
                continue block0;
            }
        }
    }

    private void checkStopped() throws WS4DIllegalStateException {
        if (this.stopped) {
            throw new WS4DIllegalStateException("this communication manager is stopped");
        }
    }

    private void checkSupportedDPWSVersions(Message message) {
        HashSet hashSet = DPWSProperties.getInstance().getSupportedDPWSVersions();
        if (message.getProtocolInfo() == null && hashSet.size() == 1) {
            Iterator iterator = hashSet.iterator();
            Integer n = (Integer)iterator.next();
            message.setProtocolInfo(new DPWSProtocolInfo(n));
            return;
        }
        if (message.getProtocolInfo() != null) {
            if (!hashSet.contains(new Integer(message.getProtocolInfo().getVersion()))) {
                Iterator iterator = hashSet.iterator();
                Integer n = (Integer)iterator.next();
                message.setProtocolInfo(new DPWSProtocolInfo(n));
                if (Log.isDebug()) {
                    Log.debug("The choosen DPWS Versio is not supported, changed to " + message.getProtocolInfo().getDisplayName() + ".", 1);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SOAPoverUDPServer getSOAPoverUDPServer(IPAddress iPAddress, int n, String string) {
        String string2 = iPAddress.getAddress() + ":" + n + "%" + string;
        SOAPoverUDPServer sOAPoverUDPServer = null;
        HashMap hashMap = this.udpServers;
        synchronized (hashMap) {
            sOAPoverUDPServer = (SOAPoverUDPServer)this.udpServers.get(string2);
            if (sOAPoverUDPServer == null || !sOAPoverUDPServer.isRunning()) {
                try {
                    sOAPoverUDPServer = new SOAPoverUDPServer(iPAddress, n, string, new IncomingUDPReceiver());
                    this.udpServers.put(string2, sOAPoverUDPServer);
                }
                catch (IOException iOException) {
                    Log.warn("Unable to create SOAP-over-UDP server for multicast address " + string2 + ". " + iOException.getMessage());
                }
            }
        }
        return sOAPoverUDPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOAPServer getSOAPServer(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        Object object;
        String string2;
        SOAPServer sOAPServer;
        if (n == 0) {
            sOAPServer = SOAPServer.get(iPAddress, n, bl, string);
            string2 = iPAddress.getAddress() + ":" + sOAPServer.getHTTPServer().getPort();
            object = this.soapServers;
            synchronized (object) {
                this.soapServers.put(string2, sOAPServer);
            }
        }
        string2 = iPAddress.getAddress() + ":" + n;
        object = this.soapServers;
        synchronized (object) {
            sOAPServer = (SOAPServer)this.soapServers.get(string2);
            if (sOAPServer != null && sOAPServer.getHTTPServer().isRunning()) {
                return sOAPServer;
            }
            sOAPServer = SOAPServer.get(iPAddress, n, bl, string);
            this.soapServers.put(string2, sOAPServer);
        }
        object = sOAPServer.getHTTPServer();
        HashMap hashMap = this.httpServers;
        synchronized (hashMap) {
            this.httpServers.put(string2, object);
        }
        return sOAPServer;
    }

    private HTTPServer getHTTPServer(IPAddress iPAddress, int n) throws IOException {
        return this.getHTTPServer(iPAddress, n, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPServer getHTTPServer(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        HTTPServer hTTPServer;
        if (n == 0) {
            HTTPServer hTTPServer2 = HTTPServer.get(iPAddress, n, bl, string);
            HashMap hashMap = this.httpServers;
            synchronized (hashMap) {
                this.httpServers.put(iPAddress.getAddress() + ":" + hTTPServer2.getPort(), hTTPServer2);
            }
            return hTTPServer2;
        }
        String string2 = iPAddress.getAddress() + ":" + n;
        HashMap hashMap = this.httpServers;
        synchronized (hashMap) {
            hTTPServer = (HTTPServer)this.httpServers.get(string2);
            if (hTTPServer == null || !hTTPServer.isRunning()) {
                hTTPServer = HTTPServer.get(iPAddress, n, bl, string);
                this.httpServers.put(string2, hTTPServer);
            }
        }
        return hTTPServer;
    }

    private String getCanonicalAddress(String string) {
        return IPNetworkDetection.getInstance().getCanonicalAddress(string);
    }

    private void addUriToRegister(URI uRI, Set set) {
        set.add(uRI);
        URI uRI2 = this.createCanonicalUri(uRI);
        if (uRI2 != null) {
            set.add(uRI2);
        }
    }

    private void removeUriFromRegister(URI uRI, Set set) {
        set.remove(uRI);
        URI uRI2 = this.createCanonicalUri(uRI);
        if (uRI2 != null) {
            set.remove(uRI2);
        }
    }

    private URI createCanonicalUri(URI uRI) {
        String string = uRI.getHost();
        if (string == null || "".equals(string)) {
            return null;
        }
        String string2 = this.getCanonicalAddress(string);
        if (string.equals(string2)) {
            return null;
        }
        String string3 = uRI.toString();
        int n = string3.indexOf(string);
        string3 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
        URI uRI2 = new URI(string3);
        return uRI2;
    }

    protected void sendTCPAndCheckDPWSVersion(final Message message, final ResponseCallback responseCallback, final XAddressInfo xAddressInfo) {
        Runnable runnable = new Runnable(){

            public void run() {
                DPWSCommunicationManager.this.checkSupportedDPWSVersions(message);
                if (xAddressInfo.getProtocolInfo() == null || xAddressInfo.getProtocolInfo().getVersion() == -1) {
                    Message message6;
                    FaultAwareResponseCallback faultAwareResponseCallback = new FaultAwareResponseCallback(xAddressInfo, responseCallback, 2);
                    HashSet hashSet = DPWSProperties.getInstance().getSupportedDPWSVersions();
                    if (hashSet.contains(new Integer(0))) {
                        message6 = DPWS_UTIL.copyOutgoingMessage(message);
                        message6.setProtocolInfo(new DPWSProtocolInfo(0));
                        DPWSCommunicationManager.this.sendTCP(message6, faultAwareResponseCallback, xAddressInfo.getXAddress());
                    }
                    if (hashSet.contains(new Integer(1))) {
                        message6 = DPWS_UTIL.copyOutgoingMessage(message);
                        if (message instanceof GetMetadataMessage) {
                            Message message2 = DPWS_UTIL.changeOutgoingMessage(1, (GetMetadataMessage)message6);
                            message2.setProtocolInfo(new DPWSProtocolInfo(1));
                            MessageIDsForGetMetadataMapping.add(message2.getMessageId());
                            DPWSCommunicationManager.this.sendTCP(message2, responseCallback, xAddressInfo.getXAddress());
                        } else {
                            Message message3 = DPWS_UTIL.changeOutgoingMessage(1, message6);
                            message3.setProtocolInfo(new DPWSProtocolInfo(1));
                            DPWSCommunicationManager.this.sendTCP(message3, responseCallback, xAddressInfo.getXAddress());
                        }
                    }
                } else {
                    if (Log.isDebug()) {
                        Log.debug("Send " + message.getProtocolInfo().getDisplayName() + " Message", 1);
                    }
                    if (message.getProtocolInfo().getVersion() == 1) {
                        Message message7 = DPWS_UTIL.copyOutgoingMessage(message);
                        if (message instanceof GetMetadataMessage) {
                            Message message4 = DPWS_UTIL.changeOutgoingMessage(message.getProtocolInfo().getVersion(), (GetMetadataMessage)message7);
                            message4.setProtocolInfo(new DPWSProtocolInfo(1));
                            MessageIDsForGetMetadataMapping.add(message4.getMessageId());
                            DPWSCommunicationManager.this.sendTCP(message4, responseCallback, xAddressInfo.getXAddress());
                        } else {
                            Message message5 = DPWS_UTIL.changeOutgoingMessage(message.getProtocolInfo().getVersion(), message7);
                            message5.setProtocolInfo(new DPWSProtocolInfo(1));
                            DPWSCommunicationManager.this.sendTCP(message5, responseCallback, xAddressInfo.getXAddress());
                        }
                    } else {
                        DPWSCommunicationManager.this.sendTCP(message, responseCallback, xAddressInfo.getXAddress());
                    }
                }
            }
        };
        DPWSFramework.getThreadPool().execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUDPMulticastAndCheckDPWSVersion(Message message, ProtocolDomain protocolDomain, ResponseCallback responseCallback) {
        this.checkSupportedDPWSVersions(message);
        Object object = this.udpTransmissionsLock;
        synchronized (object) {
            ++this.pendingUDPTransmissions;
            if (message.getProtocolInfo() == null) {
                ++this.pendingUDPTransmissions;
            }
        }
        if (message.getProtocolInfo() == null || message.getProtocolInfo().getVersion() == -1) {
            Message message2;
            object = DPWSProperties.getInstance().getSupportedDPWSVersions();
            if (((HashSet)object).contains(new Integer(0))) {
                message2 = DPWS_UTIL.copyOutgoingMessage(message);
                DPWS_UTIL.changeOutgoingMessage(0, message2);
                message2.setProtocolInfo(new DPWSProtocolInfo(0));
                this.sendUDPMulticast(message2, protocolDomain, responseCallback);
            }
            if (((HashSet)object).contains(new Integer(1))) {
                message2 = DPWS_UTIL.copyOutgoingMessage(message);
                DPWS_UTIL.changeOutgoingMessage(1, message2);
                message2.setProtocolInfo(new DPWSProtocolInfo(1));
                this.sendUDPMulticast(message2, protocolDomain, responseCallback);
            }
        } else {
            if (Log.isDebug()) {
                Log.debug("Send " + message.getProtocolInfo().getDisplayName() + " Message", 1);
            }
            if (message.getProtocolInfo().getVersion() == 1) {
                DPWS_UTIL.changeOutgoingMessage(message.getProtocolInfo().getVersion(), message);
            }
            this.sendUDPMulticast(message, protocolDomain, responseCallback);
        }
    }

    protected void sendTCP(Message message, ResponseCallback responseCallback, URI uRI) {
        MessageReceiver messageReceiver = responseCallback == null ? GENERIC_RECEIVER : new SOAPResponseReceiver(message, responseCallback);
        SOAPRequest sOAPRequest = new SOAPRequest(uRI.getPath(), message, messageReceiver);
        if (DPWSFramework.hasModule(64) && DPWSFramework.getSecurityManager().isHTTPS(uRI)) {
            HTTPClient.exchange(new HTTPClientDestination(uRI, true, null), sOAPRequest);
        } else {
            HTTPClient.exchange(new HTTPClientDestination(uRI), sOAPRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUDPMulticast(final Message message, final ProtocolDomain protocolDomain, final ResponseCallback responseCallback) {
        if (!(protocolDomain instanceof DPWSDomain)) {
            return;
        }
        SENT_MULTICAST_MESSAGE_IDS.containsOrEnqueue(message.getMessageId());
        final Waiter waiter = new Waiter();
        final DPWSCommunicationManager dPWSCommunicationManager = this;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                block23: {
                    int n;
                    Object object2 = waiter;
                    synchronized (object2) {
                        waiter.pending = false;
                        waiter.notify();
                    }
                    object2 = (DPWSDomain)protocolDomain;
                    IPAddress iPAddress = ((DPWSDomain)object2).getIPAddress();
                    int n2 = 3702;
                    IPAddress iPAddress2 = iPAddress.isIPv6() ? DPWSDiscoveryBinding.DPWS_MCAST_GROUP_IPv6 : DPWSDiscoveryBinding.DPWS_MCAST_GROUP_IPv4;
                    URI uRI = message.getTargetAddress();
                    if (uRI != null) {
                        iPAddress2 = new IPAddress(DPWSCommunicationManager.this.getCanonicalAddress(uRI.getHost()));
                        if (uRI.getPort() > 0) {
                            n2 = uRI.getPort();
                        }
                    }
                    if ((n = message.getType()) == 1 || n == 4) {
                        try {
                            Thread.sleep(dPWSCommunicationManager.getRandomApplicationDelay(message.getProtocolInfo().getVersion()));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    SOAPoverUDPClient sOAPoverUDPClient = null;
                    DPWSProtocolData dPWSProtocolData = new DPWSProtocolData(((DPWSDomain)object2).getInterfaceName(), false, iPAddress.getAddressWithoutNicId(), 0, iPAddress2.getAddressWithoutNicId(), 3702, false);
                    try {
                        object = DPWSCommunicationManager.this.udpClientsPerDomain;
                        synchronized (object) {
                            sOAPoverUDPClient = (SOAPoverUDPClient)DPWSCommunicationManager.this.udpClientsPerDomain.get(object2);
                            if (sOAPoverUDPClient == null || sOAPoverUDPClient.isClosed()) {
                                sOAPoverUDPClient = SOAPoverUDPClient.get(iPAddress, 0, ((DPWSDomain)object2).getInterfaceName());
                                DPWSCommunicationManager.this.udpClientsPerDomain.put(object2, sOAPoverUDPClient);
                            }
                        }
                        if (responseCallback != null && (n == 3 || n == 5)) {
                            DPWSCommunicationManager.this.rrc.registerResponseCallback(message, responseCallback, DispatchingProperties.getInstance().getMatchWaitTime());
                        }
                        sOAPoverUDPClient.send(iPAddress2, n2, message, DPWSCommunicationManager.this.udpResponseHandler, dPWSProtocolData);
                        MESSAGE_INFORMER.forwardMessage(message, dPWSProtocolData);
                    }
                    catch (IOException iOException) {
                        Log.warn("Could not multicast DPWS message to " + iPAddress2 + ":" + 3702 + " over " + iPAddress + ":" + dPWSProtocolData.getSourcePort() + " due to an exception. Message: " + message + ", Exception: " + iOException.getMessage() + ", Callback: " + (responseCallback == null ? "no callback" : responseCallback.toString()));
                        try {
                            sOAPoverUDPClient.close();
                        }
                        catch (IOException iOException2) {
                            Log.warn("Unable to close unusable UDP client");
                        }
                        HashMap hashMap = DPWSCommunicationManager.this.udpClientsPerDomain;
                        synchronized (hashMap) {
                            DPWSCommunicationManager.this.udpClientsPerDomain.remove(object2);
                        }
                        if (responseCallback == null) break block23;
                        responseCallback.handleTransmissionException(message, iOException, dPWSProtocolData);
                    }
                }
                object = DPWSCommunicationManager.this.udpTransmissionsLock;
                synchronized (object) {
                    DPWSCommunicationManager.this.pendingUDPTransmissions--;
                    DPWSCommunicationManager.this.udpTransmissionsLock.notifyAll();
                }
            }
        };
        DPWSFramework.getThreadPool().execute(runnable);
        Waiter waiter2 = waiter;
        synchronized (waiter2) {
            while (waiter.pending) {
                try {
                    waiter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void serializeMessageWithAttachments(Message message, String string, List list, OutputStream outputStream, ProtocolData protocolData) throws IOException {
        if (string == null) {
            SOAPMessageGeneratorFactory.getInstance().getMessage2SOAPGeneratorForCurrentThread().generateSOAPMessage(outputStream, message, protocolData);
        } else {
            MIMEUtil.writeBoundary(outputStream, string.getBytes(), false, false);
            MIMEBodyHeader mIMEBodyHeader = new MIMEBodyHeader();
            mIMEBodyHeader.setHeaderField("Content-ID", "soap-envelope");
            mIMEBodyHeader.setHeaderField("Content-Type", InternetMediaType.getApplicationXOPXML().toString());
            mIMEBodyHeader.setHeaderField("Content-Transfer-Encoding", "binary");
            mIMEBodyHeader.toStream(outputStream);
            SOAPMessageGeneratorFactory.getInstance().getMessage2SOAPGeneratorForCurrentThread().generateSOAPMessage(outputStream, message, protocolData);
            outputStream.flush();
            while (!list.isEmpty() && DPWSFramework.hasModule(32)) {
                Attachment attachment = (Attachment)list.remove(0);
                mIMEBodyHeader = new MIMEBodyHeader();
                mIMEBodyHeader.setHeaderField("Content-ID", attachment.getContentId());
                try {
                    String string2 = "";
                    InternetMediaType internetMediaType = attachment.getContentType();
                    string2 = internetMediaType != null ? internetMediaType.toString() : InternetMediaType.getApplicationOctetStream().toString();
                    String string3 = attachment.getTransferEncoding();
                    if (string3 == null) {
                        string3 = "binary";
                    }
                    mIMEBodyHeader.setHeaderField("Content-Type", string2);
                    mIMEBodyHeader.setHeaderField("Content-Transfer-Encoding", string3);
                }
                catch (AttachmentException attachmentException) {
                    Log.printStackTrace(attachmentException);
                }
                MIMEUtil.writeBoundary(outputStream, string.getBytes(), false, false);
                mIMEBodyHeader.toStream(outputStream);
                outputStream.flush();
                try {
                    attachment.serialize(outputStream);
                }
                catch (AttachmentException attachmentException) {
                    throw new IOException(attachmentException.getMessage());
                }
                outputStream.flush();
            }
            MIMEUtil.writeBoundary(outputStream, string.getBytes(), false, true);
        }
        outputStream.flush();
    }

    public ProtocolInfo getProtocolInfo() {
        return new DPWSProtocolInfo();
    }

    public CommunicationUtil getCommunicationUtil() {
        return DPWS_UTIL;
    }

    public ProtocolInfo createProtocolInfo(int n) {
        return new DPWSProtocolInfo(n);
    }

    public HashSet getSupportedVersions() {
        return DPWSProperties.getInstance().getSupportedDPWSVersions();
    }

    public boolean supportsAddressingNamespace(SOAPHeader sOAPHeader, String string, ProtocolData protocolData) throws VersionMismatchException {
        if ("http://www.w3.org/2005/08/addressing".equals(string)) {
            if (this.getSupportedVersions().contains(new Integer(0))) {
                protocolData.setProtocolInfo(this.createProtocolInfo(0));
                sOAPHeader.setProtocolInfo(protocolData.getProtocolInfo());
                return true;
            }
            throw new VersionMismatchException("WS-Addressing: " + string + " is not supported in this Configuration", 1);
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) {
            if (this.getSupportedVersions().contains(new Integer(1))) {
                protocolData.setProtocolInfo(this.createProtocolInfo(1));
                sOAPHeader.setProtocolInfo(protocolData.getProtocolInfo());
                return true;
            }
            throw new VersionMismatchException("WS-Addressing: " + string + " is not supported in this Configuration", 1);
        }
        return false;
    }

    public QNameSet getDeviceTypes() {
        QNameSet qNameSet = new QNameSet();
        Iterator iterator = this.getSupportedVersions().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = n;
            switch (n2) {
                case 0: {
                    qNameSet.add(DPWSConstants.DPWS_QN_DEVICETYPE);
                    break;
                }
                case 1: {
                    qNameSet.add(DPWSConstants2006.DPWS_QN_DEVICETYPE);
                }
            }
        }
        return qNameSet;
    }

    private static class Waiter {
        volatile boolean pending = true;

        private Waiter() {
        }
    }
}

