/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.WS4DIllegalStateException;

public abstract class IPBinding
implements CommunicationBinding {
    public static final int HTTP_BINDING = 0;
    public static final int HTTPS_BINDING = 1;
    public static final int DISCOVERY_BINDING = 2;
    protected IPAddress ipAddress = null;
    protected int port = -1;
    protected URI transportAddress = null;

    protected IPBinding(IPAddress iPAddress, int n) {
        if (iPAddress == null) {
            throw new WS4DIllegalStateException("Cannot create IP binding without IP host address");
        }
        if (n < 0 || n > 65535) {
            throw new WS4DIllegalStateException("Cannot create IP binding with illegal port number");
        }
        this.ipAddress = iPAddress;
        this.port = n;
    }

    public String getCommunicationManagerId() {
        return "DPWS";
    }

    public IPAddress getHostAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public abstract int getType();

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.ipAddress.hashCode();
        n = 31 * n + this.port;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IPBinding iPBinding = (IPBinding)object;
        if (!this.ipAddress.equals(iPBinding.ipAddress)) {
            return false;
        }
        return this.port == iPBinding.port;
    }

    public String toString() {
        return this.ipAddress + ":" + this.port;
    }
}

