/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWS2006.DefaultDPWSCommunicatonUtil;
import org.ws4d.java.communication.DPWSProtocolInfo;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.VersionMismatchException;
import org.ws4d.java.communication.protocol.soap.server.SOAPServer;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.util.Log;

final class IncomingSOAPReceiver
extends SOAPServer.SOAPHandler {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final IncomingMessageListener listener;
    private final DefaultDPWSCommunicatonUtil util = DefaultDPWSCommunicatonUtil.getInstance();

    static void markIncoming(Message message) {
        message.setInbound(true);
        if (Log.isDebug()) {
            Log.debug("<I> " + message, 4);
        }
    }

    static void markOutgoing(Message message) {
        message.setInbound(false);
        if (Log.isDebug()) {
            Log.debug("<O> " + message, 4);
        }
    }

    private static void checkEventingPresence(Message message) throws SOAPException {
        if (DPWSFramework.hasModule(4)) {
            return;
        }
        throw new SOAPException(FaultMessage.createActionNotSupportedFault(message));
    }

    IncomingSOAPReceiver(IncomingMessageListener incomingMessageListener) {
        this.listener = incomingMessageListener;
    }

    public void receive(HelloMessage helloMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(helloMessage, protocolData);
    }

    public void receive(ByeMessage byeMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(byeMessage, protocolData);
    }

    public void receive(ProbeMessage probeMessage, ProtocolData protocolData) {
        probeMessage.setDirected(true);
        IncomingSOAPReceiver.markIncoming(probeMessage);
        try {
            ProbeMatchesMessage probeMatchesMessage = this.listener.handle(probeMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(probeMessage, protocolData);
            if (probeMatchesMessage == null) {
                return;
            }
            this.util.changeOutgoingMessage(probeMatchesMessage.getProtocolInfo().getVersion(), (Message)probeMatchesMessage);
            this.respondWithMessage(probeMatchesMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(probeMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(probeMatchesMessage, protocolData);
    }

    public void receive(ResolveMessage resolveMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(resolveMessage, protocolData);
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(resolveMatchesMessage, protocolData);
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getMessage);
        try {
            GetResponseMessage getResponseMessage = this.listener.handle(getMessage, protocolData);
            this.util.changeOutgoingMessage(getResponseMessage.getProtocolInfo().getVersion(), (Message)getResponseMessage);
            MESSAGE_INFORMER.forwardMessage(getMessage, protocolData);
            this.respondWithMessage(getResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(getMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(getResponseMessage, protocolData);
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getMetadataMessage);
        try {
            MESSAGE_INFORMER.forwardMessage(getMetadataMessage, protocolData);
            GetMetadataResponseMessage getMetadataResponseMessage = this.listener.handle(getMetadataMessage, protocolData);
            this.util.changeOutgoingMessage(getMetadataResponseMessage.getProtocolInfo().getVersion(), (Message)getMetadataResponseMessage);
            this.respondWithMessage(getMetadataResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(getMetadataMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(getMetadataResponseMessage, protocolData);
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(subscribeMessage);
        try {
            IncomingSOAPReceiver.checkEventingPresence(subscribeMessage);
            SubscribeResponseMessage subscribeResponseMessage = this.listener.handle(subscribeMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(subscribeMessage, protocolData);
            this.respondWithMessage(subscribeResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(subscribeMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(subscribeResponseMessage, protocolData);
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(getStatusMessage);
        try {
            IncomingSOAPReceiver.checkEventingPresence(getStatusMessage);
            GetStatusResponseMessage getStatusResponseMessage = this.listener.handle(getStatusMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(getStatusMessage, protocolData);
            this.respondWithMessage(getStatusResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(getStatusMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(getStatusResponseMessage, protocolData);
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(renewMessage);
        try {
            IncomingSOAPReceiver.checkEventingPresence(renewMessage);
            RenewResponseMessage renewResponseMessage = this.listener.handle(renewMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(renewMessage, protocolData);
            this.respondWithMessage(renewResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(renewMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(renewResponseMessage, protocolData);
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(unsubscribeMessage);
        try {
            IncomingSOAPReceiver.checkEventingPresence(unsubscribeMessage);
            UnsubscribeResponseMessage unsubscribeResponseMessage = this.listener.handle(unsubscribeMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(unsubscribeMessage, protocolData);
            this.respondWithMessage(unsubscribeResponseMessage);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(unsubscribeMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(unsubscribeResponseMessage, protocolData);
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(subscriptionEndMessage);
        this.listener.handle(subscriptionEndMessage, protocolData);
        MESSAGE_INFORMER.forwardMessage(subscriptionEndMessage, protocolData);
        this.respond(202, null);
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(invokeMessage);
        try {
            InvokeMessage invokeMessage2 = this.listener.handle(invokeMessage, protocolData);
            MESSAGE_INFORMER.forwardMessage(invokeMessage, protocolData);
            this.respondWithMessage(invokeMessage2);
        }
        catch (SOAPException sOAPException) {
            MESSAGE_INFORMER.forwardMessage(invokeMessage, protocolData);
            this.respondWithFault(sOAPException);
        }
    }

    public OperationDescription getOperation(String string) {
        return this.listener.getOperation(string);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        this.respondWithActionNotSupported(faultMessage, protocolData);
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
        if (exception instanceof VersionMismatchException) {
            VersionMismatchException versionMismatchException = (VersionMismatchException)exception;
            if (versionMismatchException.getType() == 1) {
                FaultMessage faultMessage = FaultMessage.createMessageAddressingHeaderRequired(protocolData.getCommunicationManagerId());
                HashSet hashSet = DPWSProperties.getInstance().getSupportedDPWSVersions();
                if (hashSet.size() == 1 && (Integer)hashSet.iterator().next() == 1) {
                    faultMessage.setProtocolInfo(new DPWSProtocolInfo(1));
                    this.util.changeOutgoingMessage(faultMessage.getProtocolInfo().getVersion(), (Message)faultMessage);
                } else {
                    faultMessage.setProtocolInfo(new DPWSProtocolInfo(0));
                }
                this.respond(400, faultMessage);
            }
        } else {
            this.respond(400, null);
        }
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
    }

    private void respondWithMessage(Message message) {
        if (message == null) {
            this.respond(202, null);
        } else {
            IncomingSOAPReceiver.markOutgoing(message);
            this.respond(200, message);
        }
    }

    private void respondWithFault(SOAPException sOAPException) {
        FaultMessage faultMessage = sOAPException.getFault();
        IncomingSOAPReceiver.markOutgoing(faultMessage);
        if (SOAPConstants.SOAP_FAULT_SENDER.equals(faultMessage.getCode())) {
            this.respond(400, faultMessage);
        } else {
            this.respond(500, faultMessage);
        }
    }

    private void respondWithActionNotSupported(Message message, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(message);
        String string = message.getAction().toString();
        Log.error("<I> Unexpected SOAP request message: " + string);
        if (Log.isDebug()) {
            Log.error(message.toString());
        }
        MESSAGE_INFORMER.forwardMessage(message, protocolData);
        FaultMessage faultMessage = FaultMessage.createActionNotSupportedFault(message);
        IncomingSOAPReceiver.markOutgoing(faultMessage);
        this.respond(400, faultMessage);
    }
}

