/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.tcp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.util.Log;

public class SESocket
implements Socket {
    private static final String ANY_ADDRESS = "0.0.0.0";
    java.net.Socket socket;
    private IPAddress ipAddress = null;
    private int port = -1;
    private InputStream in = null;
    private OutputStream out = null;

    public SESocket(IPAddress iPAddress, int n) throws IOException {
        String string = iPAddress.getAddressWithoutNicId();
        this.socket = new java.net.Socket(string, n);
        this.port = this.socket.getLocalPort();
    }

    public SESocket(java.net.Socket socket, IPAddress iPAddress) {
        this.socket = socket;
        this.ipAddress = iPAddress;
        this.port = socket.getLocalPort();
    }

    public void close() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not close connection");
        }
        this.socket.close();
    }

    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not open input stream");
        }
        if (this.in == null) {
            this.in = this.socket.getInputStream();
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("No open connection. Can not open output stream");
        }
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
        }
        return this.out;
    }

    public IPAddress getRemoteAddress() {
        if (this.socket == null) {
            return null;
        }
        InetAddress inetAddress = this.socket.getInetAddress();
        if (inetAddress != null) {
            return new IPAddress(inetAddress.getHostAddress());
        }
        return null;
    }

    public int getRemotePort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    public IPAddress getLocalAddress() {
        InetAddress inetAddress = this.socket.getLocalAddress();
        String string = inetAddress.getHostAddress();
        if (string.equals(ANY_ADDRESS)) {
            string = this.socket.getInetAddress().getHostAddress();
            if (Log.isDebug()) {
                Log.debug("Local IP address workaround used. Local address was a (0.0.0.0) wildcard.");
            }
        }
        if (this.ipAddress == null) {
            this.ipAddress = IPNetworkDetection.getInstance().getIPAddress(string);
        }
        return this.ipAddress;
    }

    public int getLocalPort() {
        return this.port;
    }
}

