/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.connection.udp;

import java.io.IOException;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.udp.DatagramSocket;
import org.ws4d.java.communication.connection.udp.DatagramSocketFactory;
import org.ws4d.java.communication.connection.udp.UDPDatagramHandler;
import org.ws4d.java.communication.connection.udp.UDPListener;
import org.ws4d.java.communication.connection.udp.UDPServer;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class UDPClient {
    private boolean closed = false;
    private static final int UDP_RECEIVER_TIMEOUT = 20000;
    private IPAddress ipAddress = null;
    private int port = -1;
    private String ifaceName;
    private UDPListener listener = null;
    private ListenerTimeout timeout = null;
    private static HashMap clients = new HashMap();

    public static synchronized UDPClient get(IPAddress iPAddress, int n, String string) {
        if (n == 0) {
            return new UDPClient(iPAddress, n, string);
        }
        String string2 = iPAddress.getAddress() + "@" + n + "%" + string;
        UDPClient uDPClient = (UDPClient)clients.get(string2);
        if (uDPClient != null) {
            return uDPClient;
        }
        uDPClient = new UDPClient(iPAddress, n, string);
        clients.put(string2, uDPClient);
        return uDPClient;
    }

    private UDPClient(IPAddress iPAddress, int n, String string) {
        this.ipAddress = iPAddress;
        this.port = n;
        this.ifaceName = string;
    }

    public synchronized void send(IPAddress iPAddress, int n, byte[] byArray, int n2) throws IOException {
        if (this.closed) {
            return;
        }
        DatagramSocket datagramSocket = DatagramSocketFactory.getInstance().createDatagramSocket(this.ipAddress, this.port, this.ifaceName);
        this.send(datagramSocket, iPAddress, n, byArray, n2);
        datagramSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(IPAddress iPAddress, int n, byte[] byArray, int n2, UDPDatagramHandler uDPDatagramHandler, ProtocolData protocolData) throws IOException {
        Object object;
        if (this.closed) {
            return;
        }
        if (uDPDatagramHandler == null) {
            this.send(iPAddress, n, byArray, n2);
            return;
        }
        if (this.listener == null) {
            this.listener = new UDPListener(this.ipAddress, this.port, this.ifaceName, uDPDatagramHandler);
            if (this.port == 0) {
                this.port = this.listener.getPort();
                object = this.ipAddress.getAddress() + "@" + this.port + "%" + this.ifaceName;
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    clients.put(object, this);
                }
            }
            this.timeout = new ListenerTimeout(this.listener);
            WatchDog.getInstance().register(this.timeout, 20000L);
            this.listener.start();
        }
        object = this.listener.getDatagramSocket();
        if (protocolData instanceof DPWSProtocolData) {
            ((DPWSProtocolData)protocolData).setSourcePort(object.getSocketPort());
        }
        this.send((DatagramSocket)object, iPAddress, n, byArray, n2);
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.listener != null) {
            WatchDog.getInstance().unregister(this.timeout);
            this.listener.stop();
            this.listener = null;
        }
        this.closed = true;
        clients.remove(this);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public String getIfaceName() {
        return this.ifaceName;
    }

    public IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    private void send(DatagramSocket datagramSocket, IPAddress iPAddress, int n, byte[] byArray, int n2) throws IOException {
        UDPServer.send(datagramSocket, iPAddress, n, byArray, n2);
    }

    private class ListenerTimeout
    extends TimedEntry {
        private UDPListener listener = null;

        ListenerTimeout(UDPListener uDPListener) {
            this.listener = uDPListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timedOut() {
            UDPClient uDPClient = UDPClient.this;
            synchronized (uDPClient) {
                if (this.listener != null) {
                    try {
                        this.listener.stop();
                    }
                    catch (IOException iOException) {
                        Log.warn("Could not stop UDP listener from UDP client.");
                    }
                }
                UDPClient.this.closed = true;
            }
        }
    }
}

