/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.tcp.TCPClient;
import org.ws4d.java.communication.connection.tcp.TCPConnection;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.ChunkedOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPClientDestination;
import org.ws4d.java.communication.protocol.http.HTTPOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPRequest;
import org.ws4d.java.communication.protocol.http.HTTPResponseHandler;
import org.ws4d.java.communication.protocol.http.SimpleHTTPClient;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.communication.protocol.http.requests.DefaultHTTPGetRequest;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.configuration.HTTPProperties;
import org.ws4d.java.message.Message;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.Queue;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.Sync;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class HTTPClient
extends TimedEntry {
    public static int MAX_CLIENT_CONNECTIONS = HTTPProperties.getInstance().getMaxConnections();
    private boolean closed = false;
    private SimpleHTTPClient simpleHTTPClient = null;
    private AsyncRequesterWriter requester = null;
    private AsyncResponseReader responder = null;
    private HashMap handlers = new HashMap();
    private boolean keepalive = true;
    private boolean writerReady = false;
    private boolean readerReady = false;
    private Queue pendingRequests = null;
    private static long REQUEST_TIMEOUT = 5000L;
    private static boolean multipleCons = true;
    private static HashMap allClients = new HashMap();
    private static HashMap freeClients = new HashMap();
    private static final DPWSProperties properties = DPWSProperties.getInstance();

    public static synchronized void killAllClients() {
        Iterator iterator = allClients.values().iterator();
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next();
            if (linkedList != null) {
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    HTTPClient hTTPClient = (HTTPClient)iterator2.next();
                    hTTPClient.kill(false);
                    iterator2.remove();
                }
            }
            iterator.remove();
        }
    }

    public static synchronized void closeAllClients() {
        Iterator iterator = allClients.values().iterator();
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next();
            if (linkedList != null) {
                Iterator iterator2 = linkedList.iterator();
                while (iterator2.hasNext()) {
                    HTTPClient hTTPClient = (HTTPClient)iterator2.next();
                    hTTPClient.close(false);
                    iterator2.remove();
                }
            }
            iterator.remove();
        }
    }

    private static HTTPClient addClient(HTTPClient hTTPClient) {
        LinkedList linkedList = (LinkedList)allClients.get(hTTPClient.simpleHTTPClient.getDestination());
        if (linkedList == null) {
            linkedList = new LinkedList();
            allClients.put(hTTPClient.simpleHTTPClient.getDestination(), linkedList);
        }
        linkedList.add(hTTPClient);
        return hTTPClient;
    }

    private static void removeClient(HTTPClient hTTPClient) {
        LinkedList linkedList = (LinkedList)allClients.get(hTTPClient.simpleHTTPClient.getDestination());
        linkedList.remove(hTTPClient);
        if (linkedList.size() == 0) {
            allClients.remove(hTTPClient.simpleHTTPClient.getDestination());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addFreeClient(HTTPClient hTTPClient) {
        HTTPRequest hTTPRequest = hTTPClient.getPendingRequest();
        if (hTTPRequest != null) {
            hTTPClient.requester.setRequest(hTTPRequest);
            return;
        }
        HashMap hashMap = freeClients;
        synchronized (hashMap) {
            LinkedList linkedList = (LinkedList)freeClients.get(hTTPClient.simpleHTTPClient.getDestination());
            if (linkedList == null) {
                linkedList = new LinkedList();
                linkedList.addFirst(hTTPClient);
                freeClients.put(hTTPClient.simpleHTTPClient.getDestination(), linkedList);
            } else {
                linkedList.addFirst(hTTPClient);
            }
            WatchDog.getInstance().register(hTTPClient, REQUEST_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean removeFreeClient(HTTPClient hTTPClient) {
        boolean bl = false;
        HashMap hashMap = freeClients;
        synchronized (hashMap) {
            WatchDog.getInstance().unregister(hTTPClient);
            LinkedList linkedList = (LinkedList)freeClients.get(hTTPClient.simpleHTTPClient.getDestination());
            if (linkedList != null) {
                bl = linkedList.remove(hTTPClient);
                if (linkedList.size() == 0) {
                    freeClients.remove(hTTPClient.simpleHTTPClient.getDestination());
                }
            }
        }
        return bl;
    }

    private HTTPClient(HTTPClientDestination hTTPClientDestination) {
        this.simpleHTTPClient = new SimpleHTTPClient(hTTPClientDestination);
        this.keepalive = properties.getHTTPClientKeepAlive();
        this.responder = new AsyncResponseReader(this);
        this.requester = new AsyncRequesterWriter(this);
    }

    public void register(InternetMediaType internetMediaType, HTTPResponseHandler hTTPResponseHandler) {
        this.handlers.put(internetMediaType, hTTPResponseHandler);
    }

    public static synchronized void exchange(HTTPClientDestination hTTPClientDestination) {
        HTTPClient.exchange(hTTPClientDestination, "/");
    }

    public static synchronized void exchange(HTTPClientDestination hTTPClientDestination, String string) {
        HTTPClient.exchange(hTTPClientDestination, new DefaultHTTPGetRequest(string));
    }

    public static synchronized void exchange(HTTPClientDestination hTTPClientDestination, HTTPRequest hTTPRequest) {
        HTTPClient.addRequest(hTTPClientDestination, hTTPRequest);
    }

    public String getPresetRequest() {
        return this.simpleHTTPClient.getPresetRequest();
    }

    public TCPConnection getTCPConnection() {
        TCPClient tCPClient;
        if (this.simpleHTTPClient != null && (tCPClient = this.simpleHTTPClient.getTCPClient()) != null) {
            return tCPClient.getConnection();
        }
        return null;
    }

    public synchronized void close() {
        this.close(true);
    }

    private void close(boolean bl) {
        if (this.closed) {
            return;
        }
        HTTPClient.removeFreeClient(this);
        this.closed = true;
        this.requester.stop();
        this.responder.stop();
        try {
            this.simpleHTTPClient.close();
        }
        catch (IOException iOException) {
            Log.error("Cannot close client connection. " + iOException.getMessage());
        }
        if (bl) {
            HTTPClient.removeClient(this);
        }
    }

    public synchronized void kill() {
        this.kill(true);
    }

    private void kill(boolean bl) {
        if (this.closed) {
            return;
        }
        HTTPClient.removeFreeClient(this);
        this.closed = true;
        try {
            this.simpleHTTPClient.close();
        }
        catch (IOException iOException) {
            Log.error("Cannot close client connection. " + iOException.getMessage());
        }
        this.requester.stop();
        this.responder.kill();
        if (bl) {
            HTTPClient.removeClient(this);
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private int eat(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return 0;
        }
        int n = 0;
        while (inputStream.read() != -1) {
            ++n;
        }
        return n;
    }

    protected void timedOut() {
        if (Log.isDebug()) {
            TCPConnection tCPConnection = this.getTCPConnection();
            if (tCPConnection != null) {
                Log.debug("HTTP client timeout: " + tCPConnection.getProtocolData(), 1);
            } else {
                Log.debug("HTTP client timeout, no connection data available.", 1);
            }
        }
        if (!HTTPClient.removeFreeClient(this)) {
            return;
        }
        this.close();
    }

    private synchronized void writerReady() {
        if (this.readerReady) {
            if (this.keepalive && this.requester.running && this.responder.running) {
                this.readerReady = false;
                HTTPClient.addFreeClient(this);
            } else {
                this.closeAndProcessPendingRequest();
            }
        } else {
            this.writerReady = true;
        }
    }

    private synchronized void readerReady() {
        if (this.writerReady) {
            if (this.keepalive && this.requester.running && this.responder.running) {
                this.writerReady = false;
                HTTPClient.addFreeClient(this);
            } else {
                this.closeAndProcessPendingRequest();
            }
        } else {
            this.readerReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRequest(HTTPClientDestination hTTPClientDestination, HTTPRequest hTTPRequest) {
        HTTPClient hTTPClient = null;
        HashMap hashMap = freeClients;
        synchronized (hashMap) {
            LinkedList linkedList = (LinkedList)freeClients.get(hTTPClientDestination);
            if (linkedList == null) {
                int n;
                LinkedList linkedList2 = (LinkedList)allClients.get(hTTPClientDestination);
                int n2 = n = linkedList2 == null ? 0 : linkedList2.size();
                if (!multipleCons) {
                    if (linkedList2 != null) {
                        hTTPClient = (HTTPClient)linkedList2.getFirst();
                        hTTPClient.queueRequest(hTTPRequest);
                        return;
                    }
                } else if (n >= hTTPClientDestination.getMaxConnections() && linkedList2 != null) {
                    hTTPClient = (HTTPClient)linkedList2.getFirst();
                    hTTPClient.queueRequest(hTTPRequest);
                    return;
                }
                hTTPClient = new HTTPClient(hTTPClientDestination);
                HTTPClient.addClient(hTTPClient);
            } else {
                hTTPClient = (HTTPClient)linkedList.removeFirst();
                WatchDog.getInstance().unregister(hTTPClient);
                if (linkedList.size() == 0) {
                    freeClients.remove(hTTPClientDestination);
                }
            }
        }
        if (hTTPClient.isClosed()) {
            throw new RuntimeException("Cannot send request. HTTP client closed.");
        }
        hTTPClient.requester.setRequest(hTTPRequest);
    }

    private void queueRequest(HTTPRequest hTTPRequest) {
        if (this.pendingRequests == null) {
            this.pendingRequests = new Queue();
        }
        this.pendingRequests.enqueue(hTTPRequest);
    }

    private HTTPRequest getPendingRequest() {
        if (this.pendingRequests == null) {
            return null;
        }
        return (HTTPRequest)this.pendingRequests.get();
    }

    private void closeAndProcessPendingRequest() {
        this.close();
        HTTPRequest hTTPRequest = this.getPendingRequest();
        if (hTTPRequest != null) {
            HTTPClientDestination hTTPClientDestination = this.simpleHTTPClient.getDestination();
            HTTPClient hTTPClient = new HTTPClient(hTTPClientDestination);
            HTTPClient.addClient(hTTPClient);
            hTTPClient.pendingRequests = this.pendingRequests;
            hTTPClient.requester.setRequest(hTTPRequest);
        }
    }

    private class ExceptionNotification
    implements Runnable {
        private HTTPRequest request = null;
        private Exception e = null;
        private boolean response = false;
        private ProtocolData pd = null;

        ExceptionNotification(ProtocolData protocolData, HTTPRequest hTTPRequest, Exception exception, boolean bl) {
            this.request = hTTPRequest;
            this.e = exception;
            this.response = bl;
            this.pd = protocolData;
        }

        public void run() {
            if (this.request != null && this.e != null) {
                if (this.response) {
                    this.request.responseReceiveFailed(this.e, this.pd);
                } else {
                    this.request.requestSendFailed(this.e, this.pd);
                }
            }
        }

        public void start() {
            DPWSFramework.getThreadPool().execute(this);
        }
    }

    private class StreamConsumerThread
    implements Runnable {
        private HTTPResponseHandler handler = null;
        private HTTPResponseHeader header = null;
        private InputStream body = null;
        private HTTPRequest request = null;
        private final MonitoringContext context;

        StreamConsumerThread(HTTPResponseHandler hTTPResponseHandler, HTTPResponseHeader hTTPResponseHeader, InputStream inputStream, HTTPRequest hTTPRequest, MonitoringContext monitoringContext) {
            this.handler = hTTPResponseHandler;
            this.header = hTTPResponseHeader;
            this.body = inputStream;
            this.request = hTTPRequest;
            this.context = monitoringContext;
        }

        public void run() {
            if (this.handler != null) {
                try {
                    this.handler.handle(this.header, this.body, this.request, HTTPClient.this.simpleHTTPClient.getTCPClient().getConnection().getProtocolData(), this.context);
                }
                catch (IOException iOException) {
                    try {
                        int n = HTTPClient.this.eat(this.body);
                        if (n > 0) {
                            Log.warn("The registered handler has not consumed the HTTP body from the response because of an exception. Eating " + n + " bytes. Exception was: " + iOException.getMessage());
                        }
                    }
                    catch (IOException iOException2) {
                        Log.error("Could not consume omitted bytes from HTTP response. " + iOException2.getMessage());
                    }
                }
                try {
                    int n = HTTPClient.this.eat(this.body);
                    if (n > 0) {
                        Log.warn("The registered handler has not consumed the HTTP body from the response. Eating " + n + " bytes.");
                    }
                }
                catch (IOException iOException) {
                    Log.error("Could not consume omitted bytes from HTTP response. " + iOException.getMessage());
                }
            } else {
                try {
                    int n = HTTPClient.this.eat(this.body);
                    if (n > 0) {
                        Log.warn("No registered handler was found to consume the HTTP body from the response. Eating " + n + " bytes.");
                        this.header.toStream(System.err);
                    }
                }
                catch (IOException iOException) {
                    Log.error("Could not consume omitted bytes from HTTP response. " + iOException.getMessage());
                }
            }
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            if (monitorStreamFactory != null) {
                monitorStreamFactory.resetMonitoringContextIn(this.context.getProtocolData());
            }
        }
    }

    private class AsyncRequesterWriter
    implements Runnable {
        private volatile HTTPRequest request = null;
        private volatile boolean running = true;
        private Object lockRequest = new Object();
        private HTTPClient client = null;

        AsyncRequesterWriter(HTTPClient hTTPClient2) {
            this.client = hTTPClient2;
            DPWSFramework.getThreadPool().execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setRequest(HTTPRequest hTTPRequest) {
            Object object = this.lockRequest;
            synchronized (object) {
                this.request = hTTPRequest;
                this.lockRequest.notifyAll();
            }
        }

        public void notifyKeepAliveDisabled() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                try {
                    while (this.running) {
                        Object object = null;
                        boolean bl = false;
                        Object object2 = this.lockRequest;
                        synchronized (object2) {
                            block19: {
                                Object object3;
                                while (this.request == null) {
                                    this.lockRequest.wait(500L);
                                    if (this.running) continue;
                                    if (this.request != null) {
                                        throw new RuntimeException("HTTP request was not send. HTTP writer was not running.");
                                    }
                                    break block18;
                                }
                                MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                                try {
                                    Object object4;
                                    HTTPRequestHeader hTTPRequestHeader = this.request.getRequestHeader();
                                    HTTPClient.this.simpleHTTPClient.explicitConnect();
                                    HTTPClient.this.responder.notifyAboutRequest(this.request);
                                    object3 = HTTPClient.this.simpleHTTPClient.getTCPClient();
                                    TCPConnection tCPConnection = ((TCPClient)object3).getConnection();
                                    object = tCPConnection.getProtocolData();
                                    if (Log.isDebug()) {
                                        Log.debug("<O> " + hTTPRequestHeader + " to " + ((ProtocolData)object).getDestinationAddress() + ", " + tCPConnection, 1);
                                    }
                                    MonitoringContext monitoringContext = null;
                                    if (monitorStreamFactory != null) {
                                        monitoringContext = monitorStreamFactory.getNewMonitoringContextOut((ProtocolData)object);
                                    }
                                    String string = hTTPRequestHeader.getHeaderFieldValue("Transfer-Encoding");
                                    int n = hTTPRequestHeader.getHeaderFieldValue("Content-Length") != null ? Integer.parseInt(hTTPRequestHeader.getHeaderFieldValue("Content-Length").trim()) : -1;
                                    OutputStream outputStream = null;
                                    if (!"chunked".equals(string) && n == -1) {
                                        hTTPRequestHeader.removeHeaderFieldValue("Transfer-Encoding");
                                        string = null;
                                        outputStream = HTTPClient.this.simpleHTTPClient.exchange(hTTPRequestHeader, false);
                                        object4 = new ByteArrayOutputStream();
                                        this.request.serializeRequestBody((OutputStream)object4, (ProtocolData)object, monitoringContext);
                                        int n2 = ((ByteArrayOutputStream)object4).size();
                                        ((HTTPOutputStream)outputStream).setLength(n2);
                                        hTTPRequestHeader.addHeaderFieldValue("Content-Length", Integer.toString(n2));
                                        HTTPClient.this.simpleHTTPClient.sendHeader();
                                        byte[] byArray = ((ByteArrayOutputStream)object4).toByteArray();
                                        outputStream.write(byArray);
                                        outputStream.flush();
                                    } else {
                                        outputStream = HTTPClient.this.simpleHTTPClient.exchange(hTTPRequestHeader, true);
                                        this.request.serializeRequestBody(outputStream, (ProtocolData)object, monitoringContext);
                                    }
                                    if ("chunked".equals(string)) {
                                        ChunkedOutputStream.writeLastChunk((ChunkedOutputStream)outputStream);
                                        outputStream.flush();
                                    }
                                    if (monitorStreamFactory != null) {
                                        object4 = monitoringContext.getMessage();
                                        if (object4 != null) {
                                            monitorStreamFactory.send((ProtocolData)object, monitoringContext, (Message)object4);
                                        }
                                        monitorStreamFactory.resetMonitoringContextOut((ProtocolData)object);
                                    }
                                }
                                catch (IOException iOException) {
                                    bl = true;
                                    if (HTTPClient.this.closed) break block19;
                                    Log.error("Cannot send HTTP request. " + iOException.getMessage() + ". Resetting TCP connection (" + (object == null ? "no address known" : object.toString()) + ").");
                                    HTTPClient.this.simpleHTTPClient.resetConnection();
                                    object3 = new ExceptionNotification((ProtocolData)object, this.request, iOException, false);
                                    ((ExceptionNotification)object3).start();
                                }
                            }
                            this.request = null;
                        }
                        if (HTTPClient.this.keepalive) {
                            this.client.writerReady();
                            if (!bl) continue;
                            HTTPClient.this.readerReady();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.running = false;
            this.client.writerReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (!this.running) {
                return;
            }
            this.running = false;
            Object object = this.lockRequest;
            synchronized (object) {
                this.request = null;
                this.lockRequest.notifyAll();
            }
            HTTPClient.this.responder.justNotify();
        }
    }

    private class AsyncResponseReader
    implements Runnable {
        private volatile boolean running = true;
        private volatile HTTPRequest request = null;
        private Object waitForRequest = new Object();
        private Object lockResponse = new Object();
        private HTTPClient client = null;

        AsyncResponseReader(HTTPClient hTTPClient2) {
            this.client = hTTPClient2;
            DPWSFramework.getThreadPool().execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAboutRequest(HTTPRequest hTTPRequest) {
            Object object = this.waitForRequest;
            synchronized (object) {
                this.request = hTTPRequest;
                this.waitForRequest.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void justNotify() {
            Object object = this.waitForRequest;
            synchronized (object) {
                this.waitForRequest.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block27: {
                try {
                    while (this.running) {
                        ProtocolData protocolData = null;
                        Object object = this.waitForRequest;
                        synchronized (object) {
                            while (this.request == null) {
                                this.waitForRequest.wait(500L);
                                if (this.running) continue;
                                if (this.request != null) {
                                    throw new RuntimeException("HTTP response was not handled. HTTP reader not running.");
                                }
                                break block27;
                            }
                        }
                        object = DPWSFramework.getMonitorStreamFactory();
                        Object object2 = this.lockResponse;
                        synchronized (object2) {
                            block28: {
                                Object object3;
                                try {
                                    StreamConsumerThread streamConsumerThread;
                                    HTTPResponseHandler hTTPResponseHandler;
                                    Sync sync = new Sync();
                                    object3 = HTTPClient.this.simpleHTTPClient.getTCPClient();
                                    TCPConnection tCPConnection = ((TCPClient)object3).getConnection();
                                    protocolData = tCPConnection.getProtocolData().createSwappedProtocolData();
                                    MonitoringContext monitoringContext = null;
                                    if (object != null) {
                                        monitoringContext = ((MonitorStreamFactory)object).getNewMonitoringContextIn(protocolData);
                                    }
                                    HTTPResponseHeader hTTPResponseHeader = HTTPClient.this.simpleHTTPClient.getResponseHeader();
                                    InputStream inputStream = HTTPClient.this.simpleHTTPClient.getResponseBody(sync);
                                    if (Log.isDebug()) {
                                        Log.debug("<I> " + hTTPResponseHeader + " from " + protocolData.getDestinationAddress() + ", " + tCPConnection, 1);
                                    }
                                    String string = hTTPResponseHeader.getHeaderFieldValue("Transfer-Encoding");
                                    int n = hTTPResponseHeader.getHeaderFieldValue("Content-Length") != null ? Integer.parseInt(hTTPResponseHeader.getHeaderFieldValue("Content-Length").trim()) : -1;
                                    String string2 = hTTPResponseHeader.getHeaderFieldValue("Content-Type");
                                    InternetMediaType internetMediaType = new InternetMediaType(string2);
                                    String string3 = hTTPResponseHeader.getHeaderFieldValue("Connection");
                                    if ("close".equals(string3)) {
                                        HTTPClient.this.keepalive = false;
                                        HTTPClient.this.requester.notifyKeepAliveDisabled();
                                    }
                                    if ((hTTPResponseHandler = this.request.getResponseHandler(internetMediaType)) == null) {
                                        hTTPResponseHandler = (HTTPResponseHandler)HTTPClient.this.handlers.get(internetMediaType);
                                    }
                                    if ("chunked".equals(string) || n > 0) {
                                        streamConsumerThread = new StreamConsumerThread(hTTPResponseHandler, hTTPResponseHeader, inputStream, this.request, monitoringContext);
                                        sync.reset();
                                        Object object4 = sync;
                                        synchronized (object4) {
                                            while (!sync.isNotified()) {
                                                try {
                                                    DPWSFramework.getThreadPool().execute(streamConsumerThread);
                                                    sync.wait();
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    sync.notifyNow();
                                                }
                                            }
                                        }
                                        object4 = sync.getException();
                                        if (object4 != null) {
                                            if (object4 instanceof IOException) {
                                                throw (IOException)object4;
                                            }
                                            Log.error("A problem occured during stream read. " + ((Throwable)object4).getMessage());
                                        }
                                        break block28;
                                    }
                                    streamConsumerThread = new StreamConsumerThread(hTTPResponseHandler, hTTPResponseHeader, null, this.request, monitoringContext);
                                    DPWSFramework.getThreadPool().execute(streamConsumerThread);
                                }
                                catch (IOException iOException) {
                                    if (HTTPClient.this.closed) break block28;
                                    Log.error("Cannot handle HTTP response. " + iOException.getMessage());
                                    object3 = new ExceptionNotification(protocolData, this.request, iOException, true);
                                    ((ExceptionNotification)object3).start();
                                }
                            }
                            this.request = null;
                        }
                        if (HTTPClient.this.keepalive) {
                            this.client.readerReady();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.running = false;
            this.client.readerReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            if (!this.running) {
                return;
            }
            Object object = this.lockResponse;
            synchronized (object) {
                this.running = false;
            }
            object = this.waitForRequest;
            synchronized (object) {
                this.waitForRequest.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            if (!this.running) {
                return;
            }
            this.running = false;
            Object object = this.waitForRequest;
            synchronized (object) {
                this.waitForRequest.notifyAll();
            }
        }
    }
}

