/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.ws4d.java.communication.RequestHeader;
import org.ws4d.java.communication.protocol.http.HTTPParameter;
import org.ws4d.java.communication.protocol.http.HTTPUtil;
import org.ws4d.java.communication.protocol.http.header.HTTPHeader;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.InternetMediaType;

public class HTTPRequestHeader
extends HTTPHeader
implements RequestHeader {
    private String method = null;
    private String request = null;
    private String version = null;
    private HTTPParameter parameter = null;

    public HTTPRequestHeader(String string, String string2, String string3, HashMap hashMap, HTTPParameter hTTPParameter) {
        this.method = string;
        this.request = string2 == null || string2.length() == 0 ? "/" : string2;
        this.version = string3;
        this.parameter = hTTPParameter;
        if (hashMap != null) {
            this.headerfields = hashMap;
        }
    }

    public HTTPRequestHeader(String string, String string2, String string3, HashMap hashMap) {
        this(string, string2, string3, hashMap, null);
    }

    public HTTPRequestHeader(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequest() {
        return this.request;
    }

    public String getVersion() {
        return this.version;
    }

    public InternetMediaType getContentType() {
        String string = this.getHeaderFieldValue("Content-Type");
        if (string == null) {
            return InternetMediaType.getApplicationOctetStream();
        }
        return new InternetMediaType(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HTTP request [ ");
        stringBuffer.append("method=");
        stringBuffer.append(this.method);
        stringBuffer.append(", ");
        stringBuffer.append("version=");
        stringBuffer.append(this.version);
        stringBuffer.append(", ");
        stringBuffer.append("URI=");
        stringBuffer.append(this.request);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void toStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.method.getBytes());
        outputStream.write(32);
        outputStream.write(this.request.getBytes());
        outputStream.write(32);
        outputStream.write(this.version.getBytes());
        outputStream.write(13);
        outputStream.write(10);
        if (this.headerfields != null && this.headerfields.size() > 0) {
            Iterator iterator = this.headerfields.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.headerfields.get(string);
                if (string.equals("TE".toLowerCase())) {
                    outputStream.write("TE".getBytes());
                } else {
                    outputStream.write(HTTPUtil.camelCase(string));
                }
                outputStream.write(58);
                outputStream.write(32);
                outputStream.write(string2.getBytes());
                outputStream.write(32);
                outputStream.write(13);
                outputStream.write(10);
            }
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public String getParameter(String string) {
        if (this.parameter == null) {
            return null;
        }
        return this.parameter.getURIParameter(string);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

