/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.DPWSProtocolData;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.TCPConnection;
import org.ws4d.java.communication.connection.tcp.TCPConnectionHandler;
import org.ws4d.java.communication.connection.tcp.TCPListener;
import org.ws4d.java.communication.connection.tcp.TCPServer;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.ChunkedOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.communication.protocol.http.HTTPInputStream;
import org.ws4d.java.communication.protocol.http.HTTPOutputStream;
import org.ws4d.java.communication.protocol.http.HTTPRequestUtil;
import org.ws4d.java.communication.protocol.http.HTTPResponse;
import org.ws4d.java.communication.protocol.http.HTTPResponseUtil;
import org.ws4d.java.communication.protocol.http.HTTPUser;
import org.ws4d.java.communication.protocol.http.header.HTTPHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.communication.protocol.http.server.HTTPRequestHandler;
import org.ws4d.java.communication.protocol.http.server.responses.DefaultNotFoundResponse;
import org.ws4d.java.communication.protocol.http.server.responses.DefaultUnauthorizedResponse;
import org.ws4d.java.configuration.DPWSProperties;
import org.ws4d.java.message.Message;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class HTTPServer {
    private static final boolean BACKTRACK = false;
    private static final boolean EAT = true;
    private URI base = null;
    private IPAddress ipAddress = null;
    private int port = -1;
    private HTTPConnectionHandler handler = new HTTPConnectionHandler();
    private HashMap handlers = new HashMap();
    private boolean running = false;
    private List timeouts = new LinkedList();
    private boolean keepalive = true;
    private static int hand = 0;
    private static long REQUEST_TIMEOUT = 20000L;
    private static HashMap servers = new HashMap();
    private static boolean UNREGISTER_SHUTDOWN = false;
    private boolean isSecure = false;
    private String alias = null;
    private HashMap authentication = new HashMap();

    public void setAuthentication(URI uRI, HTTPGroup hTTPGroup) {
        this.authentication.put(uRI, hTTPGroup);
    }

    public HTTPGroup getAuthenticatedUser(URI uRI) {
        return (HTTPGroup)this.authentication.get(uRI);
    }

    public static synchronized HTTPServer get(IPAddress iPAddress, int n) throws IOException {
        return HTTPServer.get(iPAddress, n, false, null);
    }

    public static synchronized HTTPServer get(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        String string2;
        HTTPServer hTTPServer;
        if (n == 0) {
            hTTPServer = new HTTPServer(iPAddress, n, bl, string);
            string2 = iPAddress.getAddress() + "@" + hTTPServer.port;
        } else {
            string2 = iPAddress.getAddress() + "@" + n;
            hTTPServer = (HTTPServer)servers.get(string2);
            if (hTTPServer != null) {
                return hTTPServer;
            }
            hTTPServer = new HTTPServer(iPAddress, n, bl, string);
        }
        servers.put(string2, hTTPServer);
        return hTTPServer;
    }

    public static synchronized void unregisterAndStop(HTTPServer hTTPServer) throws IOException {
        String string = hTTPServer.ipAddress.getAddress() + "@" + hTTPServer.port;
        servers.remove(string);
        hTTPServer.stop();
    }

    private HTTPServer(IPAddress iPAddress, int n, boolean bl, String string) throws IOException {
        DPWSProperties dPWSProperties = DPWSProperties.getInstance();
        this.keepalive = dPWSProperties.getHTTPServerKeepAlive();
        this.ipAddress = iPAddress;
        this.port = n;
        this.isSecure = bl;
        this.alias = string;
        String string2 = bl ? "https" : "http";
        this.start();
        this.base = new URI(string2 + "://" + iPAddress.getAddressWithoutNicId() + ":" + this.port);
    }

    public void register(String string, HTTPRequestHandler hTTPRequestHandler, HTTPGroup hTTPGroup) {
        URI uRI = new URI(string, this.base);
        this.handlers.put(uRI, hTTPRequestHandler);
        if (hTTPGroup != null) {
            this.setAuthentication(uRI, hTTPGroup);
        }
    }

    public void register(String string, InternetMediaType internetMediaType, HTTPRequestHandler hTTPRequestHandler, HTTPGroup hTTPGroup) {
        URI uRI = new URI(string, this.base);
        MappingEntry mappingEntry = new MappingEntry(uRI, internetMediaType);
        this.handlers.put(mappingEntry, hTTPRequestHandler);
        if (hTTPGroup != null) {
            this.setAuthentication(uRI, hTTPGroup);
        }
    }

    public HTTPRequestHandler unregister(String string) {
        URI uRI = new URI(string, this.base);
        HTTPRequestHandler hTTPRequestHandler = (HTTPRequestHandler)this.handlers.remove(uRI);
        if (UNREGISTER_SHUTDOWN && this.handlers.isEmpty()) {
            try {
                TCPServer.close(this.ipAddress, this.port);
            }
            catch (IOException iOException) {
                Log.error("Cannot shutdown TCP server after all registrations removed. " + iOException.getMessage());
            }
        }
        return hTTPRequestHandler;
    }

    public HTTPRequestHandler unregister(String string, InternetMediaType internetMediaType) {
        URI uRI = new URI(string, this.base);
        MappingEntry mappingEntry = new MappingEntry(uRI, internetMediaType);
        HTTPRequestHandler hTTPRequestHandler = (HTTPRequestHandler)this.handlers.remove(mappingEntry);
        if (UNREGISTER_SHUTDOWN && this.handlers.isEmpty()) {
            try {
                TCPServer.close(this.ipAddress, this.port);
            }
            catch (IOException iOException) {
                Log.error("Cannot shutdown TCP server after all registrations removed. " + iOException.getMessage());
            }
        }
        return hTTPRequestHandler;
    }

    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        TCPListener tCPListener = !this.isSecure ? TCPServer.open(this.ipAddress, this.port, this.handler) : TCPServer.open(this.ipAddress, this.port, this.handler, true, this.alias);
        if (this.port == 0) {
            this.port = tCPListener.getPort();
        }
        this.running = true;
    }

    public synchronized void stop() throws IOException {
        if (!this.running) {
            return;
        }
        TCPServer.close(this.ipAddress, this.port);
        Iterator iterator = this.timeouts.iterator();
        while (iterator.hasNext()) {
            HandlerTimeOut handlerTimeOut = (HandlerTimeOut)iterator.next();
            WatchDog.getInstance().unregister(handlerTimeOut);
            iterator.remove();
        }
        this.running = false;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPort() {
        return this.port;
    }

    private HTTPRequestHandler getHTTPHandler(String string, InternetMediaType internetMediaType) {
        URI uRI = new URI(string, this.base);
        MappingEntry mappingEntry = new MappingEntry(uRI, internetMediaType);
        HTTPRequestHandler hTTPRequestHandler = null;
        hTTPRequestHandler = (HTTPRequestHandler)this.handlers.get(mappingEntry);
        if (hTTPRequestHandler == null) {
            hTTPRequestHandler = (HTTPRequestHandler)this.handlers.get(uRI);
        }
        return hTTPRequestHandler;
    }

    private class MappingEntry {
        private URI uri = null;
        private InternetMediaType type = null;

        MappingEntry(URI uRI, InternetMediaType internetMediaType) {
            this.uri = uRI;
            this.type = internetMediaType;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            n = 31 * n + (this.uri == null ? 0 : this.uri.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MappingEntry mappingEntry = (MappingEntry)object;
            if (!this.getOuterType().equals(mappingEntry.getOuterType())) {
                return false;
            }
            if (this.type == null ? mappingEntry.type != null : !this.type.equals(mappingEntry.type)) {
                return false;
            }
            return !(this.uri == null ? mappingEntry.uri != null : !this.uri.equals(mappingEntry.uri));
        }

        private HTTPServer getOuterType() {
            return HTTPServer.this;
        }
    }

    private class HandlerTimeOut
    extends TimedEntry {
        private TCPConnection connection = null;
        private boolean keepalive = true;

        private HandlerTimeOut(TCPConnection tCPConnection, boolean bl) {
            this.connection = tCPConnection;
            this.keepalive = bl;
        }

        protected void timedOut() {
            this.keepalive = false;
            if (Log.isDebug()) {
                Log.debug("<I> Incoming TCP connection (" + this.connection.getIdentifier() + ") timeout after " + REQUEST_TIMEOUT + "ms.", 1);
            }
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                Log.error("Cannot close server connection. " + iOException.getMessage());
            }
        }

        public boolean keepAlive() {
            return this.keepalive;
        }

        public void setKeepAlive(boolean bl) {
            this.keepalive = bl;
        }
    }

    private class HTTPConnectionHandler
    implements TCPConnectionHandler {
        private HTTPConnectionHandler() {
        }

        public void handle(TCPConnection tCPConnection) throws IOException {
            hand++;
            boolean bl = true;
            HandlerTimeOut handlerTimeOut = new HandlerTimeOut(tCPConnection, HTTPServer.this.keepalive);
            DPWSProtocolData dPWSProtocolData = tCPConnection.getProtocolData();
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            while (handlerTimeOut.keepAlive() || bl) {
                Message message;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                String string;
                String string2;
                Object object8;
                bl = false;
                MonitoringContext monitoringContext = null;
                if (monitorStreamFactory != null) {
                    monitoringContext = monitorStreamFactory.getNewMonitoringContextIn(dPWSProtocolData);
                }
                InputStream inputStream = tCPConnection.getInputStream();
                OutputStream outputStream = tCPConnection.getOutputStream();
                HTTPRequestHeader hTTPRequestHeader = null;
                try {
                    WatchDog.getInstance().register(handlerTimeOut, REQUEST_TIMEOUT);
                    HTTPServer.this.timeouts.add(handlerTimeOut);
                    hTTPRequestHeader = HTTPRequestUtil.handleRequest(inputStream);
                    WatchDog.getInstance().unregister(handlerTimeOut);
                }
                catch (ProtocolException protocolException) {
                    WatchDog.getInstance().unregister(handlerTimeOut);
                    object8 = HTTPResponseUtil.getResponseHeader(400);
                    ((HTTPHeader)object8).addHeaderFieldValue("Connection", "close");
                    ((HTTPHeader)object8).addHeaderFieldValue("Content-Length", "0");
                    string2 = "Invalid HTTP request: " + protocolException.getMessage();
                    ((HTTPResponseHeader)object8).toStream(outputStream);
                    outputStream.write(string2.getBytes());
                    Log.warn("Closing HTTP connection. " + string2 + ".");
                    break;
                }
                if (hTTPRequestHeader == null) break;
                if (Log.isDebug()) {
                    Log.debug("<I> " + hTTPRequestHeader + " from " + ((ProtocolData)dPWSProtocolData).getSourceAddress() + ", " + tCPConnection, 1);
                }
                if ((string = hTTPRequestHeader.getRequest()).startsWith("http")) {
                    object8 = new URI(string);
                    string = ((URI)object8).getPath();
                }
                object8 = hTTPRequestHeader.getMethod();
                string2 = hTTPRequestHeader.getHeaderFieldValue("Transfer-Encoding");
                String string3 = hTTPRequestHeader.getHeaderFieldValue("Content-Length");
                int n = -1;
                if (string3 != null) {
                    n = Integer.parseInt(string3.trim());
                }
                tCPConnection.getProtocolData().setTransportAddress(new URI(HTTPServer.this.base.toString(), string));
                if (!"chunked".equals(string2) && n < 0 && "POST".equals(object8)) {
                    object7 = HTTPResponseUtil.getResponseHeader(400);
                    ((HTTPHeader)object7).addHeaderFieldValue("Connection", "close");
                    object6 = "Neither content length nor chunked encoding found. Cannot determinate content length.";
                    ((HTTPResponseHeader)object7).toStream(outputStream);
                    outputStream.write(((String)object6).getBytes());
                    break;
                }
                object7 = hTTPRequestHeader.getHeaderFieldValue("Content-Type");
                object6 = new InternetMediaType((String)object7);
                String string4 = hTTPRequestHeader.getHeaderFieldValue("Connection");
                if ("close".equals(string4)) {
                    handlerTimeOut.setKeepAlive(false);
                }
                boolean bl2 = false;
                String string5 = hTTPRequestHeader.getHeaderFieldValue("TE");
                if (string5 != null) {
                    object5 = StringUtil.split(string5, ',');
                    for (int i = 0; i < ((String[])object5).length; ++i) {
                        if (object5[i].indexOf("trailers") < 0) continue;
                        bl2 = true;
                    }
                }
                inputStream = new HTTPInputStream(inputStream, string2, n);
                object5 = new URI(HTTPServer.this.base, hTTPRequestHeader.getRequest());
                HTTPRequestHandler hTTPRequestHandler = HTTPServer.this.getHTTPHandler(string, (InternetMediaType)object6);
                HTTPResponse hTTPResponse = null;
                if (hTTPRequestHandler != null) {
                    if (HTTPServer.this.authentication.get(object5) != null) {
                        object4 = null;
                        object3 = null;
                        object3 = (HTTPGroup)HTTPServer.this.authentication.get(object5);
                        object2 = hTTPRequestHeader.getHeaderFieldValue("Authorization");
                        if (object2 != null) {
                            object4 = HTTPUser.createUserFromBase64String(((String)object2).substring("Basic".length()));
                        }
                        if (object4 == null || !((HTTPGroup)object3).inList((HTTPUser)object4)) {
                            hTTPResponse = new DefaultUnauthorizedResponse(hTTPRequestHeader);
                        }
                    }
                    if (hTTPResponse == null) {
                        try {
                            hTTPResponse = hTTPRequestHandler.handle((URI)object5, hTTPRequestHeader, inputStream, tCPConnection.getProtocolData(), monitoringContext);
                        }
                        catch (IOException iOException) {
                            object3 = "The registered HTTP handler (" + hTTPRequestHandler.getClass().getName() + ") got an exception. " + iOException.getMessage();
                            Log.error((String)object3);
                            object2 = HTTPResponseUtil.getResponseHeader(500);
                            ((HTTPHeader)object2).addHeaderFieldValue("Content-Length", "0");
                            ((HTTPHeader)object2).addHeaderFieldValue("JMEDS-Debug", hTTPRequestHeader.getRequest());
                            ((HTTPResponseHeader)object2).toStream(outputStream);
                            outputStream.write(((String)object3).getBytes());
                            Log.warn("Closing HTTP connection. " + (String)object3 + ".");
                            break;
                        }
                    }
                }
                if (hTTPResponse == null || hTTPResponse.getResponseHeader() == null) {
                    hTTPResponse = new DefaultNotFoundResponse(hTTPRequestHeader);
                }
                if ((object3 = ((HTTPHeader)(object4 = hTTPResponse.getResponseHeader())).getHeaderFieldValue("Date")) == null) {
                    object2 = new Date();
                    ((HTTPHeader)object4).addHeaderFieldValue("Date", StringUtil.getHTTPDate(((Date)object2).getTime()));
                }
                object2 = hTTPRequestHeader.getHeaderFieldValue("If-Modified-Since");
                long l = -1L;
                if (object2 != null) {
                    l = StringUtil.getHTTPDateAsLong((String)object2);
                }
                String string6 = ((HTTPHeader)object4).getHeaderFieldValue("Last-Modified");
                long l2 = -1L;
                if (string6 != null) {
                    l2 = StringUtil.getHTTPDateAsLong(string6);
                }
                if (l != -1L && l2 != -1L && l2 <= l) {
                    object4 = HTTPResponseUtil.getResponseHeader(304);
                    object = new Date();
                    ((HTTPHeader)object4).addHeaderFieldValue("Date", StringUtil.getHTTPDate(((Date)object).getTime()));
                    ((HTTPResponseHeader)object4).toStream(outputStream);
                    if (!Log.isDebug()) break;
                    Log.debug("Resource at " + object5 + " not modified since " + (String)object2 + ".");
                    break;
                }
                string4 = ((HTTPHeader)object4).getHeaderFieldValue("Connection");
                if ("close".equals(string4)) {
                    handlerTimeOut.setKeepAlive(false);
                }
                if (!HTTPServer.this.keepalive) {
                    ((HTTPHeader)object4).addHeaderFieldValue("Connection", "close");
                    handlerTimeOut.setKeepAlive(false);
                }
                object = ((HTTPHeader)object4).getHeaderFieldValue("Transfer-Encoding");
                int n2 = ((HTTPHeader)object4).getHeaderFieldValue("Content-Length") != null ? Integer.parseInt(((HTTPHeader)object4).getHeaderFieldValue("Content-Length").trim()) : -1;
                ProtocolData protocolData = null;
                if (monitorStreamFactory != null) {
                    protocolData = ((ProtocolData)dPWSProtocolData).createSwappedProtocolData();
                    monitoringContext = monitorStreamFactory.getNewMonitoringContextOut(protocolData);
                }
                ByteArrayOutputStream byteArrayOutputStream = null;
                boolean bl3 = false;
                if (!"chunked".equals(object) && n2 == -1) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    hTTPResponse.serializeResponseBody((URI)object5, hTTPRequestHeader, byteArrayOutputStream, tCPConnection.getProtocolData() == null ? null : tCPConnection.getProtocolData().createSwappedProtocolData(), monitoringContext);
                    n2 = byteArrayOutputStream.size();
                    ((HTTPHeader)object4).addHeaderFieldValue("Content-Length", Integer.toString(n2));
                    bl3 = true;
                }
                if (Log.isDebug()) {
                    Log.debug("<O> " + object4 + " to " + ((ProtocolData)dPWSProtocolData).getSourceAddress() + ", " + tCPConnection, 1);
                }
                ((HTTPResponseHeader)object4).toStream(outputStream);
                outputStream = "HEAD".equals(hTTPRequestHeader.getMethod()) ? new HTTPOutputStream(outputStream, 0L) : ("chunked".equals(object) ? new ChunkedOutputStream(outputStream, bl2) : new HTTPOutputStream(outputStream, n2));
                if (!bl3) {
                    hTTPResponse.serializeResponseBody((URI)object5, hTTPRequestHeader, outputStream, tCPConnection.getProtocolData() == null ? null : tCPConnection.getProtocolData().createSwappedProtocolData(), monitoringContext);
                } else {
                    outputStream.write(byteArrayOutputStream.toByteArray());
                }
                if ("chunked".equals(object)) {
                    ChunkedOutputStream.writeLastChunk((ChunkedOutputStream)outputStream);
                }
                outputStream.flush();
                hTTPResponse.waitFor();
                if (monitorStreamFactory != null && (message = monitoringContext.getMessage()) != null) {
                    monitorStreamFactory.send(protocolData, monitoringContext, message);
                }
                this.consumeStream(inputStream);
            }
            hand--;
        }

        private void consumeStream(InputStream inputStream) throws IOException {
            int n = -1;
            while (inputStream.read() != -1) {
                ++n;
            }
            if (n > -1) {
                Log.warn("The registered handler has not consumed the HTTP body from the request. Eating " + n + " bytes.");
            }
        }
    }
}

