/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.protocol.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.AttachmentStoreHandler;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.DPWSProtocolInfo;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoredMessageReceiver;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.http.HTTPRequest;
import org.ws4d.java.communication.protocol.http.HTTPResponseHandler;
import org.ws4d.java.communication.protocol.http.header.HTTPRequestHeader;
import org.ws4d.java.communication.protocol.http.header.HTTPResponseHeader;
import org.ws4d.java.communication.protocol.mime.DefaultMIMEHandler;
import org.ws4d.java.communication.protocol.mime.MIMEEntityInput;
import org.ws4d.java.communication.protocol.mime.MIMEHandler;
import org.ws4d.java.communication.protocol.soap.generator.MessageReceiver;
import org.ws4d.java.communication.protocol.soap.generator.SOAPMessageGeneratorFactory;
import org.ws4d.java.configuration.HTTPProperties;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.Queue;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.ParameterUtil;

public class SOAPRequest
implements HTTPRequest {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final Message request;
    private final MessageReceiver receiver;
    private final HTTPRequestHeader header;
    private String mimeBoundary = null;
    private List mimeEntities = null;

    public SOAPRequest(String string, Message message, MessageReceiver messageReceiver) {
        InvokeMessage invokeMessage;
        ParameterValue parameterValue;
        Object object;
        Object object2;
        this.request = message;
        this.receiver = messageReceiver;
        this.header = new HTTPRequestHeader("POST", string, "HTTP/1.1");
        int n = -1;
        if (message != null && (object2 = message.getProtocolInfo()) instanceof DPWSProtocolInfo) {
            object = (DPWSProtocolInfo)object2;
            n = ((DPWSProtocolInfo)object).getHttpRequestChunkedMode();
        }
        object2 = message.getTargetAddress().toString();
        n = HTTPProperties.getInstance().getChunkMode((String)object2);
        if (n > -1) {
            System.out.println("chunk mode changed to " + n + "!");
        }
        if (n == 1) {
            this.header.addHeaderFieldValue("Transfer-Encoding", "chunked");
        } else if (n == 2 && message.getType() == 400) {
            this.header.addHeaderFieldValue("Transfer-Encoding", "chunked");
        }
        object = InternetMediaType.getSOAPXML().getMediaType();
        if (message.getType() == 400 && (parameterValue = (invokeMessage = (InvokeMessage)message).getContent()) != null && ParameterUtil.hasAttachment(parameterValue)) {
            this.mimeBoundary = DefaultMIMEHandler.createMimeBoundary();
            InternetMediaType internetMediaType = InternetMediaType.cloneAndSetParameter(InternetMediaType.getMultipartRelated(), "boundary", this.mimeBoundary);
            object = internetMediaType.toString();
            this.mimeEntities = ParameterUtil.getAttachments(parameterValue);
        }
        this.header.addHeaderFieldValue("Content-Type", (String)object);
        this.header.addHeaderFieldValue("TE", "trailers");
    }

    public HTTPRequestHeader getRequestHeader() {
        return this.header;
    }

    public HTTPResponseHandler getResponseHandler(InternetMediaType internetMediaType) throws IOException {
        if (InternetMediaType.getSOAPXML().equals(internetMediaType)) {
            return new HTTPResponseHandler(){

                public void handle(HTTPResponseHeader hTTPResponseHeader, InputStream inputStream, HTTPRequest hTTPRequest, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
                    int n = hTTPResponseHeader.getStatus();
                    if (n == 202 || n == 204) {
                        return;
                    }
                    MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                    MessageReceiver messageReceiver = monitorStreamFactory != null ? new MonitoredMessageReceiver(SOAPRequest.this.receiver, monitoringContext) : SOAPRequest.this.receiver;
                    boolean bl = false;
                    String string = hTTPResponseHeader.getHeaderFieldValue("Content-Length");
                    if (string != null) {
                        int n2 = Integer.parseInt(string.trim());
                        bl = n2 > 0;
                    } else {
                        boolean bl2 = bl = inputStream.available() > 0;
                    }
                    if (bl) {
                        SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(inputStream, messageReceiver, protocolData);
                    } else {
                        messageReceiver.receive(FaultMessage.createEndpointUnavailableFault(SOAPRequest.this.request), protocolData);
                    }
                }
            };
        }
        if (InternetMediaType.getMultipartRelated().equals(internetMediaType)) {
            DefaultMIMEHandler defaultMIMEHandler = new DefaultMIMEHandler();
            defaultMIMEHandler.register(InternetMediaType.getApplicationXOPXML(), new MIMEHandler(){

                public void handleResponse(MIMEEntityInput mIMEEntityInput, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
                    MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                    MessageReceiver messageReceiver = monitorStreamFactory != null ? new MonitoredMessageReceiver(SOAPRequest.this.receiver, monitoringContext) : SOAPRequest.this.receiver;
                    SOAPMessageGeneratorFactory.getInstance().getSOAP2MessageGeneratorForCurrentThread().deliverMessage(mIMEEntityInput.getBodyInputStream(), messageReceiver, protocolData);
                }

                public void handleRequest(MIMEEntityInput mIMEEntityInput, Queue queue, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
                }
            });
            defaultMIMEHandler.register(2, -1, AttachmentStoreHandler.getInstance());
            return defaultMIMEHandler;
        }
        if (InternetMediaType.getTextHTML().equals(internetMediaType)) {
            return new HTTPResponseHandler(){

                public void handle(HTTPResponseHeader hTTPResponseHeader, InputStream inputStream, HTTPRequest hTTPRequest, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
                    MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
                    MessageReceiver messageReceiver = monitorStreamFactory != null ? new MonitoredMessageReceiver(SOAPRequest.this.receiver, monitoringContext) : SOAPRequest.this.receiver;
                    if (hTTPResponseHeader.getStatus() == 401) {
                        messageReceiver.receive(FaultMessage.createAuthenticationFault(SOAPRequest.this.request), protocolData);
                    } else {
                        messageReceiver.receive(FaultMessage.createEndpointUnavailableFault(SOAPRequest.this.request), protocolData);
                    }
                }
            };
        }
        return null;
    }

    public void requestSendFailed(Exception exception, ProtocolData protocolData) {
        this.receiver.sendFailed(exception, protocolData);
    }

    public void responseReceiveFailed(Exception exception, ProtocolData protocolData) {
        this.receiver.receiveFailed(exception, protocolData);
    }

    public void serializeRequestBody(OutputStream outputStream, ProtocolData protocolData, MonitoringContext monitoringContext) throws IOException {
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
        communicationManager.serializeMessageWithAttachments(this.request, this.mimeBoundary, this.mimeEntities, outputStream, protocolData);
        MESSAGE_INFORMER.forwardMessage(this.request, protocolData);
        if (monitoringContext != null) {
            monitoringContext.setMessage(this.request);
        }
    }
}

