/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.communication.HTTPBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.configuration.BindingProperties;
import org.ws4d.java.configuration.Properties;
import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class HTTPBindingProperties
implements PropertiesHandler {
    public static final String PROP_ADDRESS = "Address";
    public static final String PROP_PORT = "Port";
    public static final String PROP_SUFFIX = "Suffix";
    public static final String PROP_ADDRESS_GROUP = "AddressGroup";
    public static final String SUBSECTION_HTTP_BINDINGS = "HTTPBindings";
    public static final String SUBSUBSECTION_HTTP_BINDING = "HTTPBinding";
    public static final String PROP_ADDRESS_GROUP_INET6 = "inet6";
    public static final String PROP_ADDRESS_GROUP_INET4 = "inet4";
    public static final String PROP_ADDRESS_GROUP_ALL = "all";
    public static final String PROP_ADDRESS_GROUP_LO = "lo";
    public static final PropertyHeader HEADER_SUBSECTION_HTTP_BINDINGS = new PropertyHeader("HTTPBindings", Properties.HEADER_SECTION_BINDINGS);
    public static final PropertyHeader HEADER_SUBSUBSECTION_HTTP_BINDING = new PropertyHeader("HTTPBinding", HEADER_SUBSECTION_HTTP_BINDINGS);
    private static HTTPBindingProperties handler = null;
    private ArrayList defaultAddresses = new ArrayList();
    private int defaultPort = 0;
    private String defaultSuffix = null;
    private BuildUpProperties buildUpBinding = null;

    HTTPBindingProperties() {
        if (handler != null) {
            throw new RuntimeException("HTTPBindingProperties: class already instantiated!");
        }
        handler = this;
    }

    static synchronized HTTPBindingProperties getInstance() {
        if (handler == null) {
            handler = new HTTPBindingProperties();
        }
        return handler;
    }

    private ArrayList getGroupByName(String string) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = null;
        if (string.indexOf(64) == -1) {
            iterator = StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_ALL, string) ? IPNetworkDetection.getInstance().getAddresses() : (StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_LO, string) ? IPNetworkDetection.getInstance().getAddresses(null, string) : (StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_INET4, string) || StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_INET6, string) ? IPNetworkDetection.getInstance().getAddresses(string, null) : IPNetworkDetection.getInstance().getAddresses(null, string)));
        } else {
            object = string.substring(0, string.indexOf(64));
            String string2 = string.substring(string.indexOf(64) + 1);
            if (StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_INET4, (String)object) || StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_ALL, (String)object) || StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_LO, (String)object) || StringUtil.equalsIgnoreCase(PROP_ADDRESS_GROUP_INET6, (String)object)) {
                iterator = IPNetworkDetection.getInstance().getAddresses((String)object, string2);
            } else if (Log.isError()) {
                Log.error("Cann not parse address-group for protocol: " + (String)object + ". Set default: all addresses.");
            }
        }
        if (iterator != null && iterator.hasNext()) {
            while (iterator.hasNext()) {
                object = (IPAddress)iterator.next();
                arrayList.add(object);
            }
        } else {
            Log.warn("Cann not parse address-group. Set default: all addresses.");
        }
        return arrayList;
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (HEADER_SUBSECTION_HTTP_BINDINGS.equals(propertyHeader)) {
            if (PROP_ADDRESS.equals(property.key)) {
                this.defaultAddresses.add(property.value);
            } else if (PROP_ADDRESS_GROUP.equals(property.key)) {
                this.defaultAddresses.addAll(this.getGroupByName(property.value));
            } else if (PROP_PORT.equals(property.key)) {
                this.defaultPort = Integer.parseInt(property.value.trim());
            } else if (PROP_SUFFIX.equals(property.key)) {
                this.defaultSuffix = property.value;
            }
        } else if (HEADER_SUBSUBSECTION_HTTP_BINDING.equals(propertyHeader)) {
            if (this.buildUpBinding == null) {
                this.buildUpBinding = new BuildUpProperties();
            }
            if ("BindingId".equals(property.key)) {
                this.buildUpBinding.bindingId = Integer.valueOf(property.value);
            } else if (PROP_ADDRESS.equals(property.key)) {
                this.buildUpBinding.buildUpAddresses.add(property.value);
            } else if (PROP_ADDRESS_GROUP.equals(property.key)) {
                this.buildUpBinding.buildUpAddresses.addAll(this.getGroupByName(property.value));
            } else if (PROP_PORT.equals(property.key)) {
                this.buildUpBinding.buildUpPort = Integer.parseInt(property.value.trim());
            } else if (PROP_SUFFIX.equals(property.key)) {
                this.buildUpBinding.buildUpSuffix = property.value;
            }
        }
    }

    public void finishedSection(int n) {
        if (n == 3 && this.buildUpBinding != null) {
            if (!this.buildUpBinding.bindingId.equals(BindingProperties.DEFAULT_BINDING_ID)) {
                ArrayList arrayList = this.buildUpBinding.createBindings();
                BindingProperties.getInstance().addCommunicationBinding(this.buildUpBinding.bindingId, arrayList);
            } else {
                Log.error("HTTPBindingProperties: binding id not set: " + this.buildUpBinding);
            }
        }
        this.buildUpBinding = null;
    }

    private class BuildUpProperties {
        Integer bindingId = BindingProperties.DEFAULT_BINDING_ID;
        ArrayList buildUpAddresses = new ArrayList();
        int buildUpPort;
        String buildUpSuffix;

        public BuildUpProperties() {
            this.buildUpPort = HTTPBindingProperties.this.defaultPort;
            this.buildUpSuffix = HTTPBindingProperties.this.defaultSuffix;
        }

        public ArrayList createBindings() {
            ArrayList arrayList = new ArrayList();
            if (this.buildUpAddresses.size() == 0) {
                this.buildUpAddresses = HTTPBindingProperties.this.defaultAddresses;
            }
            for (int i = 0; i < this.buildUpAddresses.size(); ++i) {
                IPAddress iPAddress = IPNetworkDetection.getInstance().getIPAddress((String)this.buildUpAddresses.get(i));
                if (iPAddress == null) continue;
                arrayList.add(new HTTPBinding(iPAddress, this.buildUpPort, this.buildUpSuffix));
            }
            return arrayList;
        }

        public String toString() {
            int n;
            if (this.buildUpAddresses.size() == 0) {
                return "BuildUpProperties not specified";
            }
            String string = "";
            for (n = 0; n < this.buildUpAddresses.size() - 1; ++n) {
                string = string + (String)this.buildUpAddresses.get(n) + " | ";
            }
            return "BindingId = " + this.bindingId + " | Addresses = [" + string + (String)this.buildUpAddresses.get(n) + "] " + "| Port = " + this.buildUpPort + " | Suffix = " + this.buildUpSuffix;
        }
    }
}

