/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.configuration;

import org.ws4d.java.configuration.PropertiesHandler;
import org.ws4d.java.configuration.Property;
import org.ws4d.java.configuration.PropertyHeader;

public class SecurityProperties
implements PropertiesHandler {
    private static SecurityProperties handler = null;
    public static final String[] SECTION_SECURITY = new String[]{"Security"};
    public static final PropertyHeader HEADER_SECTION_SECURITY = new PropertyHeader(SECTION_SECURITY);
    public static final String KEYSTORE_FILE = "KeyStoreFile";
    public static final String KEYSTORE_PASWD = "KeyStorePswd";
    public static final String TRUSTSTORE_FILE = "TrustStoreFile";
    public static final String TRUSTSTORE_PASWD = "TrustStorePswd";
    public static final String ALLOW_SECURE_ONLY = "AllowSecureOnly";
    private String keyStoreFileName = null;
    private String keyStorePaswd = null;
    private String trustStorePath = null;
    private String trustStorePasswd = null;
    private boolean allowSecureOnly = true;

    SecurityProperties() {
        if (handler != null) {
            throw new RuntimeException("SecurityPropertiesProperties: class already instantiated!");
        }
        handler = this;
    }

    public static SecurityProperties getInstance() {
        if (handler == null) {
            handler = new SecurityProperties();
        }
        return handler;
    }

    public void finishedSection(int n) {
    }

    public void setProperties(PropertyHeader propertyHeader, Property property) {
        if (KEYSTORE_FILE.equals(property.key)) {
            this.keyStoreFileName = property.value;
        } else if (KEYSTORE_PASWD.equals(property.key)) {
            this.keyStorePaswd = property.value;
        } else if (TRUSTSTORE_FILE.equals(property.key)) {
            this.trustStorePath = property.value;
        } else if (TRUSTSTORE_PASWD.equals(property.key)) {
            this.trustStorePasswd = property.value;
        } else if (ALLOW_SECURE_ONLY.equals(property.key)) {
            this.allowSecureOnly = property.value.equals("true");
        }
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFileName;
    }

    public String getKeyStorePswd() {
        return this.keyStorePaswd;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePasswd() {
        return this.trustStorePasswd;
    }

    public void setKeyStoreFileName(String string) {
        this.keyStoreFileName = string;
    }

    public void setKeyStorePaswd(String string) {
        this.keyStorePaswd = string;
    }

    public void setTrustStorePath(String string) {
        this.trustStorePath = string;
    }

    public void setTrustStorePasswd(String string) {
        this.trustStorePasswd = string;
    }
}

