/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.dispatch;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.reference.ServiceListener;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.util.Log;

class ServiceListenerQueue {
    static final byte SERVICE_CREATED_EVENT = 1;
    static final byte SERVICE_CHANGED_EVENT = 2;
    static final byte SERVICE_DISPOSED_EVENT = 3;
    private final ServiceListener listener;
    private List queue = new LinkedList();
    private ServiceEvent currentEvent = null;

    ServiceListenerQueue(ServiceListener serviceListener) {
        this.listener = serviceListener;
    }

    synchronized void announce(ServiceEvent serviceEvent) {
        if (this.currentEvent == null) {
            this.currentEvent = serviceEvent;
            DPWSFramework.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        ServiceListenerQueue.this.deliverCurrentEvent();
                        ServiceListenerQueue serviceListenerQueue = ServiceListenerQueue.this;
                        synchronized (serviceListenerQueue) {
                            boolean bl = true;
                            while (ServiceListenerQueue.this.queue.size() > 0) {
                                ServiceEvent serviceEvent = (ServiceEvent)ServiceListenerQueue.this.queue.remove(0);
                                if (serviceEvent.eventType == ((ServiceListenerQueue)ServiceListenerQueue.this).currentEvent.eventType) continue;
                                ServiceListenerQueue.this.currentEvent = serviceEvent;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                ServiceListenerQueue.this.currentEvent = null;
                                return;
                            }
                        }
                    }
                }
            });
        } else {
            this.queue.add(serviceEvent);
        }
    }

    private void deliverCurrentEvent() {
        try {
            switch (this.currentEvent.eventType) {
                case 1: {
                    this.listener.serviceCreated(this.currentEvent.servRef, this.currentEvent.service);
                    break;
                }
                case 2: {
                    this.listener.serviceChanged(this.currentEvent.servRef, this.currentEvent.service);
                    break;
                }
                case 3: {
                    this.listener.serviceDisposed(this.currentEvent.servRef);
                }
            }
        }
        catch (Throwable throwable) {
            Log.error("Exception during listener notification: " + throwable.getMessage());
            Log.printStackTrace(throwable);
        }
    }

    static class ServiceEvent {
        byte eventType;
        ServiceReference servRef;
        Service service;

        ServiceEvent(byte by, ServiceReference serviceReference, Service service) {
            this.eventType = by;
            this.servRef = serviceReference;
            this.service = service;
        }
    }
}

