/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.html;

import org.ws4d.java.html.HTMLDocument;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;

public class SimpleHTML
implements HTMLDocument {
    private static final String HTML = "html";
    private static final String HEAD = "head";
    private static final String TITLE = "title";
    private static final String BODY = "body";
    private static final String HEADING1 = "h1";
    private static final String PARAGRAPH = "p";
    private static final String BEGINTAG = "<";
    private static final String ENDTAG = ">";
    private static final String SEP = "/";
    private String title = null;
    private List content = null;

    public SimpleHTML(String string) {
        this.title = string;
        this.content = new LinkedList();
    }

    public void addHeading(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.openTag(stringBuffer, HEADING1);
        stringBuffer.append(string);
        this.closeTag(stringBuffer, HEADING1);
        this.content.add(stringBuffer.toString());
    }

    public void addParagraph(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.openTag(stringBuffer, PARAGRAPH);
        stringBuffer.append(string);
        this.closeTag(stringBuffer, PARAGRAPH);
        this.content.add(stringBuffer.toString());
    }

    public void addHorizontalRule() {
        this.content.add("<hr />");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.openTag(stringBuffer, HTML);
        this.openTag(stringBuffer, HEAD);
        this.openTag(stringBuffer, TITLE);
        stringBuffer.append(this.title);
        this.closeTag(stringBuffer, TITLE);
        this.closeTag(stringBuffer, HEAD);
        this.openTag(stringBuffer, BODY);
        if (this.content != null && this.content.size() > 0) {
            Iterator iterator = this.content.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
            }
        }
        this.closeTag(stringBuffer, BODY);
        this.closeTag(stringBuffer, HTML);
        return stringBuffer.toString();
    }

    public byte[] getData() {
        return this.toString().getBytes();
    }

    private void openTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append(BEGINTAG);
        stringBuffer.append(string);
        stringBuffer.append(ENDTAG);
    }

    private void closeTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append(BEGINTAG);
        stringBuffer.append(SEP);
        stringBuffer.append(string);
        stringBuffer.append(ENDTAG);
    }
}

