/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.io.xml.canonicalization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import org.ws4d.java.io.xml.ElementHandler;
import org.ws4d.java.io.xml.ElementHandlerRegistry;
import org.ws4d.java.io.xml.XmlSerializer;
import org.ws4d.java.io.xml.XmlSerializerImplementation;
import org.ws4d.java.io.xml.cache.XmlAttribute;
import org.ws4d.java.io.xml.cache.XmlPrefix;
import org.ws4d.java.io.xml.cache.XmlStructure;
import org.ws4d.java.io.xml.cache.XmlTag;
import org.ws4d.java.io.xml.cache.XmlText;
import org.ws4d.java.io.xml.canonicalization.NamespaceRecord;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.mxp1_serializer.MXSerializer;
import org.xmlpull.v1.IllegalStateException;

public class CanonicalSerializer
extends MXSerializer
implements XmlSerializer {
    public static final int EXC_C14N_XML_SERIALIZER = 1;
    private int type = 1;
    Writer writer;
    private ArrayList xmlCache;
    private int currentCmd = -1;
    private int xmlCommandCounter = 0;
    private int secuInjectionStart = -1;
    private String id = "";
    private String lastStartedTag;
    boolean canonicalize = false;
    String currentCanonElement = "";
    public static final String[] characterEntities = new String[]{"&quot;", "&amp;", "&apos;", "&lt;", "&gt;"};
    public static final String[] correpondingCharacters = new String[]{"\"", "&", "'", "<", ">"};
    private ArrayList recognNamespaces = new ArrayList();
    private byte[] bodyByteArray = null;

    public CanonicalSerializer(String string) {
        this.id = string;
        this.xmlCache = new ArrayList();
    }

    public void setPrefix(String string, String string2) {
        this.recognNamespaces.add(new NamespaceRecord(string, string2));
        ++this.xmlCommandCounter;
        if (this.currentCmd != -1) {
            ++this.currentCmd;
            this.xmlCache.add(this.currentCmd, new XmlPrefix(string, string2));
            return;
        }
        this.xmlCache.add(new XmlPrefix(string, string2));
    }

    public org.xmlpull.v1.XmlSerializer startTag(String string, String string2) {
        this.lastStartedTag = string2;
        ++this.xmlCommandCounter;
        if (this.currentCmd != -1) {
            ++this.currentCmd;
            this.xmlCache.add(this.currentCmd, new XmlTag(true, string, string2));
            return this;
        }
        if (this.canonicalize) {
            this.xmlCache.add(new XmlTag(true, string, string2));
        } else {
            this.xmlCache.add(new XmlTag(true, string, string2));
        }
        return this;
    }

    public org.xmlpull.v1.XmlSerializer endTag(String string, String string2) {
        ++this.xmlCommandCounter;
        if (this.currentCmd != -1) {
            ++this.currentCmd;
            this.xmlCache.add(this.currentCmd, new XmlTag(false, string, string2));
            return this;
        }
        if (StringUtil.equalsIgnoreCase(string2, "header")) {
            this.secuInjectionStart = this.xmlCommandCounter - 2;
        }
        if (this.canonicalize) {
            this.xmlCache.add(new XmlTag(false, string, string2));
        } else {
            this.xmlCache.add(new XmlTag(false, string, string2));
        }
        if ((string + string2).equals(this.currentCanonElement)) {
            this.canonicalize = false;
        }
        return this;
    }

    public org.xmlpull.v1.XmlSerializer attribute(String string, String string2, String string3) {
        if (this.canonicalize) {
            string3 = this.c14nAttributeString(string3);
        }
        if (string2.equals("ID") && string3.equals(this.id)) {
            this.canonicalize = true;
            this.currentCanonElement = this.lastStartedTag;
        }
        ++this.xmlCommandCounter;
        if (this.currentCmd != -1) {
            ++this.currentCmd;
            this.xmlCache.add(this.currentCmd, new XmlAttribute(string, string2, string3));
            return this;
        }
        this.xmlCache.add(new XmlAttribute(string, string2, string3));
        return this;
    }

    public void attributeo(String string, String string2, String string3) {
        try {
            super.attribute(string, string2, string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setPrefixo(String string, String string2) {
        try {
            super.setPrefix(string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public XmlSerializer startTago(String string, String string2) {
        try {
            super.startTag(string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public XmlSerializer endTago(String string, String string2) {
        try {
            super.endTag(string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public org.xmlpull.v1.XmlSerializer texto(String string) {
        try {
            super.text(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public void flushCache() {
        Iterator iterator = this.xmlCache.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            try {
                XmlStructure xmlStructure = (XmlStructure)iterator.next();
                if (xmlStructure.getType() == 0 && ((XmlTag)xmlStructure).getName().equals("Body")) {
                    byte[] byArray;
                    if (this.bodyByteArray == null) {
                        byArray = this.bodyPart();
                        this.bodyByteArray = this.bodyByteArray;
                    } else {
                        byArray = this.bodyByteArray;
                    }
                    this.writer.write(this.byteArrayToString(byArray));
                    bl = false;
                }
                if (bl) {
                    xmlStructure.flush(this);
                }
                if (xmlStructure.getType() != 1 || !((XmlTag)xmlStructure).getName().equals("Body")) continue;
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            super.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String byteArrayToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + (char)byArray[i];
        }
        return string;
    }

    public void setOutput(Writer writer) {
        super.setOutput(writer);
        this.writer = writer;
    }

    public void plainText(String string) throws IOException {
        this.writer.write(string);
    }

    public org.xmlpull.v1.XmlSerializer text(String string) {
        if (this.canonicalize) {
            string = this.c14nValueString(string);
        }
        ++this.xmlCommandCounter;
        if (this.currentCmd != -1) {
            ++this.currentCmd;
            this.xmlCache.add(this.currentCmd, new XmlText(string));
        }
        this.xmlCache.add(new XmlText(string));
        return this;
    }

    private String c14nValueString(String string) {
        for (int i = 0; i < correpondingCharacters.length; ++i) {
            int n = -1;
            while ((n = string.indexOf(correpondingCharacters[i], n == -1 ? 0 : n)) > 0 && string.indexOf(characterEntities[i], n == -1 ? 0 : n) <= -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + correpondingCharacters[i].length());
                n += characterEntities[i].length() - 1;
                string = string2 + characterEntities[i] + string3;
            }
        }
        return string;
    }

    private String c14nAttributeString(String string) {
        for (int i = 0; i < characterEntities.length; ++i) {
            int n = -1;
            while ((n = string.indexOf(characterEntities[i], n == -1 ? 0 : n)) > 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + characterEntities[i].length());
                n += correpondingCharacters[i].length();
                string = string2 + correpondingCharacters[i] + string3;
            }
        }
        return string;
    }

    public void unknownElements(QName qName, List list) throws IOException {
        ElementHandler elementHandler = ElementHandlerRegistry.getRegistry().getElementHandler(qName);
        if (elementHandler != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                elementHandler.serializeElement(this, qName, iterator.next());
            }
        }
    }

    public void namespaceWriter() {
        boolean bl = false;
        HashMap hashMap = new HashMap();
        int n = -1;
        for (int i = 0; i < this.xmlCache.size(); ++i) {
            String string;
            XmlStructure xmlStructure = (XmlStructure)this.xmlCache.get(i);
            if (xmlStructure.getType() == 0) {
                n = i;
            }
            if (xmlStructure.getType() == 0 && StringUtil.equalsIgnoreCase(((XmlTag)xmlStructure).getName(), "Body")) {
                bl = true;
                string = this.getPrefixFor(((XmlTag)xmlStructure).getNamespace());
                hashMap.put(string, ((XmlTag)xmlStructure).getNamespace());
                this.xmlCache.add(n + 1, new XmlAttribute("", "xmlns:" + string, xmlStructure.getNamespace()));
                continue;
            }
            if (!bl || (string = this.getPrefixFor(xmlStructure.getNamespace())) == null || xmlStructure.getType() == 1 || hashMap.containsKey(string)) continue;
            this.xmlCache.add(n + 1, new XmlAttribute("", "xmlns:" + string, xmlStructure.getNamespace()));
            hashMap.put(string, xmlStructure.getNamespace());
        }
    }

    private void writeSortedAttributes(XmlSerializer xmlSerializer, ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XmlStructure xmlStructure = (XmlStructure)iterator.next();
            if (xmlStructure.getType() == 2 || xmlStructure.getName().startsWith("xmlns")) {
                arrayList2.add(xmlStructure);
                continue;
            }
            arrayList3.add(xmlStructure);
        }
        arrayList3 = this.sortXmlElemets(arrayList3);
        arrayList2 = this.sortXmlElemets(arrayList2);
        this.writeArrayToSerializer(xmlSerializer, arrayList2);
        this.writeArrayToSerializer(xmlSerializer, arrayList3);
    }

    private void writeArrayToSerializer(XmlSerializer xmlSerializer, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((XmlStructure)iterator.next()).flush(xmlSerializer);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private ArrayList sortXmlElemets(ArrayList arrayList) {
        for (int i = 1; i < arrayList.size(); ++i) {
            int n;
            XmlStructure xmlStructure = (XmlStructure)arrayList.get(i);
            for (n = i; n > 0 && ((XmlStructure)arrayList.get(n - 1)).getValue().compareTo(xmlStructure.getValue()) > 0; --n) {
                arrayList.set(n, arrayList.get(n - 1));
            }
            arrayList.set(n, xmlStructure);
        }
        return arrayList;
    }

    public byte[] bodyPart() {
        XmlSerializerImplementation xmlSerializerImplementation = new XmlSerializerImplementation();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            xmlSerializerImplementation.setOutput(byteArrayOutputStream, "UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.namespaceWriter();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.xmlCache.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            XmlStructure xmlStructure = (XmlStructure)iterator.next();
            if (bl) {
                try {
                    if (xmlStructure.getType() == 3 || xmlStructure.getType() == 2) {
                        arrayList.add(xmlStructure.getType() == 2 ? new XmlAttribute("", "xmlns:" + xmlStructure.getName(), xmlStructure.getValue()) : xmlStructure);
                        continue;
                    }
                    if (xmlStructure.getType() == 0) {
                        if (!arrayList.isEmpty() && !bl2) {
                            this.writeSortedAttributes(xmlSerializerImplementation, arrayList);
                            arrayList = new ArrayList();
                        }
                        bl2 = false;
                        ((XmlTag)xmlStructure).setName(this.getPrefixFor(((XmlTag)xmlStructure).getNamespace()) + ":" + xmlStructure.getName());
                        ((XmlTag)xmlStructure).setNamespace("");
                    } else if (xmlStructure.getType() == 4 || xmlStructure.getType() == 1) {
                        if (xmlStructure.getType() == 1 && !StringUtil.equalsIgnoreCase(xmlStructure.getName(), "body")) {
                            bl2 = true;
                            ((XmlTag)xmlStructure).setName(this.getPrefixFor(xmlStructure.getNamespace()) + ":" + xmlStructure.getName());
                            xmlStructure.setNameSpace("");
                        }
                        if (!arrayList.isEmpty()) {
                            this.writeSortedAttributes(xmlSerializerImplementation, arrayList);
                            arrayList = new ArrayList();
                        }
                    }
                    if (xmlStructure.getType() == 1 && StringUtil.equalsIgnoreCase(((XmlTag)xmlStructure).getName(), "Body")) {
                        xmlStructure = new XmlTag(false, "", this.getPrefixFor(((XmlTag)xmlStructure).getNamespace()) + ":" + xmlStructure.getName());
                        xmlStructure.flush(xmlSerializerImplementation);
                        break;
                    }
                    xmlStructure.flush(xmlSerializerImplementation);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                continue;
            }
            if (xmlStructure.getType() != 0 || !StringUtil.equalsIgnoreCase(((XmlTag)xmlStructure).getName(), "Body")) continue;
            bl = true;
            try {
                xmlStructure = new XmlTag(true, "", this.getPrefixFor(((XmlTag)xmlStructure).getNamespace()) + ":" + xmlStructure.getName());
                xmlStructure.flush(xmlSerializerImplementation);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            xmlSerializerImplementation.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.bodyByteArray = byteArrayOutputStream.toByteArray();
        return this.bodyByteArray;
    }

    public void injectSecurityStart() {
        if (this.secuInjectionStart != -1) {
            this.currentCmd = this.secuInjectionStart;
            return;
        }
        Iterator iterator = this.xmlCache.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            XmlStructure xmlStructure = (XmlStructure)iterator.next();
            if (xmlStructure.getType() == 0 && StringUtil.equalsIgnoreCase(((XmlTag)xmlStructure).getName(), "header")) {
                this.currentCmd = n + 1;
                return;
            }
            ++n;
        }
    }

    public void injectSecurityDone() {
        this.currentCmd = -1;
    }

    public int getType() {
        return this.type;
    }

    public Writer getOutput() {
        return super.getWriter();
    }

    public String getPrefixFor(String string) {
        Iterator iterator = this.recognNamespaces.iterator();
        while (iterator.hasNext()) {
            NamespaceRecord namespaceRecord = (NamespaceRecord)iterator.next();
            if (!namespaceRecord.namespace.equals(string)) continue;
            return namespaceRecord.prefix;
        }
        return null;
    }

    public String getNamespaceFor(String string) {
        Iterator iterator = this.recognNamespaces.iterator();
        while (iterator.hasNext()) {
            NamespaceRecord namespaceRecord = (NamespaceRecord)iterator.next();
            if (!namespaceRecord.prefix.equals(string)) continue;
            return namespaceRecord.namespace;
        }
        return null;
    }
}

