/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.message;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.constants.WSAConstants;
import org.ws4d.java.constants.WSSecurityConstants;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.schema.PredefinedSchemaTypes;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.parameter.StringValue;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;

public class FaultMessage
extends Message {
    public static final String ACTION_ADDRESSING = "http://www.w3.org/2005/08/addressing/fault";
    public static final String ACTION_SOAP = "http://www.w3.org/2005/08/addressing/soap/fault";
    public static final String ACTION_WSD = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/fault";
    private QName code;
    private QName subcode;
    private QName subsubcode;
    private DataStructure reason;
    private ParameterValue detail;

    public static FaultMessage createActionNotSupportedFault(Message message) {
        String string = message.getHeader().getCommunicationManagerID();
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(message.getHeader().getCommunicationManagerID());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(message.getProtocolInfo().getVersion());
        String string2 = message.getAction().toString();
        FaultMessage faultMessage = new FaultMessage(constantsHelper.getWSAActionAddressingFault(), string);
        faultMessage.setResponseTo(message);
        faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
        faultMessage.setSubcode(constantsHelper.getWSAFaultActionNotSupported());
        LocalizedString localizedString = new LocalizedString("The endpoint at the specified address " + message.getTo() + " doesn't support the requested action " + string2 + ".", null);
        faultMessage.addReason(localizedString);
        ParameterValue parameterValue = ParameterValue.createElementValue(PredefinedSchemaTypes.WSA_PROBLEM_ACTION);
        ParameterValue parameterValue2 = parameterValue.get("Action");
        if (parameterValue.getValueType() == 1) {
            StringValue stringValue = (StringValue)parameterValue2;
            stringValue.set(string2);
        }
        faultMessage.setDetail(parameterValue);
        return faultMessage;
    }

    public static FaultMessage createEndpointUnavailableFault(Message message) {
        String string = message.getHeader().getCommunicationManagerID();
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(message.getHeader().getCommunicationManagerID());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = communicationUtil.getHelper(message.getProtocolInfo().getVersion());
        FaultMessage faultMessage = new FaultMessage(constantsHelper.getWSAActionAddressingFault(), string);
        faultMessage.setResponseTo(message);
        faultMessage.setCode(SOAPConstants.SOAP_FAULT_RECEIVER);
        faultMessage.setSubcode(constantsHelper.getWSAfaultEndpointUnavailable());
        LocalizedString localizedString = new LocalizedString("The endpoint at the specified address " + message.getTo() + " is unable to process the message at this time.", null);
        faultMessage.addReason(localizedString);
        return faultMessage;
    }

    public static FaultMessage createMessageAddressingHeaderRequired(String string) {
        FaultMessage faultMessage = new FaultMessage(ACTION_ADDRESSING, string);
        faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
        faultMessage.setSubcode(WSAConstants.WSA_FAULT_MESSAGE_ADDRESSING_HEADER_REQUIRED);
        LocalizedString localizedString = new LocalizedString("A required header representing a Message Addressing Property is not present", null);
        faultMessage.addReason(localizedString);
        return faultMessage;
    }

    public static FaultMessage createAuthenticationFault(Message message) {
        String string = message.getHeader().getCommunicationManagerID();
        FaultMessage faultMessage = new FaultMessage("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", string);
        faultMessage.setResponseTo(message);
        faultMessage.setCode(SOAPConstants.SOAP_FAULT_SENDER);
        faultMessage.setSubcode(WSSecurityConstants.WSSE_FAULT_AUTHENTICATION);
        LocalizedString localizedString = new LocalizedString("The security token could not be authenticated or authorized.", null);
        faultMessage.addReason(localizedString);
        return faultMessage;
    }

    public FaultMessage(String string, String string2) {
        this(SOAPHeader.createHeader(string, string2));
    }

    public FaultMessage(SOAPHeader sOAPHeader) {
        this(sOAPHeader, null, null);
    }

    public FaultMessage(SOAPHeader sOAPHeader, QName qName, QName qName2) {
        super(sOAPHeader);
        this.code = qName;
        this.subcode = qName2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ header=").append(this.header);
        stringBuffer.append(", inbound=").append(this.inbound);
        stringBuffer.append(", code=").append(this.code);
        stringBuffer.append(", subcode=").append(this.subcode);
        stringBuffer.append(", subsubcode=").append(this.subsubcode);
        stringBuffer.append(", reason=").append(this.reason);
        stringBuffer.append(", detail=").append(this.detail);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public int getType() {
        return 500;
    }

    public QName getCode() {
        return this.code;
    }

    public QName getSubcode() {
        return this.subcode;
    }

    public QName getSubsubcode() {
        return this.subsubcode;
    }

    public DataStructure getReason() {
        return this.reason;
    }

    public ParameterValue getDetail() {
        return this.detail;
    }

    public void setCode(QName qName) {
        this.code = qName;
    }

    public void setSubcode(QName qName) {
        this.subcode = qName;
    }

    public void setSubsubcode(QName qName) {
        this.subsubcode = qName;
    }

    public void setReason(DataStructure dataStructure) {
        this.reason = dataStructure;
    }

    public void setDetail(ParameterValue parameterValue) {
        this.detail = parameterValue;
    }

    public void addReason(LocalizedString localizedString) {
        if (this.reason == null) {
            this.reason = new ArrayList();
        }
        this.reason.add(localizedString);
    }
}

