/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.message.discovery;

import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.StringUtil;

public abstract class DiscoveryMessage
extends Message {
    private DiscoveryData discoveryData = null;

    public static SOAPHeader createDiscoveryHeader(String string, String string2) {
        SOAPHeader sOAPHeader = SOAPHeader.createHeader(string, string2);
        sOAPHeader.setMessageId(new AttributedURI(IDGenerator.getUUIDasURI()));
        sOAPHeader.setTo(new AttributedURI("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"));
        return sOAPHeader;
    }

    DiscoveryMessage(SOAPHeader sOAPHeader) {
        this(sOAPHeader, null);
    }

    DiscoveryMessage(SOAPHeader sOAPHeader, DiscoveryData discoveryData) {
        super(sOAPHeader);
        this.discoveryData = discoveryData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ header=").append(this.header);
        stringBuffer.append(", inbound=").append(this.inbound);
        stringBuffer.append(", discoveryData=").append(this.discoveryData);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public EndpointReference getEndpointReference() {
        return this.discoveryData.getEndpointReference();
    }

    public long getMetadataVersion() {
        return this.discoveryData.getMetadataVersion();
    }

    public QNameSet getTypes() {
        return this.discoveryData.getTypes();
    }

    public ScopeSet getScopes() {
        return this.discoveryData.getScopes();
    }

    public XAddressInfoSet getXAddressInfoSet() {
        return this.discoveryData.getXAddressInfoSet();
    }

    public DiscoveryData getDiscoveryData() {
        return this.discoveryData;
    }

    public void setDiscoveryData(DiscoveryData discoveryData) {
        this.discoveryData = discoveryData;
    }
}

