/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.schema;

import java.io.IOException;
import org.ws4d.java.io.xml.ElementParser;
import org.ws4d.java.schema.AllContainer;
import org.ws4d.java.schema.Annotation;
import org.ws4d.java.schema.Any;
import org.ws4d.java.schema.AnyAttribute;
import org.ws4d.java.schema.Attribute;
import org.ws4d.java.schema.AttributeGroup;
import org.ws4d.java.schema.ChoiceContainer;
import org.ws4d.java.schema.ComplexContent;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.ElementContainer;
import org.ws4d.java.schema.Group;
import org.ws4d.java.schema.InheritType;
import org.ws4d.java.schema.NamedObject;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.schema.SequenceContainer;
import org.ws4d.java.schema.SimpleContent;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.StringUtil;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ComplexType
extends Type {
    public static final int CONTAINER_ALL = 0;
    public static final int CONTAINER_SEQUENCE = 1;
    public static final int CONTAINER_CHOICE = 2;
    static final String TAG_COMPLEXTYPE = "complexType";
    protected ElementContainer container = null;
    protected Group group = null;

    static final Type createComplexType(ElementParser elementParser, String string, Schema schema) throws XmlPullParserException, IOException, SchemaException {
        String string2 = elementParser.getAttributeValue(null, "name");
        String string3 = elementParser.getAttributeValue(null, "abstract");
        Type type = null;
        type = string2 == null ? new ComplexType() : new ComplexType(new QName(string2, string));
        type.setParentSchema(schema);
        if (string3 != null) {
            type.setAbstract(StringUtil.equalsIgnoreCase("true", string3));
        }
        int n = elementParser.getDepth();
        while (elementParser.nextTag() != 3 && elementParser.getDepth() == n + 1) {
            NamedObject namedObject;
            Any any;
            String string4 = elementParser.getNamespace();
            String string5 = elementParser.getName();
            if (!"http://www.w3.org/2001/XMLSchema".equals(string4)) continue;
            if (StringUtil.equalsIgnoreCase("all", string5)) {
                any = new AllContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                namedObject = type;
                ((ComplexType)namedObject).setContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("sequence", string5)) {
                any = new SequenceContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                namedObject = type;
                ((ComplexType)namedObject).setContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("choice", string5)) {
                any = new ChoiceContainer();
                ElementContainer.handleContainerElements(elementParser, (ElementContainer)any, string, schema);
                namedObject = type;
                ((ComplexType)namedObject).setContainer((ElementContainer)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("group", string5)) {
                any = Group.createGroup(elementParser, string, schema);
                namedObject = type;
                ((ComplexType)namedObject).setGroup((Group)any);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("simpleContent", string5)) {
                type = string2 == null ? SimpleContent.handleSimpleContent(elementParser, null, string, schema) : SimpleContent.handleSimpleContent(elementParser, new QName(string2, string), string, schema);
                any = (SimpleContent)type;
                if (((SimpleContent)any).getBase() != null) continue;
                schema.addBaseForResolve((InheritType)((Object)any));
                continue;
            }
            if (StringUtil.equalsIgnoreCase("complexContent", string5)) {
                type = string2 == null ? ComplexContent.handleComplexContent(elementParser, null, string, schema) : ComplexContent.handleComplexContent(elementParser, new QName(string2, string), string, schema);
                any = (ComplexContent)type;
                schema.addBaseForResolve((InheritType)((Object)any));
                continue;
            }
            if (StringUtil.equalsIgnoreCase("annotation", string5)) {
                Annotation.handleAnnotation(elementParser, type);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attribute", string5)) {
                any = type;
                namedObject = Attribute.createAttribute(elementParser, string, schema);
                ((Type)any).addAttribute((Attribute)namedObject);
                continue;
            }
            if (StringUtil.equalsIgnoreCase("attributeGroup", string5)) {
                any = type;
                namedObject = AttributeGroup.createAttributeGroup(elementParser, string, schema);
                ((Type)any).addAttributeGroup((AttributeGroup)namedObject);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase("anyAttribute", string5)) continue;
            any = AnyAttribute.createAnyAttribute(elementParser);
            namedObject = type;
            ((Type)namedObject).setAnyAttribute((AnyAttribute)any);
        }
        return type;
    }

    public ComplexType(String string, String string2, int n) {
        this(new QName(string, string2), n);
    }

    public ComplexType(int n) {
        this(null, n);
    }

    public ComplexType(QName qName, int n) {
        super(qName);
        switch (n) {
            case 0: {
                this.container = new AllContainer();
                break;
            }
            case 1: {
                this.container = new SequenceContainer();
                break;
            }
            case 2: {
                this.container = new ChoiceContainer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown container type: " + n);
            }
        }
    }

    ComplexType() {
        this(null);
    }

    ComplexType(QName qName) {
        super(qName);
    }

    public int getSchemaIdentifier() {
        return 4;
    }

    public int getContainerMinOccurs() {
        if (this.container == null) {
            if (this.group == null) {
                return 1;
            }
            return this.group.getContainerMinOccurs();
        }
        return this.container.getMinOccurs();
    }

    public int getContainerMaxOccurs() {
        if (this.container == null) {
            if (this.group == null) {
                return 1;
            }
            return this.group.getContainerMaxOccurs();
        }
        return this.container.getMaxOccurs();
    }

    public void setContainerMinOccurs(int n) {
        if (this.container == null) {
            return;
        }
        this.container.setMinOccurs(n);
    }

    public void setContainerMaxOccurs(int n) {
        if (this.container == null) {
            return;
        }
        this.container.setMaxOccurs(n);
    }

    public boolean hasElements() {
        if (this.container == null) {
            if (this.group == null) {
                return false;
            }
            return this.group.hasElements();
        }
        return this.container.hasElements();
    }

    public void addElement(Element element) {
        if (this.container == null) {
            return;
        }
        this.container.addElement(element);
    }

    public Element getElementByName(QName qName) {
        if (this.container == null) {
            if (this.group == null) {
                return null;
            }
            return this.group.getElementByName(qName);
        }
        return this.container.getElementByName(qName);
    }

    public Element getElementByName(String string) {
        if (this.container == null) {
            if (this.group == null) {
                return null;
            }
            return this.group.getElementByName(string);
        }
        return this.container.getElementByName(string);
    }

    public int getElementCount() {
        if (this.container == null) {
            if (this.group == null) {
                return 0;
            }
            return this.group.getElementCount();
        }
        return this.container.getElementCount();
    }

    public Iterator elements() {
        if (this.container == null) {
            if (this.group == null) {
                return EmptyStructures.EMPTY_ITERATOR;
            }
            return this.group.elements();
        }
        return this.container.allElements();
    }

    public ElementContainer getContainer() {
        return this.container == null ? (this.group == null ? null : this.group.getContainer()) : this.container;
    }

    protected void serializeElements(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        if (this.container == null) {
            if (this.group == null) {
                return;
            }
            this.group.serialize(xmlSerializer, schema);
        }
        this.container.serialize(xmlSerializer, schema);
    }

    void serialize(XmlSerializer xmlSerializer, Schema schema) throws IOException {
        xmlSerializer.startTag("http://www.w3.org/2001/XMLSchema", TAG_COMPLEXTYPE);
        if (this.name != null) {
            xmlSerializer.attribute(null, "name", this.name.getLocalPart());
        }
        if (this.isAbstract()) {
            xmlSerializer.attribute(null, "abstract", "true");
        }
        this.serializeElements(xmlSerializer, schema);
        this.serializeAttributes(xmlSerializer, schema);
        this.serializeAttributeGroups(xmlSerializer, schema);
        this.serializeAnyAttribute(xmlSerializer, schema);
        xmlSerializer.endTag("http://www.w3.org/2001/XMLSchema", TAG_COMPLEXTYPE);
    }

    void setContainer(ElementContainer elementContainer) {
        this.container = elementContainer;
    }

    void setGroup(Group group) {
        this.container = null;
        this.group = group;
    }
}

