/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.HTTPSBinding;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.tcp.SecureSocketFactorySE;
import org.ws4d.java.communication.connection.tcp.ServerSocket;
import org.ws4d.java.communication.connection.tcp.Socket;
import org.ws4d.java.configuration.SecurityProperties;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.io.xml.XmlSerializer;
import org.ws4d.java.io.xml.canonicalization.CanonicalSerializer;
import org.ws4d.java.message.Message;
import org.ws4d.java.security.Base64Util;
import org.ws4d.java.security.DPWSSecurityManager;
import org.ws4d.java.security.IDawareInputStream;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class DPWSSecurityManagerSE
implements DPWSSecurityManager {
    private HashMap protocolDataToInputStream = new HashMap();
    private static SecurityProperties secProp;

    public String getBodySignature(XmlSerializer xmlSerializer, Message message) {
        CanonicalSerializer canonicalSerializer = (CanonicalSerializer)xmlSerializer;
        byte[] byArray = canonicalSerializer.bodyPart();
        byte[] byArray2 = this.getSignature(byArray, (PrivateKey)message.getPrivateKey());
        return Base64Util.encodeBytes(byArray2);
    }

    private byte[] getSignature(byte[] byArray, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            MessageDigest messageDigest = MessageDigest.getInstance("sha1");
            byArray = messageDigest.digest(byArray);
            byte[][] byArrayArray = new byte[][]{byArray};
            byArray = DPWSSecurityManagerSE.generateSignedInfo(byArrayArray, new String[]{"BID1"});
            byArray = messageDigest.digest(byArray);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        return null;
    }

    public boolean validateMessage(byte[] byArray, ProtocolData protocolData, EndpointReference endpointReference, String[] stringArray) {
        try {
            IDawareInputStream iDawareInputStream = (IDawareInputStream)this.protocolDataToInputStream.get(protocolData);
            byte[][] byArray2 = iDawareInputStream.getPartsByteArrays();
            if (byArray2 == null) {
                Log.error("Message validation failed because the referred sections cound not be extracted!");
                return false;
            }
            this.protocolDataToInputStream.remove(protocolData);
            Certificate certificate = null;
            DeviceReference deviceReference = null;
            ServiceReference serviceReference = null;
            deviceReference = DeviceServiceRegistry.getDeviceReference(endpointReference, false);
            if (deviceReference != null) {
                try {
                    certificate = (Certificate)deviceReference.getDevice().getCertificate();
                }
                catch (TimeoutException timeoutException) {
                    timeoutException.printStackTrace();
                }
            } else {
                serviceReference = DeviceServiceRegistry.getServiceReference(endpointReference, protocolData.getCommunicationManagerId(), false);
                if (serviceReference != null) {
                    try {
                        certificate = (Certificate)serviceReference.getService().getCertificate();
                    }
                    catch (TimeoutException timeoutException) {
                        timeoutException.printStackTrace();
                    }
                }
            }
            for (int i = 0; certificate == null && stringArray != null && i < stringArray.length; ++i) {
                certificate = (Certificate)this.getCertificate(stringArray[i]);
            }
            if (certificate == null) {
                certificate = (Certificate)this.getCertificate(endpointReference.getAddress().toString());
                if (deviceReference != null) {
                    deviceReference.getDevice().setCertificate(certificate);
                } else if (serviceReference != null) {
                    serviceReference.getService().setCertificate(certificate);
                }
            }
            if (certificate == null) {
                Log.error("Security: device/service uuid '" + endpointReference.getAddress() + "' not found in the specified keystore!");
                return false;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("sha1");
            byte[][] byArrayArray = new byte[byArray2.length][];
            for (int i = 0; i < byArray2.length; ++i) {
                byArrayArray[i] = messageDigest.digest(byArray2[i]);
            }
            byte[] byArray3 = DPWSSecurityManagerSE.generateSignedInfo(byArrayArray, iDawareInputStream.getIds());
            byArray3 = messageDigest.digest(byArray3);
            PublicKey publicKey = certificate.getPublicKey();
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(publicKey);
            signature.update(byArray3);
            if (signature.verify(byArray)) {
                Log.info("Discovery-Message validated!");
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        Log.warn("Discovery-Message could not be validated!");
        return false;
    }

    public long getMD5Hash(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        messageDigest.update(string.getBytes(), 0, string.length());
        return new BigInteger(1, messageDigest.digest()).longValue();
    }

    public Object getPrivateKey(String string, String string2) {
        try {
            if (secProp == null) {
                secProp = SecurityProperties.getInstance();
            }
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fileInputStream = new FileInputStream(secProp.getKeyStoreFilePath());
            keyStore.load(fileInputStream, secProp.getKeyStorePswd().toCharArray());
            fileInputStream.close();
            PrivateKey privateKey = null;
            if (string2 == null) {
                string2 = SecurityProperties.getInstance().getKeyStorePswd();
            }
            if (string2 == null) {
                throw new KeyStoreException("Could not fetch private key. Password not found.");
            }
            try {
                privateKey = (PrivateKey)keyStore.getKey(string, string2.toCharArray());
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
            return privateKey;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return null;
    }

    public Object getCertificate(String string) {
        if (secProp == null) {
            secProp = SecurityProperties.getInstance();
        }
        try {
            Certificate certificate = null;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (SecurityProperties.getInstance().getTrustStorePath() == null && SecurityProperties.getInstance().getKeyStoreFilePath() == null) {
                return null;
            }
            FileInputStream fileInputStream = secProp.getTrustStorePath() != null ? new FileInputStream(secProp.getTrustStorePath()) : new FileInputStream(secProp.getKeyStoreFilePath());
            keyStore.load(fileInputStream, (secProp.getTrustStorePasswd() != null ? secProp.getTrustStorePasswd() : secProp.getKeyStorePswd()).toCharArray());
            fileInputStream.close();
            String string2 = string;
            int n = -1;
            while (string2.length() > 1 && (certificate = keyStore.getCertificate(string2.toLowerCase())) == null) {
                n = string2.indexOf(47);
                string2 = n < 0 ? "" : string2.substring(n + 1);
            }
            return certificate;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("Security: Could not get keystore!");
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return null;
    }

    public InputStream wrapInputStream(InputStream inputStream, ProtocolData protocolData) {
        IDawareInputStream iDawareInputStream = new IDawareInputStream(inputStream, null);
        this.protocolDataToInputStream.put(protocolData, iDawareInputStream);
        return iDawareInputStream;
    }

    public XmlSerializer getNewCanonicalSerializer(String string) {
        return new CanonicalSerializer(string);
    }

    public ServerSocket getSecureServerSocket(IPAddress iPAddress, int n, String string) {
        try {
            return SecureSocketFactorySE.createServerSocket(iPAddress, n, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Socket getSecureSocket(URI uRI) {
        try {
            return SecureSocketFactorySE.createSocket(new IPAddress(uRI.getHost()), uRI.getPort(), uRI.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Socket getSecureSocket(IPAddress iPAddress, int n, String string) {
        try {
            return SecureSocketFactorySE.createSocket(iPAddress, n, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public byte[] decode(String string) {
        return Base64Util.decode(string);
    }

    public boolean isHTTPS(URI uRI) {
        return StringUtil.equalsIgnoreCase(uRI.getSchema(), "https");
    }

    public Object[] getKeyManagers() throws IOException, GeneralSecurityException {
        String string = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string);
        if (SecurityProperties.getInstance().getKeyStoreFilePath() == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(SecurityProperties.getInstance().getKeyStoreFilePath());
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(fileInputStream, SecurityProperties.getInstance().getKeyStorePswd().toCharArray());
        fileInputStream.close();
        keyManagerFactory.init(keyStore, SecurityProperties.getInstance().getKeyStorePswd().toCharArray());
        Object[] objectArray = keyManagerFactory.getKeyManagers();
        return objectArray;
    }

    public Object[] getTrustManagers() throws IOException, GeneralSecurityException {
        String string = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string);
        if (SecurityProperties.getInstance().getTrustStorePath() == null) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(SecurityProperties.getInstance().getTrustStorePath());
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(fileInputStream, SecurityProperties.getInstance().getTrustStorePasswd().toCharArray());
        fileInputStream.close();
        trustManagerFactory.init(keyStore);
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        return objectArray;
    }

    public String getAliasFromBinding(CommunicationBinding communicationBinding) {
        if (communicationBinding.getType() != 1) {
            return null;
        }
        return ((HTTPSBinding)communicationBinding).getAlias();
    }

    private static byte[] generateSignedInfo(byte[][] byArray, String[] stringArray) {
        String string = "<SignedInfo><CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml_exc-c14n#\" /> <SignatureMethod Algorithm=\"htt://www.w3.org/2000/09/xmldsig#rsa-sha1\" />";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + "<Reference URI=\"#" + stringArray[i] + "\" ><Transforms><Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />" + "</Transforms><DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />" + "<DigestValue>" + Base64Util.encodeBytes(byArray[i]) + "</DigestValue></Reference>";
        }
        string = string + "</SignedInfo>";
        return string.getBytes();
    }

    private String byteArrayToString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + (char)byArray[i];
        }
        return string;
    }

    public String encode(byte[] byArray) {
        return Base64Util.encodeBytes(byArray);
    }
}

