/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import java.io.IOException;
import java.util.Date;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultIncomingMessageListener;
import org.ws4d.java.communication.Discovery;
import org.ws4d.java.communication.DiscoveryBinding;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.protocol.http.HTTPGroup;
import org.ws4d.java.communication.protocol.http.HTTPUser;
import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.configuration.DeviceProperties;
import org.ws4d.java.configuration.DevicesPropertiesHandler;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.dispatch.DefaultDeviceReference;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatch;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.Device;
import org.ws4d.java.service.DeviceCommons;
import org.ws4d.java.service.LocalDevice;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.MessageIdBuffer;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.AppSequence;
import org.ws4d.java.types.CustomizeMData;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.EprInfoSet;
import org.ws4d.java.types.HostMData;
import org.ws4d.java.types.HostedMData;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.ProbeScopeSet;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.RelationshipMData;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.ThisDeviceMData;
import org.ws4d.java.types.ThisModelMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.util.WS4DIllegalStateException;

public class DefaultDevice
extends DeviceCommons
implements LocalDevice {
    private static final int[] DISCOVERY_MESSAGE_TYPES = new int[]{3, 5};
    private static final int[] DEVICE_MESSAGE_TYPES = new int[]{101, 3};
    protected final int configurationId;
    protected final DeviceMessageListener incomingListener = new DeviceMessageListener(this);
    private final Lockable lockSupport = new LockSupport();
    protected DefaultDeviceReference myDeviceRef = null;
    protected DiscoveryData discoveryData;
    protected final Set services = new HashSet();
    protected boolean running = false;
    protected boolean changed = false;
    protected boolean discoveryDataChanged = true;
    protected boolean isMetadataVersionSet = false;
    protected final AppSequenceManager appSequencer = new AppSequenceManager();
    protected DataStructure transportBindings;
    protected DataStructure inputDiscoveryBindings;
    protected final DataStructure outputDiscoveryDomains = new HashSet();
    protected final DeviceProperties deviceProp;
    protected boolean usingDefaultDiscoveryDomains = false;
    private boolean isDiscoveryProxy = false;
    protected String defaultLanugaugeString = "en-EN";
    protected LocalizedString defaultFriendlyName;
    protected LocalizedString defaultModelName = this.defaultFriendlyName = new LocalizedString(StringUtil.simpleClassName(this.getClass()), this.defaultLanugaugeString);
    protected LocalizedString defaultManufacturer = new LocalizedString("MATERNA GmbH", null);
    private String namespace = "http://ws4d.org";
    private final MessageIdBuffer messageIdBuffer = new MessageIdBuffer();
    public static final int MAX_QNAME_SERIALIZATION = 10;
    private HTTPGroup userGroup = null;
    public static boolean hasCustomizeMData = false;
    private HashMap mdata = new HashMap();
    public CustomizeMData custom = new CustomizeMData();

    public DefaultDevice() {
        this(-1);
    }

    public DefaultDevice(int n) {
        this.configurationId = n;
        if (this.configurationId != -1) {
            DevicesPropertiesHandler devicesPropertiesHandler = DevicesPropertiesHandler.getInstance();
            this.deviceProp = devicesPropertiesHandler.getDeviceProperties(new Integer(n));
            this.discoveryData = this.deviceProp.getDiscoveryData();
            this.deviceMetadata = this.deviceProp.getDeviceData();
            this.modelMetadata = this.deviceProp.getModelData();
            this.transportBindings = this.deviceProp.getBindings();
            this.inputDiscoveryBindings = this.deviceProp.getDiscoveryBindings();
            if (this.getEndpointReference() == null) {
                EndpointReference endpointReference = new EndpointReference(IDGenerator.getUUIDasURI());
                this.setEndpointReference(endpointReference);
            }
            if (this.getMetadataVersion() < 0L) {
                this.setMetadataVersion((int)(new Date().getTime() / 1000L));
            }
            if (this.deviceProp.useSecurity()) {
                this.setSecureDevice();
            }
        } else {
            this.deviceProp = null;
            this.transportBindings = new ArrayList(2);
            this.inputDiscoveryBindings = new ArrayList(2);
            this.discoveryData = new DiscoveryData();
            EndpointReference endpointReference = new EndpointReference(IDGenerator.getUUIDasURI());
            this.setEndpointReference(endpointReference);
            this.setMetadataVersion((int)(new Date().getTime() / 1000L));
        }
    }

    public boolean isRemote() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.sharedLock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public boolean hasBindings() {
        return this.transportBindings.size() > 0;
    }

    public boolean hasDiscoveryBindings() {
        return this.inputDiscoveryBindings != null && this.inputDiscoveryBindings.size() > 0;
    }

    public Iterator getBindings() {
        return new ReadOnlyIterator(this.transportBindings);
    }

    public Iterator getDiscoveryBindings() {
        return new ReadOnlyIterator(this.inputDiscoveryBindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsBindingChanges() {
        this.lockSupport.sharedLock();
        try {
            boolean bl = !this.isRunning();
            return bl;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        this.lockSupport.exclusiveLock();
        try {
            if (this.isRunning()) {
                throw new WS4DIllegalStateException("Device is already running, unable to add binding");
            }
            this.transportBindings.add(communicationBinding);
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinding(DiscoveryBinding discoveryBinding) throws WS4DIllegalStateException {
        block5: {
            this.lockSupport.exclusiveLock();
            try {
                if (this.isRunning()) {
                    throw new WS4DIllegalStateException("Device is already running, unable to add binding");
                }
                if (discoveryBinding instanceof DiscoveryBinding) {
                    this.inputDiscoveryBindings.add(discoveryBinding);
                    break block5;
                }
                throw new WS4DIllegalStateException("Unsupported binding type: " + discoveryBinding);
            }
            finally {
                this.lockSupport.releaseExclusiveLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBinding(CommunicationBinding communicationBinding) throws WS4DIllegalStateException {
        this.lockSupport.exclusiveLock();
        try {
            if (this.isRunning()) {
                throw new WS4DIllegalStateException("Device is already running, unable to remove binding");
            }
            boolean bl = this.transportBindings.remove(communicationBinding);
            return bl;
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    public boolean removeBinding(DiscoveryBinding discoveryBinding) throws WS4DIllegalStateException {
        this.lockSupport.exclusiveLock();
        try {
            if (this.isRunning()) {
                throw new WS4DIllegalStateException("Device is already running, unable to remove binding");
            }
            if (discoveryBinding instanceof DiscoveryBinding) {
                boolean bl = this.inputDiscoveryBindings.remove(discoveryBinding);
                return bl;
            }
            throw new WS4DIllegalStateException("Unsupported binding type: " + discoveryBinding);
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBindings() throws WS4DIllegalStateException {
        this.lockSupport.exclusiveLock();
        try {
            if (this.isRunning()) {
                throw new WS4DIllegalStateException("Device is already running, unable to clear bindings");
            }
            this.transportBindings.clear();
            this.inputDiscoveryBindings.clear();
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    public DeviceReference getDeviceReference() {
        if (this.myDeviceRef == null) {
            this.myDeviceRef = DeviceServiceRegistry.getDeviceReference(this);
            this.myDeviceRef.setLocalDevice(this);
        }
        return this.myDeviceRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws IOException {
        Object object;
        if (!DPWSFramework.isRunning()) {
            throw new RuntimeException("DPWSFramework not running, please start it in advance!");
        }
        this.lockSupport.exclusiveLock();
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            boolean bl;
            if (this.isRunning()) {
                Log.warn("Cannot start device. Device already running.");
                return;
            }
            object = new QNameSet();
            if (this.deviceMetadata.getFriendlyNames().size() == 0) {
                this.deviceMetadata.addFriendlyName(this.defaultFriendlyName);
            }
            if (this.modelMetadata.getManufacturerNames().size() == 0) {
                this.modelMetadata.addManufacturerName(this.defaultManufacturer);
            }
            if (this.modelMetadata.getModelNames().size() == 0) {
                this.modelMetadata.addModelName(this.defaultModelName);
            }
            if (Log.isDebug()) {
                Log.debug("Start Device: " + this.deviceMetadata.getFriendlyNames().iterator().next());
            }
            boolean bl2 = this.hasDiscoveryBindings();
            boolean bl3 = this.hasBindings();
            boolean bl4 = bl = !this.isUsingDefaultDiscoveryDomains();
            if (!bl3) {
                object5 = StringUtil.simpleClassName(this.getClass());
                if (Log.isDebug()) {
                    Log.info("No bindings found for Device. Autobinding device " + (String)object5);
                }
                object4 = new HashSet();
                object3 = CommunicationManagerRegistry.getLoadedManagers();
                while (object3.hasNext()) {
                    object2 = (CommunicationManager)object3.next();
                    object2.getAutobindings((String)object5, (DataStructure)object4);
                }
                object3 = ((DataStructure)object4).iterator();
                while (object3.hasNext()) {
                    object2 = (CommunicationBinding)object3.next();
                    this.addBinding((CommunicationBinding)object2);
                }
            }
            if (!bl2 || !bl) {
                Object object6;
                if (!bl2 && bl) {
                    object5 = CommunicationManagerRegistry.getLoadedManagers();
                    while (object5.hasNext()) {
                        object4 = (CommunicationManager)object5.next();
                        object3 = this.getOutputDiscoveryDomains().iterator();
                        while (object3.hasNext()) {
                            object2 = (ProtocolDomain)object3.next();
                            this.inputDiscoveryBindings.add(object4.getDiscoveryBindingForDomain((ProtocolDomain)object2));
                        }
                    }
                } else if (bl2 && !bl) {
                    object5 = CommunicationManagerRegistry.getLoadedManagers();
                    while (object5.hasNext()) {
                        object4 = (CommunicationManager)object5.next();
                        object3 = this.getDiscoveryBindings();
                        while (object3.hasNext()) {
                            object2 = object4.getDiscoveryDomainForBinding((DiscoveryBinding)object3.next());
                            object6 = ((DataStructure)object2).iterator();
                            while (object6.hasNext()) {
                                this.addOutputDiscoveryDomain((ProtocolDomain)object6.next());
                            }
                        }
                    }
                } else {
                    object5 = CommunicationManagerRegistry.getLoadedManagers();
                    while (object5.hasNext()) {
                        object4 = new HashSet();
                        object3 = (CommunicationManager)object5.next();
                        object3.getProtocolDomains(this.getBindings(), (DataStructure)object4);
                        if (((DataStructure)object4).size() <= 0) continue;
                        object2 = ((DataStructure)object4).iterator();
                        while (object2.hasNext()) {
                            object6 = (ProtocolDomain)object2.next();
                            this.inputDiscoveryBindings.add(object3.getDiscoveryBindingForDomain((ProtocolDomain)object6));
                            this.addOutputDiscoveryDomain((ProtocolDomain)object6);
                        }
                    }
                }
            }
            object5 = this.getBindings();
            while (object5.hasNext()) {
                object4 = (CommunicationBinding)object5.next();
                object3 = CommunicationManagerRegistry.getManager(object4.getCommunicationManagerId());
                ((QNameSet)object).addAll(object3.getDeviceTypes());
                object3.registerDevice(DEVICE_MESSAGE_TYPES, (CommunicationBinding)object4, this.incomingListener, this.userGroup);
                this.addXAddressInfo(new XAddressInfo(object4.getTransportAddress(), object3.getCommunicationManagerId()));
            }
            object5 = this.getDiscoveryBindings();
            while (object5.hasNext()) {
                object4 = (DiscoveryBinding)object5.next();
                object3 = CommunicationManagerRegistry.getManager(object4.getCommunicationManagerId());
                ((QNameSet)object).addAll(object3.getDeviceTypes());
                object3.registerDiscovery(DISCOVERY_MESSAGE_TYPES, (DiscoveryBinding)object4, this.incomingListener);
            }
            object5 = this.services.iterator();
            while (object5.hasNext()) {
                object4 = (LocalService)object5.next();
                object4.setParentDevice(this);
                object4.start();
            }
            if (Log.isInfo()) {
                object5 = new StringBuffer();
                object4 = this.getXAddressInfos();
                while (object4.hasNext()) {
                    ((StringBuffer)object5).append(((XAddressInfo)object4.next()).getXAddress());
                    if (!object4.hasNext()) continue;
                    ((StringBuffer)object5).append(", ");
                }
                Log.info("Device [ UUID=" + this.getEndpointReference().getAddress() + ", XAddresses={ " + ((StringBuffer)object5).toString() + " } ] online.");
            }
            this.discoveryData.addTypes((QNameSet)object);
            this.appSequencer.reset();
            this.isMetadataVersionSet = false;
            object5 = DPWSFramework.getPresentation();
            if (object5 != null) {
                try {
                    object4 = object5.register(this);
                    this.setPresentationUrl(((URI)object4).toString());
                }
                catch (RuntimeException runtimeException) {
                    Log.printStackTrace(runtimeException);
                }
            }
            this.getDeviceReference();
            this.running = true;
            this.changed = false;
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
        DeviceServiceRegistry.register(this);
        object = this.createHelloMessage();
        OutDispatcher.getInstance().send((HelloMessage)object, null, this.getOutputDiscoveryDomains());
        if (this.myDeviceRef != null) {
            if (this.changed) {
                this.myDeviceRef.announceDeviceChangedAndBuildUp();
            } else {
                this.myDeviceRef.announceDeviceRunningAndBuildUp();
            }
        }
    }

    public final void stop() throws IOException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(boolean bl) throws IOException {
        this.lockSupport.exclusiveLock();
        try {
            CommunicationManager communicationManager;
            Object object;
            if (!this.isRunning()) {
                Log.warn("Cannot stop device. Device not running.");
                return;
            }
            DeviceServiceRegistry.unregister(this);
            Iterator iterator = this.getBindings();
            while (iterator.hasNext()) {
                object = (CommunicationBinding)iterator.next();
                communicationManager = CommunicationManagerRegistry.getManager(object.getCommunicationManagerId());
                this.removeXAddressInfo(new XAddressInfo(object.getTransportAddress(), communicationManager.getCommunicationManagerId()));
                communicationManager.unregisterDevice(DEVICE_MESSAGE_TYPES, (CommunicationBinding)object, this.incomingListener);
            }
            iterator = this.getDiscoveryBindings();
            while (iterator.hasNext()) {
                object = (DiscoveryBinding)iterator.next();
                communicationManager = CommunicationManagerRegistry.getManager(object.getCommunicationManagerId());
                communicationManager.unregisterDiscovery(DISCOVERY_MESSAGE_TYPES, (DiscoveryBinding)object, this.incomingListener);
            }
            if (bl) {
                iterator = this.services.iterator();
                while (iterator.hasNext()) {
                    object = (LocalService)iterator.next();
                    object.stop();
                }
            }
            Log.info("Device [ UUID=" + this.getEndpointReference().getAddress() + " ] offline.");
            this.sendBye();
            if (this.myDeviceRef != null) {
                this.myDeviceRef.announceDeviceBye();
            }
            this.running = false;
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    public void sendHello() {
        HelloMessage helloMessage = this.createHelloMessage();
        OutDispatcher.getInstance().send(helloMessage, null, this.getOutputDiscoveryDomains());
    }

    public void sendBye() {
        DiscoveryData discoveryData = new DiscoveryData();
        discoveryData.setEndpointReference(this.discoveryData.getEndpointReference());
        discoveryData.setXAddresInfoSet(this.discoveryData.getXAddressInfoSet());
        ByeMessage byeMessage = new ByeMessage(discoveryData, CommunicationManager.ID_NULL);
        byeMessage.getHeader().setAppSequence(this.appSequencer.getNext());
        OutDispatcher.getInstance().send(byeMessage, null, this.getOutputDiscoveryDomains());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deviceUpdated() {
        this.lockSupport.exclusiveLock();
        HelloMessage helloMessage = null;
        try {
            if (!this.isMetadataVersionSet) {
                this.copyDiscoveryDataIfRunning();
                long l = this.discoveryData.getMetadataVersion();
                this.discoveryData.setMetadataVersion(++l);
            } else {
                this.isMetadataVersionSet = false;
            }
            if (this.running) {
                helloMessage = this.createHelloMessage();
            }
        }
        finally {
            this.discoveryDataChanged = false;
            this.lockSupport.releaseExclusiveLock();
            if (helloMessage != null) {
                OutDispatcher.getInstance().send(helloMessage, null, this.getOutputDiscoveryDomains());
                if (this.myDeviceRef != null) {
                    this.myDeviceRef.announceDeviceChangedAndBuildUp();
                }
                this.changed = false;
            }
        }
    }

    public void sharedLock() {
        this.lockSupport.sharedLock();
    }

    public void exclusiveLock() {
        this.lockSupport.exclusiveLock();
    }

    public void releaseSharedLock() {
        this.lockSupport.releaseSharedLock();
    }

    public boolean releaseExclusiveLock() {
        boolean bl = this.lockSupport.releaseExclusiveLock();
        if (bl && this.changed) {
            this.changed = false;
            this.deviceUpdated();
        }
        return bl;
    }

    public boolean tryExclusiveLock() {
        return this.lockSupport.tryExclusiveLock();
    }

    public boolean trySharedLock() {
        return this.lockSupport.trySharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReference getEndpointReference() {
        this.lockSupport.sharedLock();
        try {
            EndpointReference endpointReference = this.discoveryData.getEndpointReference();
            return endpointReference;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getPortTypes() {
        this.lockSupport.sharedLock();
        try {
            QNameSet qNameSet = this.discoveryData.getTypes();
            Iterator iterator = qNameSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(qNameSet.iterator());
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getScopes() {
        this.lockSupport.sharedLock();
        try {
            ScopeSet scopeSet = this.discoveryData.getScopes();
            URISet uRISet = scopeSet == null ? null : scopeSet.getScopesAsUris();
            Iterator iterator = uRISet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(uRISet.iterator());
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer(String string) {
        this.lockSupport.sharedLock();
        try {
            String string2 = super.getManufacturer(string);
            return string2;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getManufacturers() {
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = super.getManufacturers();
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturerUrl() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getManufacturerUrl();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelName(String string) {
        this.lockSupport.sharedLock();
        try {
            String string2 = super.getModelName(string);
            return string2;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getModelNames() {
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = super.getModelNames();
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelNumber() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getModelNumber();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelUrl() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getModelUrl();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPresentationUrl() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getPresentationUrl();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFriendlyName(String string) {
        this.lockSupport.sharedLock();
        try {
            String string2 = super.getFriendlyName(string);
            return string2;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFriendlyNames() {
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = super.getFriendlyNames();
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirmwareVersion() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getFirmwareVersion();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() {
        this.lockSupport.sharedLock();
        try {
            String string = super.getSerialNumber();
            return string;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndpointReference(EndpointReference endpointReference) {
        if (endpointReference == null) {
            throw new IllegalArgumentException("endpoint reference must not be null");
        }
        this.lockSupport.exclusiveLock();
        try {
            this.copyDiscoveryDataIfRunning();
            this.discoveryData.setEndpointReference(endpointReference);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortTypes(QNameSet qNameSet) {
        this.lockSupport.exclusiveLock();
        try {
            if (qNameSet == null) {
                qNameSet = new QNameSet();
            }
            this.copyDiscoveryDataIfRunning();
            this.discoveryData.setTypes(qNameSet);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXAddressInfo(XAddressInfo xAddressInfo) {
        this.lockSupport.exclusiveLock();
        try {
            this.copyDiscoveryDataIfRunning();
            XAddressInfoSet xAddressInfoSet = this.discoveryData.getXAddressInfoSet();
            if (xAddressInfoSet == null) {
                xAddressInfoSet = new XAddressInfoSet();
                this.discoveryData.setXAddresInfoSet(xAddressInfoSet);
            }
            xAddressInfoSet.add(xAddressInfo);
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXAddressInfo(XAddressInfo xAddressInfo) {
        this.lockSupport.exclusiveLock();
        try {
            this.copyDiscoveryDataIfRunning();
            XAddressInfoSet xAddressInfoSet = this.discoveryData.getXAddressInfoSet();
            if (xAddressInfoSet != null && xAddressInfo != null) {
                xAddressInfoSet.remove(xAddressInfo);
            }
        }
        finally {
            this.lockSupport.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScopes(ScopeSet scopeSet) {
        this.lockSupport.exclusiveLock();
        try {
            this.copyDiscoveryDataIfRunning();
            this.discoveryData.setScopes(scopeSet);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManufacturer(String string, String string2) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.addManufacturerName(new LocalizedString(string2, string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManufacturerUrl(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.setManufacturerUrl(new URI(string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelName(String string, String string2) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.addModelName(new LocalizedString(string2, string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelNumber(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.setModelNumber(string);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelUrl(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.setModelUrl(new URI(string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresentationUrl(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata.setPresentationUrl(new URI(string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFriendlyName(String string, String string2) {
        this.lockSupport.exclusiveLock();
        try {
            this.deviceMetadata.addFriendlyName(new LocalizedString(string2, string));
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirmwareVersion(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.deviceMetadata.setFirmwareVersion(string);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialNumber(String string) {
        this.lockSupport.exclusiveLock();
        try {
            this.deviceMetadata.setSerialNumber(string);
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    public void addService(LocalService localService) {
        try {
            this.addService(localService, true);
        }
        catch (IOException iOException) {
            Log.error("Oh shit! I got an exception while adding a service. Shit should NEVER happen here!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(LocalService localService, boolean bl) throws IOException {
        this.lockSupport.exclusiveLock();
        try {
            localService.setParentDevice(this);
            this.services.add(localService);
            if (this.isRunning() && bl) {
                localService.start();
            }
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    public void removeService(LocalService localService) {
        try {
            this.removeService(localService, false);
        }
        catch (IOException iOException) {
            Log.error("Oh shit! I got an exception while adding a service. Shit should NEVER happen here!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(LocalService localService, boolean bl) throws IOException {
        this.lockSupport.exclusiveLock();
        try {
            this.services.remove(localService);
            if (localService.isRunning() && bl) {
                localService.stop();
            }
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                if (this.isRunning()) {
                    this.deviceUpdated();
                } else {
                    this.changed = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceMetadata(ThisDeviceMData thisDeviceMData) {
        this.lockSupport.exclusiveLock();
        try {
            this.deviceMetadata = thisDeviceMData;
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadataVersion(long l) {
        this.lockSupport.exclusiveLock();
        try {
            this.copyDiscoveryDataIfRunning();
            this.discoveryData.setMetadataVersion(l);
            this.isMetadataVersionSet = true;
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelMetadata(ThisModelMData thisModelMData) {
        this.lockSupport.exclusiveLock();
        try {
            this.modelMetadata = thisModelMData;
            this.changed = true;
        }
        finally {
            if (this.lockSupport.releaseExclusiveLock()) {
                this.deviceUpdated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThisDeviceMData getDeviceMetadata() {
        this.lockSupport.sharedLock();
        try {
            ThisDeviceMData thisDeviceMData = this.deviceMetadata;
            return thisDeviceMData;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMetadataVersion() {
        this.lockSupport.sharedLock();
        try {
            long l = this.discoveryData.getMetadataVersion();
            return l;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThisModelMData getModelMetadata() {
        this.lockSupport.sharedLock();
        try {
            ThisModelMData thisModelMData = this.modelMetadata;
            return thisModelMData;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    public Iterator getServices() {
        return new ReadOnlyIterator(this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getServiceReferences() {
        this.lockSupport.sharedLock();
        try {
            HashSet hashSet = new HashSet(this.services.size());
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ((DataStructure)hashSet).add(service.getServiceReference());
            }
            iterator = new ReadOnlyIterator(hashSet);
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    public Iterator getServiceReferences(QNameSet qNameSet) {
        HashSet hashSet = new HashSet();
        this.addServiceReferences(hashSet, qNameSet);
        return new ReadOnlyIterator(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceReferences(DataStructure dataStructure, QNameSet qNameSet) {
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                if (!qNameSet.isContainedBy(service.getPortTypes())) continue;
                dataStructure.add(service.getServiceReference());
            }
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getServiceReference(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = uRI.toString();
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                if (!string.equals(service.getServiceId().toString())) continue;
                ServiceReference serviceReference = service.getServiceReference();
                return serviceReference;
            }
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getServiceReference(EndpointReference endpointReference) {
        if (endpointReference == null) {
            return null;
        }
        this.lockSupport.sharedLock();
        try {
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                Iterator iterator2 = service.getEprInfos();
                while (iterator2.hasNext()) {
                    EprInfo eprInfo = (EprInfo)iterator2.next();
                    if (!endpointReference.equals(eprInfo.getEndpointReference())) continue;
                    ServiceReference serviceReference = service.getServiceReference();
                    return serviceReference;
                }
            }
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getXAddressInfos() {
        this.lockSupport.sharedLock();
        try {
            XAddressInfoSet xAddressInfoSet = this.discoveryData.getXAddressInfoSet();
            Iterator iterator = xAddressInfoSet == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(xAddressInfoSet.iterator());
            return iterator;
        }
        finally {
            this.lockSupport.releaseSharedLock();
        }
    }

    public DiscoveryData getDiscoveryData() {
        return this.discoveryData;
    }

    public boolean isUsingDefaultDiscoveryDomains() {
        return this.outputDiscoveryDomains.size() == 0;
    }

    public void addOutputDiscoveryDomain(ProtocolDomain protocolDomain) {
        if (protocolDomain == null) {
            return;
        }
        this.outputDiscoveryDomains.add(protocolDomain);
    }

    public void removeOutputDiscoveryDomain(ProtocolDomain protocolDomain) {
        this.outputDiscoveryDomains.remove(protocolDomain);
    }

    public DeviceProperties getDeviceProperties() {
        return this.deviceProp;
    }

    public int getConfigurationID() {
        return this.configurationId;
    }

    public boolean deviceMatches(QNameSet qNameSet, ProbeScopeSet probeScopeSet) {
        QNameSet qNameSet2 = this.discoveryData.getTypes();
        if (qNameSet == null || qNameSet.isEmpty() || qNameSet2 != null && qNameSet2.containsAll(qNameSet)) {
            ScopeSet scopeSet;
            return probeScopeSet == null || probeScopeSet.isEmpty() || (scopeSet = this.discoveryData.getScopes()) != null && !scopeSet.isEmpty() && scopeSet.containsAll(probeScopeSet);
        }
        return false;
    }

    private void copyDiscoveryDataIfRunning() {
        if (this.running && !this.discoveryDataChanged) {
            this.discoveryData = new DiscoveryData(this.discoveryData);
            this.myDeviceRef.setDiscoveryData(this.discoveryData);
            this.discoveryDataChanged = true;
        }
    }

    private HelloMessage createHelloMessage() {
        DiscoveryData discoveryData = new DiscoveryData(this.discoveryData);
        QName[] qNameArray = QNameSet.sortPrioritiesAsArray(discoveryData.getTypes());
        if (qNameArray != null) {
            int n = Math.min(qNameArray.length, 10);
            QNameSet qNameSet = new QNameSet(n);
            for (int i = 0; i < n; ++i) {
                qNameSet.add(qNameArray[i]);
            }
            discoveryData.setTypes(qNameSet);
        } else {
            Log.warn("Sending wsd:Hello message without any types (e.g DPWS)! Maybe nobody will accept this message, set correct types!");
        }
        HelloMessage helloMessage = new HelloMessage(discoveryData, CommunicationManager.ID_NULL);
        helloMessage.getHeader().setAppSequence(this.appSequencer.getNext());
        if (this.isSecure()) {
            helloMessage.setSecure(true);
            helloMessage.setCertificate(this.getCertificate());
            helloMessage.setPrivateKey(this.getPrivateKey());
        }
        return helloMessage;
    }

    private DataStructure getOutputDiscoveryDomains() {
        if (this.isUsingDefaultDiscoveryDomains()) {
            return Discovery.getDefaultOutputDomains();
        }
        return this.outputDiscoveryDomains;
    }

    public void setDiscoveryProxy(boolean bl) {
        this.isDiscoveryProxy = bl;
    }

    public boolean isDiscoveryProxy() {
        return this.isDiscoveryProxy;
    }

    public void setDefaultNamespace(String string) {
        this.namespace = string;
    }

    public String getDefaultNamespace() {
        return this.namespace;
    }

    public boolean isValid() {
        return true;
    }

    public void invalidate() {
    }

    public HTTPGroup getGroup() {
        return this.userGroup;
    }

    public void addUser(HTTPUser hTTPUser) {
        if (this.userGroup == null) {
            this.userGroup = new HTTPGroup();
        }
        this.userGroup.addUser(hTTPUser);
    }

    public void addGroup(HTTPGroup hTTPGroup) {
        if (this.userGroup == null) {
            this.userGroup = hTTPGroup;
        }
    }

    public String readCustomizeMData() {
        return this.myDeviceRef.getCustomMData();
    }

    public void writeCustomizeMData(HashMap hashMap) {
        hasCustomizeMData = true;
        this.mdata = hashMap;
        Iterator iterator = this.mdata.keySet().iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            Object object = this.mdata.get(qName);
            CustomizeMData.getInstance().addNewElement(qName, object);
        }
    }

    public boolean hasCustomizeMData() {
        return this.readCustomizeMData() != null;
    }

    public class AppSequenceManager {
        private long instanceId = 0L;
        private long messageNumber = 0L;

        public void reset() {
            this.instanceId = System.currentTimeMillis() / 1000L;
            this.messageNumber = 0L;
        }

        public AppSequence getNext() {
            ++this.messageNumber;
            return new AppSequence(this.instanceId, this.messageNumber);
        }
    }

    private final class DeviceMessageListener
    extends DefaultIncomingMessageListener {
        Device ownerDevice = null;

        private DeviceMessageListener(Device device) {
            this.ownerDevice = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetResponseMessage handle(GetMessage getMessage, ProtocolData protocolData) throws SOAPException {
            DefaultDevice.this.lockSupport.sharedLock();
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                GetResponseMessage getResponseMessage = new GetResponseMessage(protocolData.getCommunicationManagerId());
                getResponseMessage.setResponseTo(getMessage);
                getResponseMessage.setProtocolInfo(getMessage.getProtocolInfo());
                getResponseMessage.setThisModel(DefaultDevice.this.modelMetadata);
                getResponseMessage.setThisDevice(DefaultDevice.this.deviceMetadata);
                RelationshipMData relationshipMData = new RelationshipMData();
                HostMData hostMData = new HostMData();
                hostMData.setEndpointReference(DefaultDevice.this.getEndpointReference());
                hostMData.setTypes(DefaultDevice.this.discoveryData.getTypes());
                relationshipMData.setHost(hostMData);
                Iterator iterator = DefaultDevice.this.getServices();
                while (iterator.hasNext()) {
                    Object object5;
                    object4 = new HostedMData();
                    object3 = (Service)iterator.next();
                    object2 = object3.getEprInfos();
                    object = new EprInfoSet();
                    while (object2.hasNext()) {
                        object5 = (EprInfo)object2.next();
                        if (((XAddressInfo)object5).getXAddress() == null) continue;
                        ((EprInfoSet)object).add((EprInfo)object5);
                    }
                    ((HostedMData)object4).setEprInfoSet((EprInfoSet)object);
                    object5 = object3.getPortTypes();
                    QNameSet qNameSet = new QNameSet();
                    while (object5.hasNext()) {
                        QName qName = (QName)object5.next();
                        qNameSet.add(qName);
                    }
                    ((HostedMData)object4).setTypes(qNameSet);
                    ((HostedMData)object4).setServiceId(object3.getServiceId());
                    relationshipMData.addHosted((HostedMData)object4);
                }
                object4 = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId());
                object3 = object4.getCommunicationUtil();
                object2 = object3.getHelper(getMessage.getProtocolInfo().getVersion());
                getResponseMessage.addRelationship(relationshipMData, (ConstantsHelper)object2);
                if (hasCustomizeMData) {
                    getResponseMessage.addCustomizeMetaData(CustomizeMData.getInstance());
                }
                object = getResponseMessage;
                return object;
            }
            finally {
                DefaultDevice.this.lockSupport.releaseSharedLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProbeMatchesMessage handle(ProbeMessage probeMessage, ProtocolData protocolData) throws SOAPException {
            if (DefaultDevice.this.messageIdBuffer.containsOrEnqueue(probeMessage.getMessageId())) {
                if (Log.isDebug()) {
                    Log.debug("Discarding probe message! Already saw this one!", 2);
                }
                return null;
            }
            DefaultDevice.this.lockSupport.sharedLock();
            try {
                if (DefaultDevice.this.deviceMatches(probeMessage.getTypes(), probeMessage.getScopes())) {
                    Object object;
                    ScopeSet scopeSet;
                    QNameSet qNameSet;
                    ProbeMatchesMessage probeMatchesMessage = new ProbeMatchesMessage(protocolData.getCommunicationManagerId());
                    probeMatchesMessage.setResponseTo(probeMessage);
                    probeMatchesMessage.getHeader().setAppSequence(DefaultDevice.this.appSequencer.getNext());
                    probeMatchesMessage.setProtocolInfo(probeMessage.getProtocolInfo());
                    ProbeMatch probeMatch = new ProbeMatch();
                    probeMatch.setEndpointReference(DefaultDevice.this.getEndpointReference());
                    probeMatch.setMetadataVersion(DefaultDevice.this.getMetadataVersion());
                    if (DPWSFramework.hasModule(64) && this.ownerDevice.isSecure()) {
                        probeMatchesMessage.setSecure(true);
                        probeMatchesMessage.setPrivateKey(this.ownerDevice.getPrivateKey());
                        probeMatchesMessage.setCertificate(this.ownerDevice.getCertificate());
                    }
                    QNameSet qNameSet2 = DPWSFramework.getCommunicationManager(protocolData.getCommunicationManagerId()).getDeviceTypes();
                    if (probeMessage.isDirected()) {
                        qNameSet = DefaultDevice.this.discoveryData.getTypes();
                        if (qNameSet != null) {
                            qNameSet.addAll(qNameSet2);
                        } else {
                            qNameSet = new QNameSet(qNameSet2);
                        }
                        scopeSet = DefaultDevice.this.discoveryData.getScopes();
                    } else {
                        int n;
                        object = probeMessage.getTypes();
                        QName[] qNameArray = QNameSet.sortPrioritiesAsArray(DefaultDevice.this.discoveryData.getTypes());
                        qNameSet = new QNameSet(qNameSet2);
                        if (object != null) {
                            for (n = 0; n < qNameArray.length; ++n) {
                                if (!((QNameSet)object).contains(qNameArray[n])) continue;
                                qNameSet.add(qNameArray[n]);
                            }
                        }
                        for (n = 0; n < qNameArray.length && qNameSet.size() <= 10; ++n) {
                            qNameSet.add(qNameArray[n]);
                        }
                        scopeSet = new ProbeScopeSet();
                        ProbeScopeSet probeScopeSet = probeMessage.getScopes();
                        ScopeSet scopeSet2 = DefaultDevice.this.discoveryData.getScopes();
                        if (scopeSet2 != null && !scopeSet2.isEmpty()) {
                            int n2;
                            String[] stringArray = DefaultDevice.this.discoveryData.getScopes().getScopesAsStringArray();
                            if (probeScopeSet != null) {
                                for (n2 = 0; n2 < stringArray.length; ++n2) {
                                    if (!probeScopeSet.contains(stringArray[n2])) continue;
                                    scopeSet.addScope(stringArray[n2]);
                                }
                            }
                            for (n2 = 0; n2 < stringArray.length && scopeSet.size() <= 10; ++n2) {
                                scopeSet.addScope(stringArray[n2]);
                            }
                        }
                    }
                    probeMatch.setTypes(qNameSet);
                    probeMatch.setScopes(scopeSet);
                    probeMatch.setXAddresInfoSet(DefaultDevice.this.discoveryData.getXAddressInfoSet());
                    probeMatchesMessage.addProbeMatch(probeMatch);
                    object = probeMatchesMessage;
                    return object;
                }
                if (probeMessage.isDirected()) {
                    ProbeMatchesMessage probeMatchesMessage = new ProbeMatchesMessage(protocolData.getCommunicationManagerId());
                    probeMatchesMessage.setResponseTo(probeMessage);
                    probeMatchesMessage.setProtocolInfo(probeMessage.getProtocolInfo());
                    ProbeMatchesMessage probeMatchesMessage2 = probeMatchesMessage;
                    return probeMatchesMessage2;
                }
                ProbeMatchesMessage probeMatchesMessage = null;
                return probeMatchesMessage;
            }
            finally {
                DefaultDevice.this.lockSupport.releaseSharedLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolveMatchesMessage handle(ResolveMessage resolveMessage, ProtocolData protocolData) {
            DefaultDevice.this.lockSupport.sharedLock();
            try {
                if (resolveMessage.getEndpointReference() != null && resolveMessage.getEndpointReference().equals(DefaultDevice.this.getEndpointReference())) {
                    ResolveMatchesMessage resolveMatchesMessage = new ResolveMatchesMessage(protocolData.getCommunicationManagerId());
                    resolveMatchesMessage.setResponseTo(resolveMessage);
                    resolveMatchesMessage.getHeader().setAppSequence(DefaultDevice.this.appSequencer.getNext());
                    resolveMatchesMessage.setProtocolInfo(resolveMessage.getProtocolInfo());
                    ResolveMatch resolveMatch = new ResolveMatch();
                    resolveMatch.setEndpointReference(DefaultDevice.this.getEndpointReference());
                    resolveMatch.setMetadataVersion(DefaultDevice.this.getMetadataVersion());
                    resolveMatch.setTypes(DefaultDevice.this.discoveryData.getTypes());
                    resolveMatch.setScopes(DefaultDevice.this.discoveryData.getScopes());
                    resolveMatch.setXAddresInfoSet(DefaultDevice.this.discoveryData.getXAddressInfoSet());
                    resolveMatchesMessage.setResolveMatch(resolveMatch);
                    ResolveMatchesMessage resolveMatchesMessage2 = resolveMatchesMessage;
                    return resolveMatchesMessage2;
                }
                ResolveMatchesMessage resolveMatchesMessage = null;
                return resolveMatchesMessage;
            }
            finally {
                DefaultDevice.this.lockSupport.releaseSharedLock();
            }
        }
    }
}

