/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.constants.SOAPConstants;
import org.ws4d.java.constants.WS4DConstants;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.service.Fault;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.QName;

public class InvocationException
extends Exception {
    private static final long serialVersionUID = 6799847495814513813L;
    private static final String DECLARED_FAULT_REASON = "A declared fault occured during invocation: ";
    private final String action;
    private final QName code;
    private final QName subcode;
    private final DataStructure reason;
    private final ParameterValue detail;

    protected static DataStructure createReasonFromString(String string) {
        if (string == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(1);
        ((DataStructure)arrayList).add(new LocalizedString(string, null));
        return arrayList;
    }

    public InvocationException(Fault fault) {
        this(fault, null);
    }

    public InvocationException(Fault fault, ParameterValue parameterValue) {
        this(fault, DECLARED_FAULT_REASON + fault.getName(), parameterValue);
    }

    public InvocationException(Fault fault, String string, ParameterValue parameterValue) {
        this(fault.getAction(), SOAPConstants.SOAP_FAULT_SENDER, WS4DConstants.WS4D_FAULT_DECLARED, InvocationException.createReasonFromString(string), parameterValue);
    }

    public InvocationException(FaultMessage faultMessage) {
        this(faultMessage.getAction().toString(), faultMessage.getCode(), faultMessage.getSubcode(), faultMessage.getReason(), faultMessage.getDetail());
    }

    protected InvocationException(String string, QName qName, QName qName2, DataStructure dataStructure, ParameterValue parameterValue) {
        this.action = string;
        this.code = qName;
        this.subcode = qName2;
        this.reason = dataStructure;
        this.detail = parameterValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": [ action=").append(this.action);
        stringBuffer.append(", code=").append(this.code);
        stringBuffer.append(", subcode=").append(this.subcode);
        stringBuffer.append(", reason=").append(this.reason);
        stringBuffer.append(", detail=").append(this.detail);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.toString();
    }

    public String getAction() {
        return this.action;
    }

    public QName getCode() {
        return this.code;
    }

    public QName getSubcode() {
        return this.subcode;
    }

    public DataStructure getReason() {
        return this.reason;
    }

    public ParameterValue getDetail() {
        return this.detail;
    }
}

