/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.dispatch.MissingMetadataException;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.dispatch.ServiceReferenceInternal;
import org.ws4d.java.eventing.ClientSubscription;
import org.ws4d.java.eventing.ClientSubscriptionInternal;
import org.ws4d.java.eventing.EventSink;
import org.ws4d.java.eventing.EventingException;
import org.ws4d.java.eventing.EventingFactory;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.eventing.EventingResponseMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.ServiceCommons;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.Delivery;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.EprInfo;
import org.ws4d.java.types.Filter;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPortType;
import org.ws4d.java.wsdl.WSDLRepository;

public class ProxyService
extends ServiceCommons {
    private ServiceReference serviceReference;

    ProxyService() {
    }

    public ProxyService(ServiceReference serviceReference) throws MissingMetadataException {
        try {
            this.initialize(serviceReference);
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    protected void initialize(ServiceReference serviceReference) throws InstantiationException, MissingMetadataException {
        if (this.serviceReference != null) {
            throw new InstantiationException("ProxyService already initialized!");
        }
        this.serviceReference = serviceReference;
        this.setSecure(serviceReference.isSecureService());
        if (this.loadFromEmbeddedWSDLs(this.getPortTypes())) {
            return;
        }
        if (this.loadFromMetadataLocations(this.getPortTypes())) {
            return;
        }
        if (this.loadFromRepository(this.getPortTypes())) {
            return;
        }
        throw new MissingMetadataException("Unable to resolve all port types of service");
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public DeviceReference getParentDeviceReference() {
        return this.serviceReference.getParentDeviceRef();
    }

    public boolean isRemote() {
        return true;
    }

    public URI getServiceId() {
        return this.serviceReference.getServiceId();
    }

    public Iterator getEprInfos() {
        return this.serviceReference.getEprInfos();
    }

    public Iterator getPortTypes() {
        return this.serviceReference.getPortTypes();
    }

    public int getPortTypeCount() {
        return this.portTypes.size();
    }

    public void appendPortTypes(QNameSet qNameSet) throws MissingMetadataException {
        if (this.loadFromMetadataLocations(qNameSet.iterator())) {
            return;
        }
        if (!this.loadFromRepository(qNameSet.iterator())) {
            throw new MissingMetadataException("Unable to resolve some port types of service: " + qNameSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSubscription subscribe(EventSink eventSink, String string, URISet uRISet, long l) throws EventingException, TimeoutException {
        EventingFactory eventingFactory;
        SubscribeResponseMessage subscribeResponseMessage;
        if (!eventSink.isOpen()) {
            Log.error("Cannot subscribe, event sink is not open");
            throw new EventingException("EventSink not open");
        }
        ServiceReferenceInternal serviceReferenceInternal = (ServiceReferenceInternal)this.getServiceReference();
        XAddressInfo xAddressInfo = serviceReferenceInternal.getPreferredXAddressInfo();
        SubscribeMessage subscribeMessage = new SubscribeMessage(xAddressInfo.getComManId());
        subscribeMessage.getHeader().setEndpointReference(((EprInfo)this.getEprInfos().next()).getEndpointReference());
        subscribeMessage.setTargetXAddressInfo(xAddressInfo);
        subscribeMessage.setProtocolInfo(xAddressInfo.getProtocolInfo());
        ReferenceParametersMData referenceParametersMData = new ReferenceParametersMData();
        referenceParametersMData.setWseIdentifier(string);
        EndpointReference endpointReference = new EndpointReference(URI.EMPTY_URI, referenceParametersMData);
        Delivery delivery = new Delivery(null, endpointReference);
        subscribeMessage.setDelivery(delivery);
        subscribeMessage.setEventSink(eventSink);
        if (l != 0L) {
            subscribeMessage.setExpires(SchemaUtil.createDuration(l));
        }
        CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(xAddressInfo.getComManId());
        CommunicationUtil communicationUtil = communicationManager.getCommunicationUtil();
        ConstantsHelper constantsHelper = null;
        constantsHelper = subscribeMessage.getProtocolInfo() == null ? communicationUtil.getHelper(communicationManager.getProtocolInfo().getVersion()) : communicationUtil.getHelper(subscribeMessage.getProtocolInfo().getVersion());
        Filter filter = new Filter(constantsHelper.getDPWSUriFilterEeventingAction(), uRISet);
        subscribeMessage.setFilter(filter);
        ProxyServiceCallback proxyServiceCallback = new ProxyServiceCallback(xAddressInfo);
        OutDispatcher.getInstance().send(subscribeMessage, xAddressInfo, (ResponseCallback)proxyServiceCallback);
        Object object = proxyServiceCallback;
        synchronized (object) {
            while (proxyServiceCallback.pending) {
                try {
                    proxyServiceCallback.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (proxyServiceCallback.exception != null) {
            throw proxyServiceCallback.exception;
        }
        object = null;
        if (proxyServiceCallback.msg != null) {
            subscribeResponseMessage = (SubscribeResponseMessage)proxyServiceCallback.msg;
            eventingFactory = null;
            try {
                eventingFactory = DPWSFramework.getEventingFactory();
            }
            catch (IOException iOException) {
                throw new EventingException("Cannot subscribe for events Eventing support not found.");
            }
        } else {
            if (proxyServiceCallback.fault != null) {
                throw new EventingException(proxyServiceCallback.fault);
            }
            throw new TimeoutException("Subscribe timeout");
        }
        object = eventingFactory.createClientSubscription(eventSink, string, subscribeResponseMessage.getSubscriptionManager(), proxyServiceCallback.protocolData.getCommunicationManagerId(), SchemaUtil.parseDuration(subscribeResponseMessage.getExpires()), this.serviceReference);
        object.getSubscriptionManagerAddressInfo().setProtocolInfo(proxyServiceCallback.protocolData.getProtocolInfo());
        eventSink.addSubscription(string, (ClientSubscription)object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ClientSubscription clientSubscription) throws EventingException, TimeoutException {
        if (clientSubscription == null) {
            Log.error("Cannot unsubscribe, subscription is null");
            throw new EventingException("Subscription is null");
        }
        ((ClientSubscriptionInternal)clientSubscription).dispose();
        EprInfo eprInfo = clientSubscription.getSubscriptionManagerAddressInfo();
        UnsubscribeMessage unsubscribeMessage = new UnsubscribeMessage(eprInfo.getComManId());
        unsubscribeMessage.setTargetXAddressInfo(eprInfo);
        SOAPHeader sOAPHeader = unsubscribeMessage.getHeader();
        sOAPHeader.setEndpointReference(eprInfo.getEndpointReference());
        unsubscribeMessage.setProtocolInfo(eprInfo.getProtocolInfo());
        ProxyServiceCallback proxyServiceCallback = new ProxyServiceCallback(eprInfo);
        OutDispatcher.getInstance().send(unsubscribeMessage, (XAddressInfo)eprInfo, (ResponseCallback)proxyServiceCallback);
        ProxyServiceCallback proxyServiceCallback2 = proxyServiceCallback;
        synchronized (proxyServiceCallback2) {
            while (proxyServiceCallback.pending) {
                try {
                    proxyServiceCallback.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (proxyServiceCallback.exception != null) {
            throw proxyServiceCallback.exception;
        }
        if (proxyServiceCallback.msg != null) {
            return;
        }
        if (proxyServiceCallback.fault != null) {
            throw new EventingException(proxyServiceCallback.fault);
        }
        throw new TimeoutException("Unsubscribe timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renew(ClientSubscription clientSubscription, long l) throws EventingException, TimeoutException {
        if (clientSubscription == null) {
            Log.error("Cannot renew, subscription is null");
            throw new EventingException("Subscription is null");
        }
        if (!clientSubscription.getEventSink().isOpen()) {
            Log.error("Cannot renew, event sink is not open");
            throw new EventingException("EventSink not open");
        }
        EprInfo eprInfo = clientSubscription.getSubscriptionManagerAddressInfo();
        RenewMessage renewMessage = new RenewMessage(eprInfo.getComManId());
        renewMessage.setTargetXAddressInfo(eprInfo);
        renewMessage.getHeader().setEndpointReference(eprInfo.getEndpointReference());
        if (l != 0L) {
            renewMessage.setExpires(SchemaUtil.createDuration(l));
        }
        renewMessage.setProtocolInfo(((ServiceReferenceInternal)this.getServiceReference()).getPreferredXAddressInfo().getProtocolInfo());
        ProxyServiceCallback proxyServiceCallback = new ProxyServiceCallback(eprInfo);
        OutDispatcher.getInstance().send(renewMessage, (XAddressInfo)eprInfo, (ResponseCallback)proxyServiceCallback);
        Object object = proxyServiceCallback;
        synchronized (object) {
            while (proxyServiceCallback.pending) {
                try {
                    proxyServiceCallback.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (proxyServiceCallback.exception != null) {
            throw proxyServiceCallback.exception;
        }
        if (proxyServiceCallback.msg != null) {
            object = (RenewResponseMessage)proxyServiceCallback.msg;
            long l2 = SchemaUtil.parseDuration(((EventingResponseMessage)object).getExpires());
            ((ClientSubscriptionInternal)clientSubscription).renewInternal(l2);
            return l2;
        }
        if (proxyServiceCallback.fault != null) {
            throw new EventingException(proxyServiceCallback.fault);
        }
        throw new TimeoutException("Renew timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStatus(ClientSubscription clientSubscription) throws EventingException, TimeoutException {
        if (clientSubscription == null) {
            Log.error("Cannot get status, subscription is null");
            throw new EventingException("Subscription is null");
        }
        if (!clientSubscription.getEventSink().isOpen()) {
            Log.error("Cannot get status, event sink is not open");
            throw new EventingException("EventSink not open");
        }
        EprInfo eprInfo = clientSubscription.getSubscriptionManagerAddressInfo();
        GetStatusMessage getStatusMessage = new GetStatusMessage(eprInfo.getComManId());
        getStatusMessage.setTargetXAddressInfo(eprInfo);
        getStatusMessage.getHeader().setEndpointReference(eprInfo.getEndpointReference());
        getStatusMessage.setProtocolInfo(((ServiceReferenceInternal)this.getServiceReference()).getPreferredXAddressInfo().getProtocolInfo());
        ProxyServiceCallback proxyServiceCallback = new ProxyServiceCallback(eprInfo);
        OutDispatcher.getInstance().send(getStatusMessage, (XAddressInfo)eprInfo, (ResponseCallback)proxyServiceCallback);
        Object object = proxyServiceCallback;
        synchronized (object) {
            while (proxyServiceCallback.pending) {
                try {
                    proxyServiceCallback.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (proxyServiceCallback.exception != null) {
            throw proxyServiceCallback.exception;
        }
        if (proxyServiceCallback.msg != null) {
            object = (GetStatusResponseMessage)proxyServiceCallback.msg;
            return SchemaUtil.parseDuration(((EventingResponseMessage)object).getExpires());
        }
        if (proxyServiceCallback.fault != null) {
            throw new EventingException(proxyServiceCallback.fault);
        }
        throw new TimeoutException("GetStatus timeout");
    }

    public WSDL getDescription(String string) {
        return this.getExistingDescription(string);
    }

    private boolean loadFromEmbeddedWSDLs(Iterator iterator) {
        Object object;
        Iterator iterator2 = this.serviceReference.getWSDLs();
        if (!iterator2.hasNext()) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Object object2 = iterator;
        while (object2.hasNext()) {
            object = (QName)object2.next();
            ((DataStructure)hashSet).add(object);
        }
        while (iterator2.hasNext()) {
            object2 = (WSDL)iterator2.next();
            this.wsdls.put(((WSDL)object2).getTargetNamespace(), object2);
            object = ((DataStructure)hashSet).iterator();
            while (object.hasNext()) {
                QName qName = (QName)object.next();
                WSDLPortType wSDLPortType = ((WSDL)object2).getPortType(qName);
                if (wSDLPortType == null) continue;
                this.processWSDLPortType(wSDLPortType);
                object.remove();
            }
        }
        return ((DataStructure)hashSet).isEmpty();
    }

    private boolean loadFromRepository(Iterator iterator) {
        if (FrameworkProperties.getInstance().isBypassWsdlRepository()) {
            if (Log.isDebug()) {
                Log.debug("Bypassing WSDL repository due to configuration property.");
            }
            return false;
        }
        boolean bl = true;
        WSDLRepository wSDLRepository = WSDLRepository.getInstance();
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            WSDL wSDL;
            QName qName = (QName)iterator2.next();
            if (this.portTypes.containsKey(qName)) continue;
            WSDLPortType wSDLPortType = null;
            Object object = this.wsdls.values().iterator();
            while (object.hasNext() && (wSDLPortType = (wSDL = (WSDL)object.next()).getPortType(qName)) == null) {
            }
            if (wSDLPortType == null) {
                object = wSDLRepository.getWsdl(qName);
                if (object == null) {
                    bl = false;
                    if (!Log.isDebug()) continue;
                    Log.debug("Unable to find a WSDL within local repository for port type " + qName, 4);
                    continue;
                }
                this.wsdls.put(((WSDL)object).getTargetNamespace(), object);
                wSDLPortType = ((WSDL)object).getPortType(qName);
            }
            this.processWSDLPortType(wSDLPortType);
        }
        return bl;
    }

    private boolean loadFromMetadataLocations(Iterator iterator) throws MissingMetadataException {
        Object object;
        Iterator iterator2 = this.serviceReference.getMetadataLocations();
        HashSet hashSet = new HashSet();
        Object object2 = iterator;
        while (object2.hasNext()) {
            object = (QName)object2.next();
            if (this.portTypes.containsKey(object)) continue;
            ((DataStructure)hashSet).add(object);
        }
        while (iterator2.hasNext()) {
            if (((DataStructure)hashSet).isEmpty()) {
                return true;
            }
            object2 = (URI)iterator2.next();
            try {
                object = WSDLRepository.getInstance().getWSDL(((URI)object2).toString());
                if (object == null) {
                    object = WSDLRepository.loadWsdl((URI)object2);
                } else if (Log.isDebug()) {
                    Log.debug("WSDL from metadata location found within local repository: " + object2);
                }
                this.wsdls.put(((WSDL)object).getTargetNamespace(), object);
                Iterator iterator3 = ((DataStructure)hashSet).iterator();
                while (iterator3.hasNext()) {
                    QName qName = (QName)iterator3.next();
                    WSDLPortType wSDLPortType = ((WSDL)object).getPortType(qName);
                    if (wSDLPortType == null) continue;
                    this.processWSDLPortType(wSDLPortType);
                    iterator3.remove();
                }
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
                throw new RuntimeException(iOException.getMessage());
            }
        }
        if (!((DataStructure)hashSet).isEmpty()) {
            Log.warn("Unable to resolve some port types of service from available metadata locations: " + hashSet);
            return false;
        }
        return true;
    }

    protected Operation createOperation(WSDLOperation wSDLOperation) {
        return new Operation(wSDLOperation){

            public ParameterValue invoke(ParameterValue parameterValue) throws InvocationException, TimeoutException {
                return ProxyService.this.dispatchInvoke(this, parameterValue);
            }
        };
    }

    protected ParameterValue dispatchInvoke(Operation operation, ParameterValue parameterValue) throws InvocationException, TimeoutException {
        InvokeMessage invokeMessage = new InvokeMessage(operation.getInputAction(), CommunicationManager.ID_NULL);
        return this.dispatchInvoke(invokeMessage, operation, parameterValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParameterValue dispatchInvoke(InvokeMessage invokeMessage, Operation operation, ParameterValue parameterValue) throws InvocationException, TimeoutException {
        invokeMessage.getHeader().setEndpointReference(((EprInfo)this.getEprInfos().next()).getEndpointReference());
        ServiceReferenceInternal serviceReferenceInternal = (ServiceReferenceInternal)this.getServiceReference();
        XAddressInfo xAddressInfo = serviceReferenceInternal.getPreferredXAddressInfo();
        invokeMessage.setTargetXAddressInfo(xAddressInfo);
        invokeMessage.setContent(parameterValue);
        invokeMessage.setProtocolInfo(xAddressInfo.getProtocolInfo());
        ProxyServiceCallback proxyServiceCallback = new ProxyServiceCallback(xAddressInfo, operation);
        OutDispatcher.getInstance().send(invokeMessage, xAddressInfo, (ResponseCallback)proxyServiceCallback);
        if (operation.isOneWay()) {
            return null;
        }
        Object object = proxyServiceCallback;
        synchronized (object) {
            while (proxyServiceCallback.pending) {
                try {
                    proxyServiceCallback.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (proxyServiceCallback.exception != null) {
            throw proxyServiceCallback.exception;
        }
        if (proxyServiceCallback.msg != null) {
            object = (InvokeMessage)proxyServiceCallback.msg;
            return ((InvokeMessage)object).getContent();
        }
        if (proxyServiceCallback.fault != null) {
            object = proxyServiceCallback.fault;
            throw new InvocationException((FaultMessage)object);
        }
        throw new TimeoutException("Invocation time out");
    }

    private class ProxyServiceCallback
    extends DefaultResponseCallback {
        Message msg;
        FaultMessage fault;
        TimeoutException exception;
        volatile boolean pending;
        ProtocolData protocolData;
        Operation op;

        ProxyServiceCallback(XAddressInfo xAddressInfo) {
            super(xAddressInfo);
            this.msg = null;
            this.fault = null;
            this.exception = null;
            this.pending = true;
            this.op = null;
        }

        ProxyServiceCallback(XAddressInfo xAddressInfo, Operation operation) {
            super(xAddressInfo);
            this.msg = null;
            this.fault = null;
            this.exception = null;
            this.pending = true;
            this.op = null;
            this.op = operation;
        }

        public void handle(Message message, SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
            this.releaseMessageSynchronization(subscribeResponseMessage, protocolData);
        }

        public void handle(Message message, InvokeMessage invokeMessage, ProtocolData protocolData) {
            this.releaseMessageSynchronization(invokeMessage, protocolData);
        }

        public void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
            if (Log.isDebug()) {
                Log.printStackTrace(exception);
            }
            this.exception = new TimeoutException("Malformed response: " + exception);
            this.handleTimeout(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
            ProxyServiceCallback proxyServiceCallback = this;
            synchronized (proxyServiceCallback) {
                this.pending = false;
                this.fault = faultMessage;
                this.protocolData = protocolData;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
            if (Log.isDebug()) {
                Log.printStackTrace(exception);
            }
            ProxyServiceCallback proxyServiceCallback = this;
            synchronized (proxyServiceCallback) {
                this.exception = new TimeoutException("Malformed response: " + exception);
                this.pending = false;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleTimeout(Message message) {
            try {
                ServiceReferenceInternal serviceReferenceInternal = (ServiceReferenceInternal)ProxyService.this.getServiceReference();
                XAddressInfo xAddressInfo = serviceReferenceInternal.getNextXAddressInfoAfterFailure(message.getTargetAddress());
                message.setTargetXAddressInfo(xAddressInfo);
                switch (message.getType()) {
                    case 400: {
                        OutDispatcher.getInstance().send((InvokeMessage)message, xAddressInfo, (ResponseCallback)this);
                        break;
                    }
                    case 301: {
                        OutDispatcher.getInstance().send((SubscribeMessage)message, xAddressInfo, (ResponseCallback)this);
                        break;
                    }
                    case 307: {
                        OutDispatcher.getInstance().send((GetStatusMessage)message, xAddressInfo, (ResponseCallback)this);
                        break;
                    }
                    case 303: {
                        OutDispatcher.getInstance().send((RenewMessage)message, xAddressInfo, (ResponseCallback)this);
                        break;
                    }
                    case 305: {
                        OutDispatcher.getInstance().send((UnsubscribeMessage)message, xAddressInfo, (ResponseCallback)this);
                    }
                }
            }
            catch (Throwable throwable) {
                ProxyServiceCallback proxyServiceCallback = this;
                synchronized (proxyServiceCallback) {
                    this.exception = new TimeoutException("Exception occured during transmission exception processing: " + throwable);
                    this.pending = false;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseMessageSynchronization(Message message, ProtocolData protocolData) {
            ProxyServiceCallback proxyServiceCallback = this;
            synchronized (proxyServiceCallback) {
                this.pending = false;
                this.msg = message;
                this.protocolData = protocolData;
                this.notifyAll();
            }
        }

        public void handle(Message message, RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
            this.releaseMessageSynchronization(renewResponseMessage, protocolData);
        }

        public void handle(Message message, UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
            this.releaseMessageSynchronization(unsubscribeResponseMessage, protocolData);
        }

        public void handle(Message message, GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
            this.releaseMessageSynchronization(getStatusResponseMessage, protocolData);
        }

        public OperationDescription getOperation() {
            return this.op;
        }
    }
}

