/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.UnknownDataContainer;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.types.XAddressInfoSet;
import org.ws4d.java.util.StringUtil;

public class DiscoveryData
extends UnknownDataContainer {
    public static final long UNKNOWN_METADATA_VERSION = -1L;
    private EndpointReference endpointReference;
    private QNameSet types;
    private ScopeSet scopes;
    private XAddressInfoSet xAdrInfos;
    private long metadataVersion;

    public DiscoveryData() {
        this((EndpointReference)null);
    }

    public DiscoveryData(EndpointReference endpointReference) {
        this(endpointReference, -1L);
    }

    public DiscoveryData(EndpointReference endpointReference, long l) {
        this(endpointReference, l, null);
    }

    public DiscoveryData(EndpointReference endpointReference, long l, XAddressInfoSet xAddressInfoSet) {
        this.endpointReference = endpointReference;
        this.metadataVersion = l;
        this.xAdrInfos = xAddressInfoSet;
    }

    public DiscoveryData(DiscoveryData discoveryData) {
        this.metadataVersion = discoveryData.metadataVersion;
        this.endpointReference = discoveryData.endpointReference;
        if (discoveryData.getTypes() != null && !discoveryData.getTypes().isEmpty()) {
            this.setTypes(new QNameSet(discoveryData.types));
        }
        if (discoveryData.getScopes() != null && !discoveryData.getScopes().isEmpty()) {
            this.setScopes(new ScopeSet(discoveryData.scopes));
        }
        this.setXAddresInfoSet(new XAddressInfoSet(discoveryData.xAdrInfos));
    }

    public boolean update(DiscoveryData discoveryData) {
        if (discoveryData == this || discoveryData == null) {
            return false;
        }
        if (this.metadataVersion < discoveryData.metadataVersion) {
            boolean bl = this.metadataVersion != -1L;
            this.metadataVersion = discoveryData.metadataVersion;
            this.types = discoveryData.types;
            this.scopes = discoveryData.scopes;
            this.xAdrInfos = discoveryData.xAdrInfos;
            return bl;
        }
        if (this.metadataVersion == discoveryData.metadataVersion) {
            Object object;
            if (this.types != null) {
                object = new QNameSet(this.types);
                ((QNameSet)object).addAll(discoveryData.types);
                this.types = object;
            } else {
                this.types = discoveryData.types;
            }
            if (this.xAdrInfos != null) {
                object = new XAddressInfoSet(this.xAdrInfos);
                Iterator iterator = discoveryData.xAdrInfos.iterator();
                while (iterator.hasNext()) {
                    XAddressInfo xAddressInfo = (XAddressInfo)iterator.next();
                    XAddressInfo xAddressInfo2 = ((XAddressInfoSet)object).get(xAddressInfo);
                    if (xAddressInfo2 != null) {
                        xAddressInfo2.mergeProtocolInfo(xAddressInfo);
                        continue;
                    }
                    ((XAddressInfoSet)object).add(xAddressInfo);
                }
                this.xAdrInfos = object;
            } else {
                this.xAdrInfos = discoveryData.xAdrInfos;
            }
            if (this.scopes != null) {
                object = new ScopeSet(this.scopes);
                ((ScopeSet)object).addAll(discoveryData.scopes);
                this.scopes = object;
            } else {
                this.scopes = discoveryData.scopes;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(StringUtil.formatClassName(this.getClass()));
        stringBuffer.append(" [ endpointReference=").append(this.endpointReference);
        stringBuffer.append(", types=").append(this.types);
        stringBuffer.append(", scopes=").append(this.scopes);
        stringBuffer.append(", xAddrs=").append(this.xAdrInfos);
        stringBuffer.append(", metadataVersion=").append(this.metadataVersion);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public EndpointReference getEndpointReference() {
        return this.endpointReference;
    }

    public long getMetadataVersion() {
        return this.metadataVersion;
    }

    public ScopeSet getScopes() {
        return this.scopes;
    }

    public QNameSet getTypes() {
        return this.types;
    }

    public XAddressInfoSet getXAddressInfoSet() {
        return this.xAdrInfos;
    }

    public void setEndpointReference(EndpointReference endpointReference) {
        this.endpointReference = endpointReference;
    }

    public void setMetadataVersion(long l) {
        this.metadataVersion = l;
    }

    public void setTypes(QNameSet qNameSet) {
        this.types = qNameSet;
    }

    public void addTypes(QNameSet qNameSet) {
        if (this.types != null) {
            this.types.addAll(qNameSet);
        } else {
            this.types = qNameSet;
        }
    }

    public void setScopes(ScopeSet scopeSet) {
        this.scopes = scopeSet;
    }

    public void setXAddresInfoSet(XAddressInfoSet xAddressInfoSet) {
        this.xAdrInfos = xAddressInfoSet;
    }
}

