/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;

public class InternetMediaType {
    private static final InternetMediaType TYPE_SOAPXML = new InternetMediaType("application", "soap+xml");
    private static final InternetMediaType TYPE_XML = new InternetMediaType("application", "xml");
    private static final InternetMediaType TYPE_APPLICATION_OCTET_STREAM = new InternetMediaType("application", "octet-stream");
    private static final InternetMediaType TYPE_APPLICATION_XOPXML = new InternetMediaType("application", "xop+xml");
    private static final InternetMediaType TYPE_MULTIPART_RELATED = new InternetMediaType("multipart", "related");
    private static final InternetMediaType TYPE_MULTIPART_FORMDATA = new InternetMediaType("multipart", "form-data");
    private static final InternetMediaType TYPE_APPLICATION_XWWW_FORM_URL_ENCODED = new InternetMediaType("application", "x-www-form-urlencoded");
    private static final InternetMediaType TYPE_IMAGE_JPEG = new InternetMediaType("image", "jpeg");
    private static final InternetMediaType TYPE_TEXT_HTML = new InternetMediaType("text", "html");
    private static final InternetMediaType TYPE_TEXT_PLAIN = new InternetMediaType("text", "plain");
    private String type;
    private String subtype;
    private HashMap parameters;

    public static final InternetMediaType getSOAPXML() {
        return TYPE_SOAPXML;
    }

    public static final InternetMediaType getXML() {
        return TYPE_XML;
    }

    public static final InternetMediaType getApplicationOctetStream() {
        return TYPE_APPLICATION_OCTET_STREAM;
    }

    public static final InternetMediaType getApplicationXOPXML() {
        return TYPE_APPLICATION_XOPXML;
    }

    public static final InternetMediaType getMultipartRelated() {
        return TYPE_MULTIPART_RELATED;
    }

    public static final InternetMediaType getMultipartFormdata() {
        return TYPE_MULTIPART_FORMDATA;
    }

    public static final InternetMediaType getApplicationXWWWFormUrlEncoded() {
        return TYPE_APPLICATION_XWWW_FORM_URL_ENCODED;
    }

    public static final InternetMediaType getImageJPEG() {
        return TYPE_IMAGE_JPEG;
    }

    public static final InternetMediaType getTextHTML() {
        return TYPE_TEXT_HTML;
    }

    public static final InternetMediaType getTextPlain() {
        return TYPE_TEXT_PLAIN;
    }

    public static InternetMediaType cloneAndSetParameters(InternetMediaType internetMediaType, String[] stringArray, String[] stringArray2) {
        InternetMediaType internetMediaType2 = new InternetMediaType(internetMediaType);
        if (stringArray == null) {
            internetMediaType2.parameters = new HashMap(0);
        } else {
            internetMediaType2.parameters = new HashMap(stringArray.length);
            internetMediaType2.addParameters(stringArray, stringArray2);
        }
        return internetMediaType2;
    }

    public static InternetMediaType cloneAndSetParameter(InternetMediaType internetMediaType, String string, String string2) {
        InternetMediaType internetMediaType2 = new InternetMediaType(internetMediaType);
        if (string == null) {
            internetMediaType2.parameters = new HashMap(0);
        } else {
            internetMediaType2.parameters = new HashMap(1);
            internetMediaType2.parameters.put(string.trim(), string2.trim());
        }
        return internetMediaType2;
    }

    public static InternetMediaType cloneAndAddParameters(InternetMediaType internetMediaType, String[] stringArray, String[] stringArray2) {
        InternetMediaType internetMediaType2 = new InternetMediaType(internetMediaType);
        internetMediaType2.parameters = new HashMap(internetMediaType.parameters);
        if (stringArray != null) {
            internetMediaType2.addParameters(stringArray, stringArray2);
        }
        return internetMediaType2;
    }

    public static InternetMediaType cloneAndAddParameter(InternetMediaType internetMediaType, String string, String string2) {
        InternetMediaType internetMediaType2 = new InternetMediaType(internetMediaType);
        internetMediaType2.parameters = new HashMap(internetMediaType.parameters);
        if (string != null) {
            internetMediaType2.parameters.put(string.trim(), string2.trim());
        }
        return internetMediaType2;
    }

    private InternetMediaType(InternetMediaType internetMediaType) {
        this.type = internetMediaType.type;
        this.subtype = internetMediaType.subtype;
    }

    public InternetMediaType(String string, String string2) {
        this(string, string2, (String)null, null);
    }

    public InternetMediaType(String string, String string2, String[] stringArray, String[] stringArray2) {
        this.type = string;
        this.subtype = string2;
        if (stringArray == null) {
            this.parameters = new HashMap(0);
        } else {
            this.parameters = new HashMap(stringArray.length);
            this.addParameters(stringArray, stringArray2);
        }
    }

    public InternetMediaType(String string, String string2, String string3, String string4) {
        this.type = string;
        this.subtype = string2;
        if (string3 == null) {
            this.parameters = new HashMap(0);
        } else {
            this.parameters = new HashMap(1);
            this.parameters.put(string3.trim(), string4.trim());
        }
    }

    public InternetMediaType(String string) {
        if (string == null) {
            this.invalid();
            return;
        }
        int n = string.indexOf("/");
        if (n < 1 || n == string.length() - 1) {
            this.invalid();
            return;
        }
        this.type = string.substring(0, n);
        int n2 = string.indexOf(";", n + 1);
        this.subtype = n2 < 0 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        this.parameters = new HashMap();
        while (n2 > 0) {
            int n3 = string.indexOf(";", n2 + 1);
            if (n3 > 0) {
                String string2 = string.substring(n2 + 1, n3);
                int n4 = this.checkQuotation(string2);
                if (n4 > 0) {
                    int n5 = this.searchQuotationEnd(string.substring(n2 + 1), n4 + 1) + n2 + 2;
                    this.addParameter(string.substring(n2 + 1, n5));
                    n2 = string.indexOf(";", n5);
                    continue;
                }
                this.addParameter(string2);
                n2 = n3;
                continue;
            }
            this.addParameter(string.substring(n2 + 1));
            n2 = -1;
        }
    }

    private boolean addParameter(String string) {
        int n = string.indexOf("=");
        if (n < 1 || n == string.length() - 1) {
            return false;
        }
        this.parameters.put(string.substring(0, n).trim(), string.substring(n + 1).trim());
        return true;
    }

    private void addParameters(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.parameters.put(stringArray[i].trim(), stringArray2[i].trim());
        }
    }

    protected void invalid() {
        this.type = null;
        this.subtype = null;
        this.parameters = new HashMap();
    }

    public String getMediaType() {
        return this.type + "/" + this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean hasType(String string, String string2) {
        if (this.type == null || this.subtype == null) {
            return false;
        }
        return this.type.equals(string) && this.subtype.equals(string2);
    }

    public boolean hasMainType(String string) {
        if (this.type == null) {
            return false;
        }
        return this.type.equals(string);
    }

    public boolean hasSubType(String string) {
        if (this.subtype == null) {
            return false;
        }
        return this.subtype.equals(string);
    }

    public String getParameter(String string) {
        return (String)this.parameters.get(string);
    }

    public boolean hasParameter(String string) {
        return this.parameters.containsKey(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append("/");
        stringBuffer.append(this.subtype);
        if (this.parameters != null) {
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.parameters.get(string);
                stringBuffer.append(";" + string + "=" + string2);
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.subtype == null ? 0 : this.subtype.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InternetMediaType internetMediaType = (InternetMediaType)object;
        if (this.subtype == null ? internetMediaType.subtype != null : !this.subtype.equals(internetMediaType.subtype)) {
            return false;
        }
        return !(this.type == null ? internetMediaType.type != null : !this.type.equals(internetMediaType.type));
    }

    private int checkQuotation(String string) {
        int n;
        int n2 = string.indexOf("=");
        return n2 + 1 == (n = string.indexOf("\"")) ? n : 0;
    }

    private int searchQuotationEnd(String string, int n) {
        int n2 = string.indexOf("\"", n);
        while (string.charAt(n2 - 1) == '\\') {
            int n3 = 1;
            int n4 = n2 - 2;
            while (string.charAt(n4) == '\\') {
                ++n3;
                --n4;
            }
            if (n3 % 2 == 0) {
                return n2;
            }
            n2 = string.indexOf("\"", n2 + 1);
        }
        return n2;
    }
}

