/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.structures.UnsupportedOperationException;
import org.ws4d.java.types.URI;

public class URISet {
    private Set uridentifiers = null;
    private boolean readOnly = false;

    public URISet() {
        this.uridentifiers = new HashSet();
    }

    public URISet(int n) {
        this.uridentifiers = new HashSet(n);
    }

    public URISet(URI uRI) {
        this.uridentifiers = new HashSet(1);
        this.add(uRI);
    }

    public URISet(URISet uRISet) {
        this(uRISet == null ? 1 : uRISet.size());
        this.addAll(uRISet);
    }

    public Iterator iterator() {
        if (this.readOnly) {
            return new ReadOnlyIterator(this.uridentifiers);
        }
        return this.uridentifiers.iterator();
    }

    public URI[] toArray() {
        URI[] uRIArray = new URI[this.uridentifiers.size()];
        Object[] objectArray = this.uridentifiers.toArray();
        for (int i = 0; i < uRIArray.length; ++i) {
            uRIArray[i] = (URI)objectArray[i];
        }
        return uRIArray;
    }

    public boolean contains(URI uRI) {
        return this.uridentifiers.contains(uRI);
    }

    public boolean containsAll(URISet uRISet) {
        if (uRISet == null) {
            return true;
        }
        Iterator iterator = uRISet.iterator();
        while (iterator.hasNext()) {
            if (this.uridentifiers.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.uridentifiers.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.uridentifiers.iterator();
        while (iterator.hasNext()) {
            URI uRI = (URI)iterator.next();
            stringBuffer.append(uRI.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof URISet) {
            bl = this.equals((URISet)object);
        }
        return bl;
    }

    public int hashCode() {
        return this.uridentifiers.hashCode();
    }

    public boolean equals(URISet uRISet) {
        if (uRISet != null) {
            return this.uridentifiers.equals(uRISet);
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void add(URI uRI) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("UniformResourceIdentifierList status is READ ONLY!");
        }
        if (uRI != null) {
            this.uridentifiers.add(uRI);
        }
    }

    public void addAll(URISet uRISet) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("UniformResourceIdentifierList status is READ ONLY!");
        }
        if (uRISet == null) {
            return;
        }
        this.uridentifiers.addAll(uRISet.uridentifiers);
    }

    public boolean remove(URI uRI) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("URISet status is READ ONLY!");
        }
        return this.uridentifiers.remove(uRI);
    }
}

