/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.communication.ProtocolException;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.StringUtil;

public class MIMEUtil {
    public static int DEFAULT_MIME_BUFFER = 1024;
    protected static final String FAULT_UNEXPECTED_END = "Unexpected end of stream.";
    protected static final String FAULT_MALFORMED_HEADERFIELD = "Malformed MIME header field.";
    protected static final String FAULT_NOT_FINISHED = "Previous part not finished.";

    public static boolean readBoundary(InputStream inputStream, byte[] byArray) throws IOException {
        int n = -1;
        int n2 = 0;
        int n3 = byArray.length;
        n = inputStream.read();
        if ((byte)n != 45) {
            return false;
        }
        n = inputStream.read();
        if ((byte)n != 45) {
            return false;
        }
        while (n2 < n3 && (n = inputStream.read()) != -1 && (byte)n == byArray[n2]) {
            if (++n2 != n3 || (byte)(n = inputStream.read()) != 13 || (byte)(n = inputStream.read()) != 10) continue;
            return true;
        }
        return false;
    }

    public static void writeBoundary(OutputStream outputStream, byte[] byArray, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            outputStream.write(13);
            outputStream.write(10);
        }
        outputStream.write(45);
        outputStream.write(45);
        outputStream.write(byArray);
        if (bl2) {
            outputStream.write(45);
            outputStream.write(45);
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public static void serializeAttachment(OutputStream outputStream, IncomingAttachment incomingAttachment) throws IOException, AttachmentException {
        int n;
        byte[] byArray = new byte[DEFAULT_MIME_BUFFER];
        InputStream inputStream = incomingAttachment.getInputStream();
        int n2 = 0;
        long l = System.currentTimeMillis();
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        outputStream.flush();
        if (Log.isDebug()) {
            Log.debug("Attachment serialized: " + (System.currentTimeMillis() - l) + "ms. " + n2 + " bytes.", 1);
        }
    }

    public static void writeHeaderFields(OutputStream outputStream, HashMap hashMap) throws IOException {
        if (hashMap == null) {
            outputStream.write(13);
            outputStream.write(10);
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        if (iterator == null) {
            outputStream.write(13);
            outputStream.write(10);
            return;
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            outputStream.write(string.getBytes());
            outputStream.write(58);
            outputStream.write(32);
            outputStream.write(string2.getBytes());
            outputStream.write(13);
            outputStream.write(10);
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    public static void readHeaderFields(InputStream inputStream, HashMap hashMap) throws IOException, ProtocolException {
        int n;
        String string = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = inputStream.read()) != -1) {
            if (string == null) {
                if ((byte)n == 13) {
                    n4 = 1;
                    continue;
                }
                if ((byte)n == 10 && n4 == 1) {
                    n4 = 0;
                    return;
                }
                if ((byte)n == 58) {
                    string = stringBuffer.toString().toLowerCase();
                    stringBuffer = new StringBuffer();
                    n2 = 0;
                    continue;
                }
                if ((byte)n >= 0 && (char)n <= '\u001f') {
                    throw new ProtocolException(FAULT_MALFORMED_HEADERFIELD);
                }
                if ((byte)n == 40 || (byte)n == 41 || (byte)n == 60 || (byte)n == 61 || (byte)n == 62 || (byte)n == 64 || (byte)n == 44 || (byte)n == 63 || (byte)n == 59 || (byte)n == 47 || (byte)n == 92 || (byte)n == 91 || (byte)n == 93 || (byte)n == 123 || (byte)n == 125 || (byte)n == 34 || (byte)n == 32 || (byte)n == 9) {
                    throw new ProtocolException(FAULT_MALFORMED_HEADERFIELD);
                }
            } else {
                if (((byte)n == 32 || (byte)n == 9) && n2 == 0) {
                    stringBuffer.append(' ');
                    ++n2;
                    continue;
                }
                if ((byte)n == 13) {
                    n4 = 1;
                }
                if ((byte)n == 10 && n4 == 1) {
                    n2 = 0;
                    ++n3;
                    n4 = 2;
                }
                if (n3 > 1) {
                    string2 = stringBuffer.toString();
                    string2 = string2.trim();
                    if ((string = string.toLowerCase()).startsWith("content-".toLowerCase())) {
                        hashMap.put(string, string2);
                    }
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                    string = null;
                    string2 = null;
                    return;
                }
                if (n4 > 0) {
                    if (n4 != 2) continue;
                    n4 = 0;
                    continue;
                }
                if (n2 == 0) {
                    string2 = stringBuffer.toString();
                    string2 = string2.trim();
                    if ((string = string.toLowerCase()).startsWith("content-".toLowerCase())) {
                        hashMap.put(string, string2);
                    }
                    stringBuffer = new StringBuffer();
                    string = null;
                    string2 = null;
                }
            }
            stringBuffer.append((char)n);
            ++n2;
            n3 = 0;
            n4 = 0;
        }
        throw new IOException(FAULT_MALFORMED_HEADERFIELD);
    }

    public static String estimateContentType(String string) {
        int n = 0;
        n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return MIMEUtil.extensionContentType(string2);
    }

    public static String contentToExtension(String string) {
        if (MIMEUtil.isValidConstructedMIMEType(string)) {
            int n = string.indexOf("/");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (StringUtil.equalsIgnoreCase(string2, "image")) {
                if (StringUtil.equalsIgnoreCase(string3, "gif")) {
                    return "*.gif";
                }
                if (StringUtil.equalsIgnoreCase(string3, "jpeg")) {
                    return "*.jpg";
                }
                if (StringUtil.equalsIgnoreCase(string3, "png")) {
                    return "*.png";
                }
                if (StringUtil.equalsIgnoreCase(string3, "tiff")) {
                    return "*.tiff";
                }
                if (StringUtil.equalsIgnoreCase(string3, "x-icon")) {
                    return "*.ico";
                }
            } else if (StringUtil.equalsIgnoreCase(string2, "text")) {
                if (StringUtil.equalsIgnoreCase(string3, "css")) {
                    return "*.css";
                }
                if (StringUtil.equalsIgnoreCase(string3, "html")) {
                    return "*.htm";
                }
                if (StringUtil.equalsIgnoreCase(string3, "javascript")) {
                    return "*.js";
                }
                if (StringUtil.equalsIgnoreCase(string3, "plain")) {
                    return "*.txt";
                }
                if (StringUtil.equalsIgnoreCase(string3, "rtf")) {
                    return "*.rtf";
                }
                if (StringUtil.equalsIgnoreCase(string3, "soap+xml")) {
                    return "*.xml";
                }
            } else if (StringUtil.equalsIgnoreCase(string2, "application")) {
                if (StringUtil.equalsIgnoreCase(string3, "msexcel")) {
                    return "*.xls";
                }
                if (StringUtil.equalsIgnoreCase(string3, "msword")) {
                    return "*.doc";
                }
                if (StringUtil.equalsIgnoreCase(string3, "x-rar-compressed")) {
                    return "*.rar";
                }
                if (StringUtil.equalsIgnoreCase(string3, "pdf")) {
                    return "*.pdf";
                }
                if (StringUtil.equalsIgnoreCase(string3, "x-shockwave-flash")) {
                    return "*.swf";
                }
                if (StringUtil.equalsIgnoreCase(string3, "octet-stream")) {
                    return "*.exe";
                }
                if (StringUtil.equalsIgnoreCase(string3, "zip")) {
                    return "*.zip";
                }
            } else if (StringUtil.equalsIgnoreCase(string2, "video")) {
                if (StringUtil.equalsIgnoreCase(string3, "x-ms-wmv")) {
                    return "*.wmv";
                }
                if (StringUtil.equalsIgnoreCase(string3, "x-msvideo")) {
                    return "*.avi";
                }
            } else if (StringUtil.equalsIgnoreCase(string2, "audio") && StringUtil.equalsIgnoreCase(string3, "x-mpeg")) {
                return "*.mp3";
            }
        }
        return "*.*";
    }

    public static String extensionContentType(String string) {
        if (StringUtil.equalsIgnoreCase(string, "jpg") || StringUtil.equalsIgnoreCase(string, "jpeg")) {
            return "image/jpeg";
        }
        if (StringUtil.equalsIgnoreCase(string, "txt")) {
            return "text/plain";
        }
        if (StringUtil.equalsIgnoreCase(string, "gif")) {
            return "image/gif";
        }
        if (StringUtil.equalsIgnoreCase(string, "png")) {
            return "image/png";
        }
        if (StringUtil.equalsIgnoreCase(string, "tiff")) {
            return "image/tiff";
        }
        if (StringUtil.equalsIgnoreCase(string, "tif")) {
            return "image/tiff";
        }
        if (StringUtil.equalsIgnoreCase(string, "htm") || StringUtil.equalsIgnoreCase(string, "html")) {
            return "text/html";
        }
        if (StringUtil.equalsIgnoreCase(string, "xml")) {
            return "text/xml";
        }
        if (StringUtil.equalsIgnoreCase(string, "js")) {
            return "text/javascript";
        }
        if (StringUtil.equalsIgnoreCase(string, "css")) {
            return "text/css";
        }
        if (StringUtil.equalsIgnoreCase(string, "zip")) {
            return "application/zip";
        }
        if (StringUtil.equalsIgnoreCase(string, "pdf")) {
            return "application/pdf";
        }
        if (StringUtil.equalsIgnoreCase(string, "wmv")) {
            return "video/x-ms-wmv";
        }
        if (StringUtil.equalsIgnoreCase(string, "rar")) {
            return "application/x-rar-compressed";
        }
        if (StringUtil.equalsIgnoreCase(string, "swf")) {
            return "application/x-shockwave-flash";
        }
        if (StringUtil.equalsIgnoreCase(string, "exe")) {
            return "application/octet-stream";
        }
        if (StringUtil.equalsIgnoreCase(string, "avi")) {
            return "video/x-msvideo";
        }
        if (StringUtil.equalsIgnoreCase(string, "doc") || StringUtil.equalsIgnoreCase(string, "dot")) {
            return "application/msword";
        }
        if (StringUtil.equalsIgnoreCase(string, "ico")) {
            return "image/x-icon";
        }
        if (StringUtil.equalsIgnoreCase(string, "mp2") || StringUtil.equalsIgnoreCase(string, "mp3")) {
            return "audio/x-mpeg";
        }
        if (StringUtil.equalsIgnoreCase(string, "rtf")) {
            return "text/rtf";
        }
        if (StringUtil.equalsIgnoreCase(string, "xls") || StringUtil.equalsIgnoreCase(string, "xla")) {
            return "application/msexcel";
        }
        return "text/plain";
    }

    private static boolean isValidConstructedMIMEType(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        int n = string.indexOf("/");
        if (n == -1) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        return string.length() > n + 1;
    }
}

