/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.io.IOException;
import java.io.InputStream;

public class Search {
    public static int[] createFaultFunction(byte[] byArray) {
        int[] nArray = new int[byArray.length + 1];
        int n = 0;
        int n2 = -1;
        nArray[0] = -1;
        while (n < byArray.length) {
            while (n2 >= 0 && byArray[n] != byArray[n2]) {
                n2 = nArray[n2];
            }
            nArray[++n] = ++n2;
        }
        return nArray;
    }

    public static InputStream getSearchPatternWrapper(InputStream inputStream, byte[] byArray) {
        return new KMPAlgoInputStream(inputStream, byArray);
    }

    public static InputStream getSearchPatternWrapper(InputStream inputStream, byte[] byArray, int[] nArray) {
        return new KMPAlgoInputStream(inputStream, byArray);
    }

    private static class KMPAlgoInputStream
    extends InputStream {
        private InputStream in = null;
        private byte[] pattern = null;
        private int[] faultFunction = null;
        private int patternPos = 0;
        private int virtualBufferSize = 0;
        private int returnedBytesCount = 0;
        private int readByte;

        public KMPAlgoInputStream(InputStream inputStream, byte[] byArray) {
            this(inputStream, byArray, Search.createFaultFunction(byArray));
        }

        public KMPAlgoInputStream(InputStream inputStream, byte[] byArray, int[] nArray) {
            this.in = inputStream;
            this.pattern = byArray;
            this.faultFunction = nArray;
        }

        public synchronized int available() throws IOException {
            if (this.virtualBufferSize == -42) {
                return 0;
            }
            int n = this.virtualBufferSize - this.returnedBytesCount - this.patternPos;
            if (n > 0) {
                return n;
            }
            return 0;
        }

        public synchronized int read() throws IOException {
            if (this.virtualBufferSize == -42) {
                return -1;
            }
            int n = this.virtualBufferSize - this.returnedBytesCount - this.patternPos;
            if (n > 0) {
                if (n == 1) {
                    int n2 = this.patternPos == 0 ? this.readByte : this.pattern[this.returnedBytesCount];
                    this.virtualBufferSize = this.patternPos;
                    this.returnedBytesCount = 0;
                    return n2;
                }
                return this.pattern[this.returnedBytesCount++];
            }
            do {
                this.readByte = this.in.read();
                ++this.virtualBufferSize;
                if (this.readByte != -1) {
                    while (this.patternPos >= 0 && this.readByte != this.pattern[this.patternPos]) {
                        this.patternPos = this.faultFunction[this.patternPos];
                    }
                    ++this.patternPos;
                }
                if (this.patternPos != this.pattern.length) continue;
                this.virtualBufferSize = -42;
                return -1;
            } while (this.virtualBufferSize <= this.patternPos);
            if (this.virtualBufferSize == 1) {
                this.virtualBufferSize = 0;
                return this.readByte;
            }
            if (this.virtualBufferSize - this.patternPos == 1) {
                this.virtualBufferSize = this.patternPos;
            } else {
                this.returnedBytesCount = 1;
            }
            return this.pattern[0];
        }
    }
}

