/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.utils;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class Concurrency {
    public static void waitExecutor(ExecutorService executor, int timeoutMinutes, TimeUnit timeUnit, Logger logger) {
        executor.shutdown();
        boolean status = false;
        try {
            status = executor.awaitTermination(timeoutMinutes, timeUnit);
        }
        catch (InterruptedException e) {
            Concurrency.logErrorMessage("Interrupted thread! Should not happen!", logger);
        }
        if (!status) {
            Concurrency.logErrorMessage("Executor status is False. Probably there is some problem!", logger);
        }
        executor.shutdownNow();
    }

    public static void waitExecutor(ExecutorService executor, int timeoutMinutes) {
        Concurrency.waitExecutor(executor, timeoutMinutes, TimeUnit.MINUTES, null);
    }

    public static void waitExecutor(ExecutorService executor, int timeoutMinutes, Logger logger) {
        Concurrency.waitExecutor(executor, timeoutMinutes, TimeUnit.MINUTES, logger);
    }

    private static void logErrorMessage(String msg, Logger logger) {
        if (logger != null) {
            logger.error((Object)msg);
        } else {
            System.out.println(msg);
        }
    }

    public static <T> T checkFuture(Future<T> f) throws ExecutionException {
        T result = null;
        try {
            if (!f.isDone()) {
                f.cancel(true);
                throw new IllegalStateException("Future not done, therefore canceled");
            }
            result = f.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (CancellationException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }
}

