/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.ow2.choreos.utils.Concurrency;
import org.ow2.choreos.utils.SshNotConnected;
import org.ow2.choreos.utils.SshUtil;

public class SshWaiter {
    private Logger logger = Logger.getLogger(SshWaiter.class);

    public SshUtil waitSsh(String ip, String user, String keyPath, int timeoutSeconds) throws SshNotConnected {
        SshWaiterCallable callable = new SshWaiterCallable(ip, user, keyPath);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<SshUtil> future = executor.submit(callable);
        Concurrency.waitExecutor(executor, timeoutSeconds, TimeUnit.SECONDS, this.logger);
        try {
            SshUtil ssh = Concurrency.checkFuture(future);
            if (ssh != null) {
                return ssh;
            }
            throw new SshNotConnected("Could not SSH into " + ip);
        }
        catch (ExecutionException e) {
            throw new SshNotConnected("Could not SSH into " + ip);
        }
        catch (IllegalStateException e) {
            throw new SshNotConnected("Could not SSH into " + ip);
        }
    }

    private class SshWaiterCallable
    implements Callable<SshUtil> {
        private String ip;
        private String user;
        private String keyPath;

        public SshWaiterCallable(String ip, String user, String keyPath) {
            this.ip = ip;
            this.user = user;
            this.keyPath = keyPath;
        }

        @Override
        public SshUtil call() throws Exception {
            SshWaiter.this.logger.debug((Object)("Waiting for SSH to " + this.ip));
            SshUtil ssh = new SshUtil(this.ip, this.user, this.keyPath);
            while (!ssh.isAccessible()) {
                SshWaiter.this.logger.debug((Object)("Trying SSH into " + this.ip + " again in 5 seconds"));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    String msg = "VM " + this.ip + " not accessible!";
                    SshWaiter.this.logger.warn((Object)msg);
                    throw new IllegalStateException(msg);
                }
            }
            ssh.disconnect();
            SshWaiter.this.logger.debug((Object)("Connected to " + this.ip));
            return ssh;
        }
    }
}

