/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors;

import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ow2.choreos.chors.ChorRegistry;
import org.ow2.choreos.chors.ChoreographyDeployer;
import org.ow2.choreos.chors.ChoreographyNotFoundException;
import org.ow2.choreos.chors.Configuration;
import org.ow2.choreos.chors.Deployer;
import org.ow2.choreos.chors.EnactmentException;
import org.ow2.choreos.chors.bus.ESBNodesSelector;
import org.ow2.choreos.chors.bus.ESBNodesSelectorFactory;
import org.ow2.choreos.chors.bus.EasyESBNode;
import org.ow2.choreos.chors.bus.ServiceInstancesProxifier;
import org.ow2.choreos.chors.context.ContextCaster;
import org.ow2.choreos.chors.context.ContextSender;
import org.ow2.choreos.chors.context.ContextSenderFactory;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographyService;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;
import org.ow2.choreos.services.datamodel.ServiceInstance;
import org.ow2.choreos.services.datamodel.ServiceType;

public class ChoreographyDeployerImpl
implements ChoreographyDeployer {
    private Logger logger = Logger.getLogger(ChoreographyDeployerImpl.class);
    private ChorRegistry reg = ChorRegistry.getInstance();

    public String createChoreography(ChoreographySpec chor) {
        String chorId = this.reg.create(chor);
        this.logger.info((Object)("Choreography " + chorId + " created."));
        return chorId;
    }

    public Choreography getChoreography(String chorId) {
        Choreography chor = this.reg.get(chorId);
        return chor;
    }

    public Choreography enactChoreography(String chorId) throws EnactmentException, ChoreographyNotFoundException {
        this.logger.info((Object)("Requested to enact choreography " + chorId));
        Choreography chor = this.reg.get(chorId);
        if (chor == null) {
            this.logger.info((Object)("Could not get choreography with ID = " + chorId));
            throw new ChoreographyNotFoundException(chorId);
        }
        if (chor.getChoreographySpec() == chor.getRequestedChoreographySpec()) {
            this.logger.info((Object)("Starting enactment; chorId= " + chorId));
        } else if (chor.getChoreographySpec() == chor.getRequestedChoreographySpec()) {
            this.logger.info((Object)("Starting enactment for requested update; chorId= " + chorId));
        }
        Deployer deployer = new Deployer();
        Map<String, ChoreographyService> deployedMap = deployer.deployChoreographyServices(chor);
        chor.setChoreographyServices(new ArrayList<ChoreographyService>(deployedMap.values()));
        this.logger.info((Object)("Deployed services=" + deployedMap));
        boolean useTheBus = Boolean.parseBoolean(Configuration.get(Configuration.Option.BUS));
        if (useTheBus) {
            this.logger.info((Object)"Resquested to proxify depoloyed services");
            this.proxifyServices(chor);
        }
        ContextSender sender = ContextSenderFactory.getInstance(ServiceType.SOAP);
        ContextCaster caster = new ContextCaster(sender);
        this.logger.info((Object)"Resquested to cast service context");
        caster.cast(chor.getRequestedChoreographySpec(), deployedMap);
        this.logger.info((Object)("Going to set choreography " + chorId + " as deployed"));
        chor.finishChoreographyEnactment();
        this.logger.info((Object)("Enactment completed; chorId=" + chorId));
        return chor;
    }

    public void updateChoreography(String chorId, ChoreographySpec spec) throws ChoreographyNotFoundException {
        this.logger.info((Object)("Requested to update choreography " + chorId));
        Choreography chor = this.reg.get(chorId);
        if (chor == null) {
            this.logger.info((Object)("Could not get choreography with ID = " + chorId));
            throw new ChoreographyNotFoundException(chorId);
        }
        if (spec.equals((Object)chor.getChoreographySpec())) {
            this.logger.info((Object)"Requested to update choreography with the same spec that already have");
            return;
        }
        this.logger.info((Object)("Starting update on choreography with ID " + chorId));
        this.logger.info((Object)("Updating choreography spec of choreography " + chorId));
        chor.setChoreographySpec(spec);
        this.logger.info((Object)("Choreography spec updated for choreography " + chorId));
        this.logger.info((Object)("Choreography " + chorId + " ready to be re-enacted"));
    }

    private void proxifyServices(Choreography choreography) {
        ESBNodesSelector selector = null;
        try {
            String esbSelectorType = Configuration.get(Configuration.Option.BUS_POLICY);
            selector = ESBNodesSelectorFactory.getInstance(esbSelectorType);
        }
        catch (IllegalArgumentException e) {
            this.logger.error((Object)"Not going to proxify services because invalid ESBNodesSelector type.");
            return;
        }
        Map<ServiceInstance, EasyESBNode> instancesNodesMap = selector.selectESBNodes(choreography);
        ServiceInstancesProxifier proxifier = new ServiceInstancesProxifier();
        proxifier.proxify(instancesNodesMap);
    }
}

