/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private static String PROPERTIES_FILE = "chordeployer.properties";
    private static Configuration INSTANCE = new Configuration();
    private final Properties properties = new Properties();

    private Properties getProperties() {
        return this.properties;
    }

    public static String get(Option key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        String value = INSTANCE.getProperties().getProperty(key.toString());
        if (value != null) {
            value.trim();
        }
        return value;
    }

    public static void set(Option key, String value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        INSTANCE.getProperties().setProperty(key.toString(), value);
    }

    private Configuration() {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream propFile = loader.getResourceAsStream(PROPERTIES_FILE);
            if (propFile != null) {
                this.properties.load(propFile);
                propFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum Option {
        CHOR_DEPLOYER_PORT,
        DEPLOYMENT_MANAGER_URI,
        BUS,
        BUS_POLICY;

    }
}

