/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.bus;

import org.apache.log4j.Logger;
import org.ow2.choreos.chors.Configuration;
import org.ow2.choreos.chors.bus.AlwaysCreateESBNodeSelector;
import org.ow2.choreos.chors.bus.ESBNodesSelector;
import org.ow2.choreos.chors.bus.SingleESBNodeSelector;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.client.NodesClient;

public class ESBNodesSelectorFactory {
    private static Logger logger = Logger.getLogger(ESBNodesSelectorFactory.class);

    public static ESBNodesSelector getInstance(String type) {
        try {
            SelectorType selectorType = SelectorType.valueOf(type);
            return ESBNodesSelectorFactory.getInstance(selectorType);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Invalid ESBNodesSelector type: " + type));
            throw e;
        }
    }

    private static ESBNodesSelector getInstance(SelectorType type) {
        String host = Configuration.get(Configuration.Option.DEPLOYMENT_MANAGER_URI);
        NodesClient npm = new NodesClient(host);
        switch (type) {
            case SINGLE_NODE: {
                return new SingleESBNodeSelector((NodePoolManager)npm);
            }
            case ALWAYS_CREATE: {
                return new AlwaysCreateESBNodeSelector((NodePoolManager)npm);
            }
        }
        throw new IllegalArgumentException("Invalid ESBNodesSelector type: " + (Object)((Object)type));
    }

    private static enum SelectorType {
        SINGLE_NODE,
        ALWAYS_CREATE;

    }
}

