/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.datamodel.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;
import org.w3c.dom.Document;

public class SchemaGenerator {
    private Logger logger = Logger.getLogger(SchemaGenerator.class);

    public String generateChorSpecSchema() {
        try {
            return this.generateSchema(ChoreographySpec.class);
        }
        catch (JAXBException e) {
            this.logger.error((Object)"It should never happen");
            return null;
        }
        catch (IOException e) {
            this.logger.error((Object)"It should never happen");
            return null;
        }
    }

    public String generateChoreographySchema() {
        try {
            return this.generateSchema(Choreography.class);
        }
        catch (JAXBException e) {
            this.logger.error((Object)"It should never happen");
            return null;
        }
        catch (IOException e) {
            this.logger.error((Object)"It should never happen");
            return null;
        }
    }

    private String generateSchema(Class<?> clazz) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        final ArrayList results = new ArrayList();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        DOMResult domResult = (DOMResult)results.get(0);
        Document doc = (Document)domResult.getNode();
        OutputFormat format = new OutputFormat(doc);
        format.setIndenting(true);
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.serialize(doc);
        return writer.toString();
    }

    public static void main(String[] args) {
        SchemaGenerator gen = new SchemaGenerator();
        System.out.println("ChorSpec XSD:");
        System.out.println(gen.generateChorSpecSchema());
        System.out.println("\nChoreography XSD:");
        System.out.println(gen.generateChoreographySchema());
    }
}

