/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.datamodel;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.choreos.chors.datamodel.ChoreographyService;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;

@XmlRootElement
public class Choreography {
    private String id;
    private ChoreographySpec choreographySpec = null;
    private List<ChoreographyService> choreographyServices;
    private ChoreographySpec requestedChoreographySpec = null;

    public ChoreographyService getDeployedChoreographyServiceByChoreographyServiceUID(String choreographyServiceUID) {
        List<ChoreographyService> deployedServices = this.getChoreographyServices();
        for (ChoreographyService svc : deployedServices) {
            if (!choreographyServiceUID.equals(svc.getChoreographyServiceSpec().getChoreographyServiceUID())) continue;
            return svc;
        }
        throw new IllegalArgumentException("Service named " + choreographyServiceUID + " does not exist");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChoreographySpec getChoreographySpec() {
        return this.choreographySpec;
    }

    public ChoreographySpec getRequestedChoreographySpec() {
        return this.requestedChoreographySpec;
    }

    public void setChoreographySpec(ChoreographySpec spec) {
        if (this.choreographySpec == null) {
            this.choreographySpec = spec;
        }
        this.requestedChoreographySpec = spec;
    }

    public void finishChoreographyEnactment() {
        this.choreographySpec = this.requestedChoreographySpec;
    }

    public List<ChoreographyService> getChoreographyServices() {
        if (this.choreographyServices == null) {
            this.choreographyServices = new ArrayList<ChoreographyService>();
        }
        return this.choreographyServices;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Choreography other = (Choreography)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Choreography [id=" + this.id + ", chorSpec=" + this.choreographySpec + ", deployedServices=" + this.getChoreographyServices() + ", requestedChorSpec=" + this.requestedChoreographySpec + "]";
    }

    public void addChoreographyService(ChoreographyService choreographyService) {
        this.getChoreographyServices().add(choreographyService);
    }

    public void setChoreographyServices(List<ChoreographyService> choreographyServices) {
        this.choreographyServices = choreographyServices;
    }
}

