/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.ow2.choreos.chors.datamodel.ChoreographyServiceDependency;
import org.ow2.choreos.services.datamodel.ServiceSpec;

public class ChoreographyServiceSpec {
    private ServiceSpec serviceSpec;
    private String owner;
    private String group;
    private List<String> roles;
    private List<ChoreographyServiceDependency> dependencies;
    private String choreographyServiceUID;

    public ChoreographyServiceSpec() {
    }

    public ChoreographyServiceSpec(ServiceSpec serviceSpec, String owner, String group, List<String> roles, String choreographyServiceUID) {
        this.serviceSpec = serviceSpec;
        this.owner = owner;
        this.group = group;
        this.roles = roles;
        this.choreographyServiceUID = choreographyServiceUID;
    }

    public ChoreographyServiceSpec(ServiceSpec serviceSpec, String owner, String group, List<String> roles, List<ChoreographyServiceDependency> dependencies, String choreographyServiceUID) {
        this.serviceSpec = serviceSpec;
        this.owner = owner;
        this.group = group;
        this.roles = roles;
        this.dependencies = dependencies;
        this.choreographyServiceUID = choreographyServiceUID;
    }

    public ServiceSpec getServiceSpec() {
        return this.serviceSpec;
    }

    public void setServiceSpec(ServiceSpec serviceSpec) {
        this.serviceSpec = serviceSpec;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        this.roles.add(role);
    }

    public void addAllRoles(List<String> roles) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        roles.addAll(roles);
    }

    public List<ChoreographyServiceDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ChoreographyServiceDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(ChoreographyServiceDependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ChoreographyServiceDependency>();
        }
        this.dependencies.add(dependency);
    }

    public void addDependencies(List<ChoreographyServiceDependency> dependencies) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ChoreographyServiceDependency>();
        }
        this.dependencies.addAll(dependencies);
    }

    public String getChoreographyServiceUID() {
        return this.choreographyServiceUID;
    }

    public void setChoreographyServiceUID(String choreographyServiceUID) {
        this.choreographyServiceUID = choreographyServiceUID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.choreographyServiceUID == null ? 0 : this.choreographyServiceUID.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.roles == null ? 0 : ((Object)this.roles).hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.serviceSpec == null ? 0 : this.serviceSpec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoreographyServiceSpec other = (ChoreographyServiceSpec)obj;
        if (this.choreographyServiceUID == null ? other.choreographyServiceUID != null : !this.choreographyServiceUID.equals(other.choreographyServiceUID)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !((Object)this.roles).equals(other.roles)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        return !(this.serviceSpec == null ? other.serviceSpec != null : !this.serviceSpec.equals(other.serviceSpec));
    }

    public String toString() {
        return "ChoreographyServiceSpec [uid=" + this.choreographyServiceUID + ", owner=" + this.owner + ", group=" + this.group + ", roles=" + this.roles + ", dependencies=" + this.dependencies + ", serviceSpec=" + this.serviceSpec;
    }
}

