/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.nodes.datamodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.choreos.nodes.datamodel.NodeRestRepresentation;

public class Node {
    private String id;
    private Integer cpus;
    private Integer ram;
    private Integer storage;
    private String so;
    private String zone;
    private String ip;
    private String hostname;
    private String user;
    private String privateKeyFile;
    private String image;
    private Integer state;
    private String chefName;
    static Pattern IP_PATTERN = Pattern.compile("(\\d{1,4}\\.){3}\\d{1,4}");

    public Node() {
    }

    public Node(NodeRestRepresentation rest) {
        this.cpus = rest.cpus;
        this.hostname = rest.hostname;
        this.id = rest.id;
        this.image = rest.image;
        this.ip = rest.ip;
        this.ram = rest.ram;
        this.storage = rest.storage;
        this.so = rest.so;
        this.zone = rest.zone;
        this.state = rest.state;
    }

    public NodeRestRepresentation getRestRepresentation() {
        NodeRestRepresentation rest = new NodeRestRepresentation();
        rest.cpus = this.cpus;
        rest.hostname = this.hostname;
        rest.id = this.id;
        rest.image = this.image;
        rest.ip = this.ip;
        rest.ram = this.ram;
        rest.storage = this.storage;
        rest.so = this.so;
        rest.zone = this.zone;
        rest.state = this.state;
        return rest;
    }

    public boolean hasIp() {
        if (this.ip == null || this.ip.isEmpty()) {
            return false;
        }
        Matcher matcher = IP_PATTERN.matcher(this.ip);
        return matcher.matches();
    }

    public String getChefName() {
        return this.chefName;
    }

    public void setChefName(String chefName) {
        this.chefName = chefName;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getCpus() {
        return this.cpus;
    }

    public void setCpus(Integer cpus) {
        this.cpus = cpus;
    }

    public Integer getRam() {
        return this.ram;
    }

    public void setRam(Integer ram) {
        this.ram = ram;
    }

    public Integer getStorage() {
        return this.storage;
    }

    public void setStorage(Integer storage) {
        this.storage = storage;
    }

    public String getSo() {
        return this.so;
    }

    public void setSo(String so) {
        this.so = so;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKey(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.chefName == null ? 0 : this.chefName.hashCode());
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.chefName == null ? other.chefName != null : !this.chefName.equals(other.chefName)) {
            return false;
        }
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.ip == null ? other.ip != null : !this.ip.equals(other.ip));
    }

    public String toString() {
        return "Node [id=" + this.id + ", ip=" + this.ip + ", hostname=" + this.hostname + ", chefName=" + this.chefName + "]";
    }
}

