/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.services.client;

import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang.NotImplementedException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.choreos.services.ServiceNotDeployedException;
import org.ow2.choreos.services.ServiceNotFoundException;
import org.ow2.choreos.services.ServiceNotModifiedException;
import org.ow2.choreos.services.ServicesManager;
import org.ow2.choreos.services.datamodel.DeployableService;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;

public class ServicesClient
implements ServicesManager {
    private String host;

    public ServicesClient(String host) {
        this.host = host;
    }

    private WebClient setupClient() {
        WebClient client = WebClient.create((String)this.host);
        HTTPConduit http = (HTTPConduit)WebClient.getConfig((Object)client).getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        http.setClient(httpClientPolicy);
        return client;
    }

    @Override
    public DeployableService createService(DeployableServiceSpec serviceSpec) throws ServiceNotDeployedException {
        WebClient client = this.setupClient();
        client.path((Object)"services");
        DeployableService service = null;
        try {
            service = (DeployableService)client.post((Object)serviceSpec, DeployableService.class);
        }
        catch (WebApplicationException e) {
            throw new ServiceNotDeployedException(serviceSpec.getUUID());
        }
        return service;
    }

    @Override
    public DeployableService getService(String uuid) throws ServiceNotFoundException {
        WebClient client = this.setupClient();
        client.path((Object)"services").path((Object)uuid);
        DeployableService service = null;
        try {
            service = (DeployableService)client.get(null);
        }
        catch (WebApplicationException e) {
            // empty catch block
        }
        return service;
    }

    @Override
    public void deleteService(String uuid) {
        throw new NotImplementedException();
    }

    @Override
    public DeployableService updateService(DeployableServiceSpec serviceSpec) throws ServiceNotModifiedException {
        WebClient client = this.setupClient();
        client.path((Object)"services").path((Object)serviceSpec.getUUID());
        DeployableService service = null;
        try {
            service = (DeployableService)client.post((Object)serviceSpec, DeployableService.class);
        }
        catch (WebApplicationException e) {
            throw new ServiceNotModifiedException(serviceSpec.getUUID(), e.getMessage());
        }
        return service;
    }
}

