/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.services.datamodel;

import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.choreos.services.datamodel.PackageType;
import org.ow2.choreos.services.datamodel.ResourceImpact;
import org.ow2.choreos.services.datamodel.ServiceSpec;
import org.ow2.choreos.services.datamodel.ServiceType;

@XmlRootElement
public class DeployableServiceSpec
extends ServiceSpec {
    protected ResourceImpact resourceImpact;
    protected String version;
    protected String packageUri;
    protected int port;
    protected String endpointName;
    private int numberOfInstances = 1;

    public DeployableServiceSpec() {
        super(null, null);
    }

    public DeployableServiceSpec(ServiceType serviceType, PackageType packageType, ResourceImpact resourceImpact, String version, String packageUri, int port, String endpointName, int numberOfInstances) {
        super(serviceType, packageType);
        this.resourceImpact = resourceImpact;
        this.version = version;
        this.packageUri = packageUri;
        this.port = port;
        this.endpointName = endpointName;
        this.numberOfInstances = numberOfInstances;
    }

    public DeployableServiceSpec(ServiceType serviceType, PackageType packageType, ResourceImpact resourceImpact, String version, String packageUri, String endpointName, int numberOfInstances) {
        super(serviceType, packageType);
        this.resourceImpact = resourceImpact;
        this.version = version;
        this.packageUri = packageUri;
        this.endpointName = endpointName;
        this.numberOfInstances = numberOfInstances;
    }

    public String getPackageUri() {
        return this.packageUri;
    }

    public void setPackageUri(String uri) {
        this.packageUri = uri;
    }

    public ResourceImpact getResourceImpact() {
        return this.resourceImpact;
    }

    public void setResourceImpact(ResourceImpact resourceImpact) {
        this.resourceImpact = resourceImpact;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getFileName() {
        String fileName = "";
        String extension = this.packageType.getExtension();
        String[] urlPieces = this.getPackageUri().split("/");
        if (urlPieces[urlPieces.length - 1].contains("." + extension)) {
            fileName = urlPieces[urlPieces.length - 1];
        }
        return fileName;
    }

    public int getPort() {
        int effectivePort = this.port;
        if (this.notDefinedPort()) {
            if (this.packageType == PackageType.TOMCAT) {
                effectivePort = 8080;
            }
            if (this.packageType == PackageType.EASY_ESB) {
                effectivePort = 8180;
            }
        }
        return effectivePort;
    }

    private boolean notDefinedPort() {
        return this.port == 0;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    @Override
    public void setNumberOfInstances(int numberOfInstances) {
        this.numberOfInstances = numberOfInstances > 0 ? numberOfInstances : 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.resourceImpact == null ? 0 : this.resourceImpact.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.packageUri == null ? 0 : this.packageUri.hashCode());
        result = 31 * result + (this.endpointName == null ? 0 : this.endpointName.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DeployableServiceSpec other = (DeployableServiceSpec)obj;
        if (this.resourceImpact == null ? other.resourceImpact != null : !this.resourceImpact.equals(other.resourceImpact)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.packageUri == null ? other.packageUri != null : !this.packageUri.equals(other.packageUri)) {
            return false;
        }
        if (this.endpointName == null ? other.endpointName != null : !this.endpointName.equals(other.endpointName)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.numberOfInstances == other.numberOfInstances;
    }

    public String toString() {
        return "ServiceSpec [type=" + (Object)((Object)this.serviceType) + ", artifactType=" + (Object)((Object)this.packageType) + ", packageUri=" + this.packageUri + ", port=" + this.port + ", endpointName=" + this.endpointName + ", version=" + this.version + ", #instances=" + this.numberOfInstances + "]";
    }
}

